/*
 * Decompiled with CFR 0.152.
 */
package neatwork.utils;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.io.BufferedReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.ToolTipManager;
import neatwork.Messages;
import neatwork.utils.Same;

public class Tools {
    static String repertoire = "";

    public static Vector readCSV(String contenu) {
        Vector v = new Vector();
        StringTokenizer stline = new StringTokenizer(contenu, "\n\r");
        while (stline.hasMoreTokens()) {
            String line = stline.nextToken();
            StringTokenizer st = new StringTokenizer(line, ",");
            Vector<String> data = new Vector<String>();
            while (st.hasMoreTokens()) {
                data.add(st.nextToken());
            }
            v.add(data);
        }
        return v;
    }

    public static String doubleFormat(String mask, double d) {
        DecimalFormat df = new DecimalFormat(mask);
        df.setDecimalFormatSymbols(new DecimalFormatSymbols(Locale.US));
        return df.format(d);
    }

    public static String getTxt(Vector data, String delimiter) {
        String s = "";
        int i = 0;
        while (i < data.size()) {
            String line = "";
            Vector vline = (Vector)data.get(i);
            int j = 0;
            while (j < vline.size()) {
                line = String.valueOf(line) + vline.get(j).toString() + ',';
                ++j;
            }
            line = line.substring(0, line.length() - 1);
            s = String.valueOf(s) + line + "\n";
            ++i;
        }
        return s;
    }

    public static String getTxt(Vector data) {
        return Tools.getTxt(data, ",");
    }

    public static String readStream(InputStream input) {
        String data = "";
        BufferedReader in = new BufferedReader(new InputStreamReader(input));
        String line = "";
        try {
            while ((line = in.readLine()) != null) {
                data = String.valueOf(data) + line + "\n";
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return data;
    }

    public static int findIndex(List list, Same object) {
        Iterator iter = list.iterator();
        boolean find = false;
        int index = -1;
        int i = 0;
        while (i < list.size() && index == -1) {
            if (((Same)iter.next()).isSame(object)) {
                index = i;
            }
            ++i;
        }
        return index;
    }

    public static JPanel getPanelTable(String title, Action[] actions, JTable jTable) {
        JPanel main = new JPanel(new BorderLayout(5, 5));
        main.add((Component)new JLabel(title), "North");
        main.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        JPanel jPanelTop = new JPanel(new FlowLayout(0, 3, 3));
        int i = 0;
        while (i < actions.length) {
            if (actions[i] == null) {
                jPanelTop.add(new JLabel(" "));
            } else {
                JButton jbutton = new JButton(actions[i]);
                jPanelTop.add(jbutton);
                if (jbutton.getIcon() != null) {
                    jbutton.setText("");
                }
                jbutton.setBorder(BorderFactory.createEtchedBorder());
            }
            ++i;
        }
        JPanel jPanel2 = new JPanel(new BorderLayout(2, 2));
        jPanel2.add((Component)jPanelTop, "North");
        JScrollPane jScrollPane = new JScrollPane(jTable);
        jScrollPane.setVerticalScrollBarPolicy(20);
        jScrollPane.setHorizontalScrollBarPolicy(30);
        ToolTipManager.sharedInstance().unregisterComponent(jTable);
        ToolTipManager.sharedInstance().unregisterComponent(jTable.getTableHeader());
        jPanel2.add((Component)jScrollPane, "West");
        main.add((Component)jPanel2, "Center");
        return main;
    }

    public static void enregFich(String texte) {
        JFileChooser fc = repertoire.equals("") ? new JFileChooser() : new JFileChooser(repertoire);
        if (fc.showSaveDialog(null) == 0) {
            boolean isok = true;
            if (fc.getSelectedFile().exists()) {
                isok = false;
                if (JOptionPane.showConfirmDialog(null, Messages.getString("Tools.Do_you_really_want_to_overwrite_the_existing_file"), Messages.getString("Tools.Confirmation_Dialog"), 0) == 0) {
                    isok = true;
                }
            }
            if (isok) {
                String f = fc.getSelectedFile().getAbsolutePath();
                if (!f.endsWith("html") && !f.endsWith("htm")) {
                    f = String.valueOf(f) + ".html";
                }
                try {
                    FileWriter fw = new FileWriter(f);
                    fw.write(texte);
                    fw.flush();
                    fw.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
        repertoire = fc.getCurrentDirectory().getAbsolutePath();
    }
}

