/*
 * Decompiled with CFR 0.152.
 */
package neatwork.utils;

import java.awt.Color;
import java.awt.Component;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.swing.JProgressBar;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;

public class ProgressCellRenderer
extends JProgressBar
implements TableCellRenderer {
    private Hashtable limitColors;
    private int[] limitValues;

    public ProgressCellRenderer() {
        super(0, 0, 100);
        this.setBorderPainted(false);
    }

    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        Color color;
        int n = 0;
        this.setStringPainted(true);
        if (!(value instanceof Number)) {
            String str;
            if (value instanceof String) {
                str = (String)value;
                this.setStringPainted(false);
            } else {
                str = value.toString();
            }
            try {
                n = Integer.valueOf(str);
            }
            catch (NumberFormatException numberFormatException) {}
        } else {
            n = ((Number)value).intValue();
        }
        if ((color = this.getColor(n)) != null) {
            this.setForeground(color);
        }
        this.setValue(n);
        return this;
    }

    public void setLimits(Hashtable limitColors) {
        this.limitColors = limitColors;
        int i = 0;
        int n = limitColors.size();
        this.limitValues = new int[n];
        Enumeration enumeration = limitColors.keys();
        while (enumeration.hasMoreElements()) {
            this.limitValues[i++] = (Integer)enumeration.nextElement();
        }
        this.sort(this.limitValues);
    }

    private Color getColor(int value) {
        Color color = null;
        if (this.limitValues != null) {
            int i = 0;
            while (i < this.limitValues.length) {
                if (this.limitValues[i] < value) {
                    color = (Color)this.limitColors.get(new Integer(this.limitValues[i]));
                }
                ++i;
            }
        }
        return color;
    }

    private void sort(int[] a) {
        int n = a.length;
        int i = 0;
        while (i < n - 1) {
            int k = i;
            int j = i + 1;
            while (j < n) {
                if (a[j] < a[k]) {
                    k = j;
                }
                ++j;
            }
            int tmp = a[i];
            a[i] = a[k];
            a[k] = tmp;
            ++i;
        }
    }
}

