/*
 * Decompiled with CFR 0.152.
 */
package neatwork.solver;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Properties;
import java.util.Vector;
import neatwork.Messages;
import neatwork.core.MakeDesign;
import neatwork.core.MakeSimulation;
import neatwork.core.defs.CoreDesign;
import neatwork.core.defs.CoreTopographie;
import neatwork.core.defs.DiametersVector;
import neatwork.core.defs.OrificesVector;
import neatwork.core.defs.Pipes;
import neatwork.project.Design;
import neatwork.project.Node;
import neatwork.project.Pipe;
import neatwork.project.Topographie;
import neatwork.solver.AbstractSolver;
import neatwork.utils.Tools;

public class SolverDisk
extends AbstractSolver {
    private MakeDesign makeDesign;
    private Topographie topographie;
    private double hsource;
    private MakeSimulation makeSimulation;
    private Design design;

    public void makeDesign(Topographie topographie, String orificesSet, String diametersSet, Hashtable loadFactor, Vector constraints, double hsource) {
        this.setProgress(0);
        this.setStatus(Messages.getString("SolverDisk.Initialization..."));
        long tick = this.getTick();
        this.topographie = topographie;
        this.hsource = hsource;
        CoreTopographie topo = new CoreTopographie(topographie.getCoreVector());
        Enumeration enumeration = constraints.elements();
        while (enumeration.hasMoreElements()) {
            Vector item = (Vector)enumeration.nextElement();
            Pipe pipe = (Pipe)item.get(1);
            Pipes findedPipe = null;
            boolean find = false;
            Enumeration enum0 = topo.pvector.elements();
            while (!find && enum0.hasMoreElements()) {
                Pipes item0 = (Pipes)enum0.nextElement();
                boolean bl = find = item0.nodes_beg.equals(pipe.getBegin()) && item0.nodes_end.equals(pipe.getEnd());
                if (!find) continue;
                findedPipe = item0;
            }
            if (findedPipe == null) continue;
            int type = (Integer)item.get(0);
            switch (type) {
                case 0: {
                    findedPipe.imposdiammin = Double.parseDouble(item.get(2).toString());
                    break;
                }
                case 1: {
                    findedPipe.imposdiammax = Double.parseDouble(item.get(2).toString());
                    break;
                }
                case 2: {
                    findedPipe.imposdiam1 = Double.parseDouble(item.get(2).toString());
                    findedPipe.imposlength1 = findedPipe.length;
                    break;
                }
                case 3: {
                    findedPipe.imposdiam1 = Double.parseDouble(item.get(2).toString());
                    findedPipe.imposlength1 = Double.parseDouble(item.get(3).toString());
                    findedPipe.imposdiam2 = Double.parseDouble(item.get(4).toString());
                }
            }
        }
        OrificesVector ovector = new OrificesVector(Tools.readCSV(orificesSet));
        DiametersVector dvector = new DiametersVector(Tools.readCSV(diametersSet), topographie.getProperties());
        this.setProgress(50);
        this.setStatus(Messages.getString("SolverDisk.Building_Design.."));
        this.makeDesign = new MakeDesign(topo, dvector, ovector, topographie.getProperties(), loadFactor);
        this.setProgress(100);
        this.setStatus(String.valueOf(Messages.getString("SolverDisk.Completed.")) + this.getElapsedTime(tick) + ")");
    }

    public String getDesignContentMakeDesign() {
        Vector v = this.makeDesign.getDesignData(this.hsource);
        Vector design = new Vector();
        Enumeration enumeration = v.elements();
        while (enumeration.hasMoreElements()) {
            Vector<String> diam;
            Vector line = (Vector)enumeration.nextElement();
            if (line.size() == 11) {
                Vector node;
                Node n = this.getExpandedNode(line.get(0).toString());
                if (n.getType() != 0) {
                    node = new Vector();
                    node.add(line.get(0));
                    node.add(line.get(2));
                    node.add("" + n.getCoordX());
                    node.add("" + n.getCoordY());
                    node.add(line.get(9));
                    node.add(line.get(10));
                    node.add("" + n.getType());
                    design.add(node);
                    Vector pipe = new Vector();
                    pipe.add(line.get(1));
                    pipe.add(line.get(0));
                    pipe.add(line.get(3));
                    pipe.add(line.get(5));
                    pipe.add(line.get(7));
                    pipe.add(line.get(6));
                    pipe.add(line.get(8));
                    pipe.add("N");
                    design.add(pipe);
                } else {
                    node = new Vector();
                    node.add(line.get(0));
                    node.add(line.get(2));
                    node.add("" + n.getCoordX());
                    node.add("" + n.getCoordY());
                    node.add("0");
                    node.add("0");
                    node.add("" + n.getType());
                    design.add(node);
                }
            }
            if (line.size() == 8) {
                diam = new Vector<String>(line);
                diam.add("N");
                design.add(diam);
            }
            if (line.size() != 6) continue;
            diam = new Vector(line);
            design.add(diam);
        }
        String content = Tools.getTxt(design);
        content = String.valueOf(content) + this.topographie.getPropertiesContent();
        return content;
    }

    private Node getExpandedNode(String nodeId) {
        Iterator iter = this.topographie.getExpandedNodeIterator();
        while (iter.hasNext()) {
            Node item = (Node)iter.next();
            if (!item.getName().equals(nodeId)) continue;
            return item;
        }
        return null;
    }

    public Vector getNodePressureMakeDesign() {
        return this.makeDesign.getResultPressureData(this.hsource);
    }

    public void simulation(Design design, Properties parameters, Hashtable faucetStatus) {
        this.design = design;
        this.setProgress(0);
        this.setStatus(Messages.getString("SolverDisk.Initialization..."));
        long tick = this.getTick();
        OrificesVector ovector = new OrificesVector(design.getCoreOrifice());
        DiametersVector dvector = new DiametersVector(design.getCoreDiameter(), parameters);
        CoreDesign dsg = new CoreDesign(design.getCoreDesign(), dvector, ovector);
        this.setProgress(0);
        this.setStatus(Messages.getString("SolverDisk.Running_simulations.."));
        this.makeSimulation = new MakeSimulation(dsg, dvector, ovector, parameters, faucetStatus, this);
        this.setProgress(100);
        this.setStatus(String.valueOf(Messages.getString("SolverDisk.Completed.")) + this.getElapsedTime(tick) + ")");
    }

    public String getSimulationContent() {
        String content = "";
        content = String.valueOf(content) + this.design.getContent();
        content = String.valueOf(content) + Tools.getTxt(this.makeSimulation.getSimpleResultsSimu());
        content = String.valueOf(content) + Tools.getTxt(this.makeSimulation.getQuartileSimu());
        content = String.valueOf(content) + Tools.getTxt(this.makeSimulation.getSpeedSimu());
        content = String.valueOf(content) + Tools.getTxt(this.makeSimulation.getPressureSimu());
        content = String.valueOf(content) + this.makeSimulation.getPropertiesContent();
        return content;
    }
}

