/*
 * Decompiled with CFR 0.152.
 */
package neatwork.solver;

import java.util.Date;
import java.util.Hashtable;
import java.util.Observable;
import java.util.Properties;
import java.util.Vector;
import neatwork.Messages;
import neatwork.project.Design;
import neatwork.project.Topographie;

public abstract class AbstractSolver
extends Observable {
    public static final int MODIF_PROGRESS = 0;
    public static final int MODIF_STATUS = 1;
    private String status = "";
    private int progress = 0;

    public String getStatut() {
        return this.status;
    }

    protected void setStatus(String status) {
        this.status = status;
        this.setChanged();
        this.notifyObservers(new Integer(1));
    }

    public int getProgress() {
        return this.progress;
    }

    public void setProgress(int progress) {
        this.progress = progress;
        this.setChanged();
        this.notifyObservers(new Integer(0));
    }

    public void init() {
        this.setProgress(0);
        this.setStatus("");
    }

    protected long getTick() {
        Date date = new Date();
        return date.getTime() / 1000L;
    }

    protected String getElapsedTime(long tick) {
        Date date = new Date();
        long diff = date.getTime() / 1000L - tick;
        if (diff > 0L) {
            long hours = diff / 3600L;
            long minutes = (diff -= hours * 3600L) / 60L;
            long secs = diff - minutes * 60L;
            return String.valueOf(hours > 0L ? String.valueOf(hours) + Messages.getString("AbstractSolver._h") : "") + (minutes > 0L ? String.valueOf(minutes) + Messages.getString("AbstractSolver._min") : "") + secs + Messages.getString("AbstractSolver._sec");
        }
        return Messages.getString("AbstractSolver.0_sec");
    }

    public abstract void makeDesign(Topographie var1, String var2, String var3, Hashtable var4, Vector var5, double var6);

    public abstract String getDesignContentMakeDesign();

    public abstract Vector getNodePressureMakeDesign();

    public abstract void simulation(Design var1, Properties var2, Hashtable var3);

    public abstract String getSimulationContent();
}

