/*
 * Decompiled with CFR 0.152.
 */
package neatwork.project;

import java.util.Collections;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.Vector;
import neatwork.project.Network;
import neatwork.project.Node;
import neatwork.project.Pipe;
import neatwork.project.Project;
import neatwork.utils.LoiNormale;
import neatwork.utils.Tools;

public class Topographie
extends Network {
    private List nodeList2;
    private List pipeList2;

    public Topographie(String name, String content, Properties defaultProperties) {
        super(0, name);
        this.setProperties(defaultProperties);
        this.setContent(content);
    }

    public void setContent(String content) {
        Vector t;
        this.freeInfoModif();
        Vector v = Tools.readCSV(content);
        Properties properties = new Properties(this.getProperties());
        this.removeNetwork();
        Enumeration e = v.elements();
        while (e.hasMoreElements()) {
            t = (Vector)e.nextElement();
            if (t.size() == 6) {
                this.addNode(t);
            }
            if (t.size() != 2) continue;
            properties.setProperty("topo." + t.get(0).toString() + ".value", t.get(1).toString());
        }
        e = v.elements();
        while (e.hasMoreElements()) {
            t = (Vector)e.nextElement();
            if (t.size() != 3) continue;
            this.addPipe(t);
        }
        if (!this.thereIsAlreadyASource()) {
            this.addNewSource();
        }
        Collections.sort(this.nodeList, new Node());
        if (this.getInfoModif().indexOf(Project.ERROR) == -1) {
            this.setProperties(properties);
            super.setContent(this.getContent());
        }
    }

    public String getContent() {
        String content = "";
        content = String.valueOf(content) + this.getNodesContent();
        content = String.valueOf(content) + this.getPipesContent();
        content = String.valueOf(content) + this.getPropertiesContent();
        return content;
    }

    public String getNodesContent() {
        String content = "";
        content = String.valueOf(content) + "!Nodes\n";
        Iterator iter = this.getNodeIterator();
        while (iter.hasNext()) {
            content = String.valueOf(content) + Topographie.getNodeCSV((Node)iter.next()) + "\n";
        }
        return content;
    }

    public String getPipesContent() {
        String content = "";
        content = String.valueOf(content) + "!Pipes\n";
        Iterator iter = this.getPipeIterator();
        while (iter.hasNext()) {
            content = String.valueOf(content) + Topographie.getPipeCSV((Pipe)iter.next()) + "\n";
        }
        return content;
    }

    public String getPropertiesContent() {
        String content = "";
        content = String.valueOf(content) + "!Default properties\n";
        Enumeration<?> iter = this.getProperties().propertyNames();
        while (iter.hasMoreElements()) {
            String name = iter.nextElement().toString();
            if (!name.startsWith("topo.") || !name.endsWith(".value")) continue;
            content = String.valueOf(content) + name.substring(5, name.length() - 6) + "," + this.getProperties().getProperty(name) + "\n";
        }
        return content;
    }

    public static String getNodeCSV(Node node) {
        return String.valueOf(node.getName()) + "," + node.getHeight() + "," + node.getCoordX() + "," + node.getCoordY() + "," + node.getNbTaps() + "," + node.getType();
    }

    public static String getPipeCSV(Pipe pipe) {
        return String.valueOf(pipe.getBegin()) + "," + pipe.getEnd() + "," + pipe.getLength();
    }

    private void addNode(Vector v) {
        boolean isOk = true;
        Node n = new Node();
        n.setName(v.get(0).toString());
        try {
            n.setHeight(Double.parseDouble(v.get(1).toString()));
        }
        catch (NumberFormatException e) {
            isOk = false;
        }
        try {
            n.setCoordX(Double.parseDouble(v.get(2).toString()));
        }
        catch (NumberFormatException e) {
            isOk = false;
        }
        try {
            n.setCoordY(Double.parseDouble(v.get(3).toString()));
        }
        catch (NumberFormatException e) {
            isOk = false;
        }
        try {
            n.setNbTaps(Integer.parseInt(v.get(4).toString()));
        }
        catch (NumberFormatException e) {
            isOk = false;
        }
        try {
            n.setType(Integer.parseInt(v.get(5).toString()));
            if (n.getType() > 2 || n.getType() < 0) {
                isOk = false;
            }
        }
        catch (NumberFormatException e) {
            isOk = false;
        }
        if (isOk) {
            this.addNode(n);
        }
    }

    private void addPipe(Vector v) {
        boolean isOk = true;
        Pipe p = new Pipe();
        String begin = v.get(0).toString();
        p.setBegin(begin);
        String end = v.get(1).toString();
        p.setEnd(end);
        try {
            p.setLength(Double.parseDouble(v.get(2).toString()));
        }
        catch (NumberFormatException e) {
            isOk = false;
        }
        if (isOk) {
            this.addPipe(p);
        }
    }

    public Hashtable getLoadTaps() {
        Node node;
        Hashtable<String, String> table = new Hashtable<String, String>();
        Iterator iter = this.nodeList2.iterator();
        while (iter.hasNext()) {
            node = (Node)iter.next();
            table.put(node.getName(), "0");
        }
        iter = this.nodeList2.iterator();
        while (iter.hasNext()) {
            node = (Node)iter.next();
            if (node.getType() != 2) continue;
            Node pion = new Node(node);
            while (pion.getType() != 0) {
                String pred = this.getPredPipe(pion, this.pipeList2).getBegin();
                int passage = Integer.parseInt(table.get(pred).toString());
                table.put(pred, "" + ++passage);
                pion = this.getNode(pred, this.nodeList2);
            }
            table.put(node.getName(), "1");
        }
        return table;
    }

    public Hashtable getLoadFactor(Hashtable loadTaps) {
        double targetflow = Double.parseDouble(this.getProperties().getProperty("topo.targetflow.value"));
        double opentaps = Double.parseDouble(this.getProperties().getProperty("topo.opentaps.value"));
        double qualite = Double.parseDouble(this.getProperties().getProperty("topo.servicequal.value"));
        double[] proba = this.calculProba(targetflow, this.getNbNode(2, this.nodeList2), opentaps, qualite);
        Hashtable<String, Double> table = new Hashtable<String, Double>();
        Enumeration enumeration = loadTaps.keys();
        while (enumeration.hasMoreElements()) {
            String item = enumeration.nextElement().toString();
            int nbTaps = Integer.parseInt(loadTaps.get(item).toString());
            table.put(item, new Double(Tools.doubleFormat("0.##", proba[nbTaps] / targetflow)));
        }
        return table;
    }

    private Node getNode(String name, List nodelist) {
        Node node = null;
        Iterator iter = nodelist.iterator();
        while (iter.hasNext() && node == null) {
            Node item = (Node)iter.next();
            if (!item.getName().equals(name)) continue;
            node = item;
        }
        return node;
    }

    private int getNbNode(int type, List nodelist) {
        int cpt = 0;
        Iterator iter = nodelist.iterator();
        while (iter.hasNext()) {
            Node item = (Node)iter.next();
            if (item.getType() != type) continue;
            ++cpt;
        }
        return cpt;
    }

    private Pipe getPredPipe(Node node, List pipelist) {
        Iterator iter = pipelist.iterator();
        Pipe p = null;
        while (iter.hasNext() && p == null) {
            Pipe pipe = (Pipe)iter.next();
            if (!pipe.getEnd().equals(node.getName())) continue;
            p = pipe;
        }
        return p;
    }

    public Pipe getExpandedPredPipe(Node node) {
        return this.getPredPipe(node, this.pipeList2);
    }

    public void makeExpandedTopo() {
        Node item;
        this.nodeList2 = new Vector();
        this.pipeList2 = new Vector();
        Iterator iter = this.nodeList.iterator();
        while (iter.hasNext()) {
            item = (Node)iter.next();
            if (item.getType() != 2 || item.getNbTaps() >= 1) continue;
            item.setNbTaps(1);
        }
        iter = this.pipeList.iterator();
        while (iter.hasNext()) {
            Pipe p = new Pipe((Pipe)iter.next());
            this.pipeList2.add(p);
        }
        iter = this.nodeList.iterator();
        while (iter.hasNext()) {
            item = (Node)iter.next();
            if (item.getType() == 2 && item.getNbTaps() > 1) {
                char a = 'a';
                Node oldnode = new Node(item);
                oldnode.setType(1);
                oldnode.setNbTaps(0);
                this.nodeList2.add(oldnode);
                int i = 0;
                while (i < item.getNbTaps()) {
                    Node n = new Node(item);
                    char c = a;
                    a = (char)(c + 1);
                    n.setName(String.valueOf(item.getName()) + "_" + c);
                    n.setNbTaps(1);
                    this.nodeList2.add(n);
                    Pipe p = new Pipe();
                    p.setBegin(item.getName());
                    p.setEnd(n.getName());
                    p.setLength(1.0);
                    this.pipeList2.add(p);
                    ++i;
                }
                continue;
            }
            Node n = new Node(item);
            this.nodeList2.add(n);
        }
        Collections.sort(this.nodeList2, new Node());
    }

    public Iterator getExpandedNodeIterator() {
        return this.nodeList2.iterator();
    }

    public Iterator getExpandedPipeIterator() {
        return this.pipeList2.iterator();
    }

    private double[] calculProba(double outflow, int n, double p, double qualite) {
        double[] proba = new double[n + 1];
        proba[1] = outflow;
        int i = 2;
        while (i < n + 1) {
            proba[i] = Math.min(outflow * this.calculProba2(i, p, qualite), outflow * (double)i);
            if (proba[i] < outflow) {
                proba[i] = outflow;
            }
            ++i;
        }
        return proba;
    }

    private double calculProba2(int n, double pfrac, double proba) {
        double resu = 0.0;
        double proba1 = proba * (1.0 - Math.pow(1.0 - pfrac, n)) + Math.pow(1.0 - pfrac, n);
        double t = LoiNormale.param(proba1);
        resu = t * Math.pow((double)n * pfrac * (1.0 - pfrac), 0.5) + (double)n * pfrac;
        return resu;
    }

    public Vector getCoreVector() {
        Collections.sort(this.nodeList2, new Node());
        Vector data = new Vector();
        String source = this.getSource().getName();
        Vector<String> pipe = new Vector<String>();
        pipe.add(source);
        pipe.add(source);
        pipe.add("" + this.getSource().getHeight());
        pipe.add("0");
        pipe.add("0");
        data.add(pipe);
        Iterator i = this.nodeList2.iterator();
        while (i.hasNext()) {
            Node node = (Node)i.next();
            if (node.getType() == 0) continue;
            Pipe pred = this.getExpandedPredPipe(node);
            Vector<String> line = new Vector<String>();
            line.add(node.getName());
            line.add(pred.getBegin());
            line.add("" + node.getHeight());
            line.add("" + pred.getLength());
            line.add("" + node.getNbTaps());
            data.add(line);
        }
        return data;
    }
}

