/*
 * Decompiled with CFR 0.152.
 */
package neatwork.project;

import java.util.Enumeration;
import java.util.Properties;
import java.util.Vector;
import neatwork.project.Project;
import neatwork.utils.Tools;

public class Simulation
extends Project {
    Vector data;

    public Simulation(String name) {
        super(2, name);
    }

    public void setContent(String content) {
        super.setContent(content);
        this.data = Tools.readCSV(this.getContent());
    }

    public Properties getProperties() {
        Properties prop = new Properties();
        Enumeration e = this.data.elements();
        while (e.hasMoreElements()) {
            Vector t = (Vector)e.nextElement();
            if (t.size() != 3) continue;
            prop.setProperty("simu." + t.get(0).toString() + ".value", t.get(1).toString());
        }
        return prop;
    }

    public Vector getFlowTaps() {
        String[] type = new String[]{"S", "I", "D", "D", "D", "D", "D", "D", "I"};
        return this.getLine(10, type);
    }

    public Vector getQuartileTaps() {
        String[] type = new String[]{"S", "I", "D", "D", "D", "D", "D", "D", "D"};
        return this.getLine(11, type);
    }

    public Vector getSpeedPipe() {
        String[] type = new String[]{"S", "I", "D", "D"};
        return this.getLine(5, type);
    }

    public Vector getNodesPressure() {
        String[] type = new String[]{"S", "D", "D", "D"};
        return this.getLine(4, type);
    }

    private Vector getLine(int size, String[] type) {
        Vector v = new Vector();
        Enumeration e = this.data.elements();
        while (e.hasMoreElements()) {
            Vector t = (Vector)e.nextElement();
            if (t.size() != size) continue;
            Vector<Object> temp = new Vector<Object>();
            int i = 0;
            while (i < type.length) {
                try {
                    if (type[i].equals("I")) {
                        temp.add(new Integer(t.get(i).toString()));
                    } else if (type[i].equals("D")) {
                        temp.add(new Double(t.get(i).toString()));
                    } else {
                        temp.add(t.get(i).toString());
                    }
                }
                catch (Exception ex) {
                    temp.add("");
                }
                ++i;
            }
            v.add(temp);
        }
        return v;
    }
}

