/*
 * Decompiled with CFR 0.152.
 */
package neatwork.project;

import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Observable;
import java.util.Vector;
import neatwork.project.Project;

public class ProjectManager
extends Observable {
    public static final int MODIF_SETPROJECT = 0;
    public static final int MODIF_ADDPROJECT = 1;
    public static final int MODIF_REMOVEPROJECT = 2;
    public static final int MODIF_SETINDEX = 3;
    private List projects = new Vector();
    private int index = -1;

    public int getIndex() {
        return this.index;
    }

    public void setIndex(int index) {
        this.index = index;
        this.setChanged();
        this.notifyObservers(new Integer(3));
    }

    public Project getCurrentProject() {
        return this.getProject(this.index);
    }

    public Project getProject(int index) {
        if (index > -1 && index < this.projects.size()) {
            return (Project)this.projects.get(index);
        }
        return null;
    }

    public Project setProject(int index, Project project) {
        project = this.projects.set(index, project);
        this.setIndex(index);
        this.setChanged();
        this.notifyObservers(new Integer(0));
        return project;
    }

    public Project setCurrentProject(Project project) {
        return this.setProject(this.index, project);
    }

    public void addProject(Project project) {
        this.projects.add(project);
        this.setChanged();
        this.notifyObservers(new Integer(1));
        this.setIndex(this.projects.size() - 1);
    }

    public Project removeProject(int index) {
        if (index > -1 && index < this.projects.size()) {
            Project project = (Project)this.projects.remove(index);
            this.setChanged();
            this.notifyObservers(new Integer(2));
            return project;
        }
        return null;
    }

    public Project removeCurrentProject() {
        return this.removeProject(this.getIndex());
    }

    public int getNbProject() {
        return this.projects.size();
    }

    public ListIterator getProjectIterator() {
        return this.projects.listIterator();
    }

    public String isAlreadyLoaded(Project project) {
        int j;
        String oldname;
        String name = oldname = project.getName();
        int cpt = 2;
        int i = oldname.lastIndexOf("(");
        if (i < (j = oldname.lastIndexOf(")"))) {
            try {
                cpt = Integer.parseInt(oldname.substring(i + 1, j));
                oldname = oldname.substring(0, i - 1);
                name = String.valueOf(oldname) + " (" + String.valueOf(cpt++) + ")";
            }
            catch (NumberFormatException numberFormatException) {}
        }
        while (this.isInList(new Project(project.getType(), name))) {
            name = String.valueOf(oldname) + " (" + String.valueOf(cpt++) + ")";
        }
        return name;
    }

    private boolean isInList(Project p) {
        Iterator iter = this.projects.iterator();
        boolean find = false;
        while (iter.hasNext()) {
            find |= ((Project)iter.next()).hasSameIdentifiant(p);
        }
        return find;
    }
}

