/*
 * Decompiled with CFR 0.152.
 */
package neatwork.project;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Observable;
import java.util.Properties;
import neatwork.Messages;

public class Project
extends Observable {
    public static final int TYPE_TOPO = 0;
    public static final int TYPE_DESIGN = 1;
    public static final int TYPE_SIMU = 2;
    public static final int MODIF_CONTENT = 0;
    public static final int MODIF_PROPERTIES = 1;
    public static final String ERROR = Messages.getString("Project.error");
    public static final String WARNING = Messages.getString("Project.warning");
    private int type;
    private String name;
    private String description;
    private String content;
    private String infoModif;
    private Properties properties;
    private boolean hasChanged;

    public Project(int type, String name) {
        this.type = type;
        this.name = name;
        this.description = "";
        this.content = "";
    }

    public int getType() {
        return this.type;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public String getContent() {
        return this.content;
    }

    public Properties getProperties() {
        return this.properties;
    }

    public boolean hasChanged() {
        return this.hasChanged;
    }

    public void setType(int type) {
        this.type = type;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setContent(String content) {
        this.content = content;
        this.setHasChanged(true);
        this.setChanged();
        this.notifyObservers(new Integer(0));
    }

    public void setHasChanged(boolean changed) {
        this.hasChanged = changed;
    }

    public void setProperties(Properties prop) {
        if (this.properties == null) {
            this.properties = new Properties();
        }
        ((Hashtable)this.properties).putAll(prop);
        this.setHasChanged(true);
        this.setChanged();
        this.notifyObservers(new Integer(1));
    }

    public boolean hasSameIdentifiant(Project p) {
        return p.getName().equals(this.name) && p.getType() == this.type;
    }

    public String getShortName() {
        if (this.name.length() > 15) {
            return String.valueOf(this.name.substring(0, 13)) + "...";
        }
        return this.name;
    }

    public void freeInfoModif() {
        this.infoModif = "";
    }

    public void addInfoModif(String newInfoModif) {
        this.infoModif = String.valueOf(this.infoModif) + newInfoModif + "\n";
    }

    public String getInfoModif() {
        return this.infoModif;
    }

    public boolean sameProperties(Properties p1, Properties p2) {
        if (((Hashtable)p1).keySet().size() != ((Hashtable)p2).keySet().size()) {
            return false;
        }
        boolean same = true;
        Enumeration<?> e = p1.propertyNames();
        while (e.hasMoreElements() && same) {
            String prop = e.nextElement().toString();
            boolean bl = same = p1.getProperty(prop) != null && p2.getProperty(prop) != null && p1.getProperty(prop).equals(p2.getProperty(prop));
        }
        return same;
    }
}

