/*
 * Decompiled with CFR 0.152.
 */
package neatwork.project;

import java.util.Comparator;
import neatwork.Messages;
import neatwork.utils.Same;

public class Node
implements Comparator,
Same {
    public static final int TYPE_RESERVOIR = 0;
    public static final int TYPE_DISPATCH = 1;
    public static final int TYPE_FAUCET = 2;
    private String name = "node";
    private double coordX = 0.0;
    private double coordY = 0.0;
    private double height = 0.0;
    private int type = 1;
    private int nbTaps = 0;
    private double orifice = 0.0;
    private double orificeComercial = 0.0;

    public Node() {
    }

    public Node(Node n) {
        this.name = n.getName();
        this.coordX = n.getCoordX();
        this.coordY = n.getCoordY();
        this.height = n.getHeight();
        this.type = n.getType();
        this.nbTaps = n.getNbTaps();
        this.orifice = n.getOrifice();
        this.orificeComercial = n.getComercialOrifice();
    }

    public Node(String name) {
        this.name = name;
    }

    public String toString() {
        return String.valueOf(Messages.getString("Node.Node")) + this.name;
    }

    public boolean isSame(Object o) {
        return o.toString().equals(this.toString());
    }

    public void setName(String newName) {
        this.name = newName;
    }

    public String getName() {
        return this.name;
    }

    public void setCoordX(double newCoordX) {
        this.coordX = newCoordX;
    }

    public double getCoordX() {
        return this.coordX;
    }

    public void setCoordY(double newCoordY) {
        this.coordY = newCoordY;
    }

    public double getCoordY() {
        return this.coordY;
    }

    public void setHeight(double newHeight) {
        this.height = newHeight;
    }

    public double getHeight() {
        return this.height;
    }

    public void setType(int newType) {
        this.type = newType;
    }

    public int getType() {
        return this.type;
    }

    public void setNbTaps(int newNbTaps) {
        this.nbTaps = newNbTaps;
    }

    public int getNbTaps() {
        return this.nbTaps;
    }

    public void setOrifice(double orifice) {
        this.orifice = orifice;
    }

    public double getOrifice() {
        return this.orifice;
    }

    public void setComercialOrifice(double comercialOrifice) {
        this.orificeComercial = comercialOrifice;
    }

    public double getComercialOrifice() {
        return this.orificeComercial;
    }

    public int compare(Object node1, Object node2) {
        return ((Node)node1).getType() - ((Node)node2).getType();
    }

    public static String getNameType(int type) {
        switch (type) {
            case 1: {
                return Messages.getString("Node.BRANCHING_NODE");
            }
            case 2: {
                return Messages.getString("Node.FAUCET_NODE");
            }
            case 0: {
                return Messages.getString("Node.TANK");
            }
        }
        return "";
    }
}

