/*
 * Decompiled with CFR 0.152.
 */
package neatwork.project;

import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import neatwork.Messages;
import neatwork.project.Node;
import neatwork.project.Pipe;
import neatwork.project.Project;
import neatwork.utils.Same;
import neatwork.utils.Tools;

public class Network
extends Project {
    protected List nodeList = new Vector();
    protected List pipeList = new Vector();

    public Network(int type, String name) {
        super(type, name);
    }

    public void addNode(Node node) {
        if (node.getType() == 0 && this.thereIsAlreadyASource()) {
            this.addInfoModif(String.valueOf(Project.ERROR) + Messages.getString("Network.can__t_add") + node + Messages.getString("Network.___there_is_already_a_source"));
        } else if (this.findIndex(this.nodeList, node) == -1) {
            this.nodeList.add(node);
            this.setNodesType();
        } else {
            this.addInfoModif(String.valueOf(Project.ERROR) + Messages.getString("Network.can__t_add") + node + Messages.getString("Network.___existing_name"));
        }
    }

    public Node getNode(String name) {
        Node findNode = null;
        Iterator iter = this.nodeList.iterator();
        while (iter.hasNext()) {
            Node node = (Node)iter.next();
            if (!node.getName().equals(name)) continue;
            return node;
        }
        return findNode;
    }

    public void addPipe(Pipe pipe) {
        if (pipe.getBegin().equals(pipe.getEnd())) {
            this.addInfoModif(String.valueOf(Project.ERROR) + Messages.getString("Network.can__t_add") + pipe + Messages.getString("Network.___begin_and_end_are_same"));
        } else if (this.findIndex(this.nodeList, new Node(pipe.getBegin())) == -1) {
            this.addInfoModif(String.valueOf(Project.ERROR) + Messages.getString("Network.can__t_add") + pipe + Messages.getString("Network.___begin_doesn__t_exist"));
        } else if (this.findIndex(this.nodeList, new Node(pipe.getEnd())) == -1) {
            this.addInfoModif(String.valueOf(Project.ERROR) + Messages.getString("Network.can__t_add") + pipe + Messages.getString("Network.___end_doesn__t_exist"));
        } else if (this.findIndex(this.pipeList, pipe) == -1) {
            this.pipeList.add(pipe);
            this.setNodesType();
        } else {
            this.addInfoModif(String.valueOf(Project.ERROR) + Messages.getString("Network.can__t_add") + pipe + Messages.getString("Network.___existing_name"));
        }
    }

    public boolean removeNode(Node node) {
        if (node.getType() == 0) {
            return false;
        }
        return this.nodeList.remove(node);
    }

    public boolean removePipe(Pipe pipe) {
        return this.pipeList.remove(pipe);
    }

    public int getNbNodes() {
        return this.nodeList.size();
    }

    public int getNbNodes(int type) {
        int cpt = 0;
        Iterator iterator = this.nodeList.iterator();
        while (iterator.hasNext()) {
            Node item = (Node)iterator.next();
            if (item.getType() != type) continue;
            ++cpt;
        }
        return cpt;
    }

    public int getNbTotalTaps() {
        int cpt = 0;
        Iterator iterator = this.nodeList.iterator();
        while (iterator.hasNext()) {
            Node item = (Node)iterator.next();
            cpt += item.getNbTaps();
        }
        return cpt;
    }

    public double getMinLength() {
        double min = 150.0;
        Iterator iterator = this.pipeList.iterator();
        while (iterator.hasNext()) {
            Pipe item = (Pipe)iterator.next();
            min = Math.min(item.getLength(), min);
        }
        return min;
    }

    public double getMaxHeight() {
        double max = -150.0;
        Iterator iterator = this.nodeList.iterator();
        while (iterator.hasNext()) {
            Node item = (Node)iterator.next();
            max = Math.max(item.getHeight(), max);
        }
        return max;
    }

    public double getTotalHeightChange() {
        double min = 0.0;
        double max = 0.0;
        Iterator iterator = this.nodeList.iterator();
        while (iterator.hasNext()) {
            Node item = (Node)iterator.next();
            if (item.getHeight() > max) {
                max = item.getHeight();
            }
            if (!(item.getHeight() < min)) continue;
            min = item.getHeight();
        }
        return max - min;
    }

    public double getTotalLength() {
        double cpt = 0.0;
        Iterator iterator = this.pipeList.iterator();
        while (iterator.hasNext()) {
            Pipe item = (Pipe)iterator.next();
            cpt += item.getLength();
        }
        return cpt;
    }

    public int getNbPipes() {
        return this.pipeList.size();
    }

    public Iterator getNodeIterator() {
        return this.nodeList.iterator();
    }

    public Iterator getPipeIterator() {
        return this.pipeList.iterator();
    }

    private void setNodesType() {
        Iterator iter = this.nodeList.iterator();
        while (iter.hasNext()) {
            Node item = (Node)iter.next();
            if (item.getType() == 0) continue;
            if (this.hasSucc(item)) {
                item.setType(1);
                continue;
            }
            item.setType(2);
        }
    }

    public void removeNetwork() {
        this.pipeList.retainAll(new Vector());
        this.nodeList.retainAll(new Vector());
    }

    protected int findIndex(List list, Same object) {
        return Tools.findIndex(list, object);
    }

    public boolean thereIsAlreadyASource() {
        return this.getSource() != null;
    }

    protected String getFirstPossibleNodeName(String nodeName) {
        String old = nodeName;
        int cpt = 0;
        while (this.findIndex(this.nodeList, new Node(nodeName)) != -1) {
            nodeName = String.valueOf(old) + " (" + ++cpt + ")";
        }
        return nodeName;
    }

    public Node getSource() {
        Node node = null;
        Iterator iter = this.getNodeIterator();
        while (iter.hasNext()) {
            Node item = (Node)iter.next();
            if (item.getType() != 0) continue;
            node = item;
        }
        return node;
    }

    public Node getLastNode() {
        return (Node)this.nodeList.get(this.nodeList.size() - 1);
    }

    protected void addNewSource() {
        if (this.getNbNodes() == 0) {
            Node node = new Node();
            node.setName(this.getFirstPossibleNodeName(Messages.getString("Network.Source")));
            node.setType(0);
            this.addNode(node);
            this.addInfoModif(String.valueOf(Project.WARNING) + Messages.getString("Network._a_source") + node.getName() + Messages.getString("Network.)_has_been_added"));
        }
    }

    public boolean hasSucc(Node n) {
        boolean find = false;
        Iterator iter = this.pipeList.iterator();
        while (iter.hasNext() && !find) {
            find = ((Pipe)iter.next()).getBegin().equals(n.getName());
        }
        return find;
    }

    public boolean isSucc(String node, String succ) {
        boolean find = false;
        Iterator iter = this.pipeList.iterator();
        while (iter.hasNext() && !find) {
            Pipe p = (Pipe)iter.next();
            boolean bl = find = p.getBegin().equals(node) && p.getEnd().equals(succ);
        }
        return find;
    }

    public boolean hasPred(Node n) {
        boolean find = false;
        Iterator iter = this.pipeList.iterator();
        while (iter.hasNext() && !find) {
            find = ((Pipe)iter.next()).getEnd().equals(n.getName());
        }
        return find;
    }

    public Node getFirstPred(Node n) {
        boolean find = false;
        boolean find2 = false;
        Iterator iter = this.pipeList.iterator();
        Pipe p = null;
        while (iter.hasNext() && !find) {
            p = (Pipe)iter.next();
            find = p.getEnd().equals(n.getName());
        }
        return this.getNode(p.getBegin());
    }

    public boolean nbPredIsExactly(Node n, int nbPred) {
        int cpt = 0;
        Iterator iter = this.pipeList.iterator();
        while (iter.hasNext() && cpt < nbPred + 1) {
            if (!((Pipe)iter.next()).getEnd().equals(n.getName())) continue;
            ++cpt;
        }
        return cpt == nbPred;
    }

    public boolean isATree() {
        boolean tree = true;
        Iterator iter = this.nodeList.iterator();
        while (iter.hasNext() && tree) {
            Node node = (Node)iter.next();
            if (node.getType() != 0) {
                tree = this.nbPredIsExactly(node, 1);
            }
            if (node.getType() != 0) continue;
            tree = this.nbPredIsExactly(node, 0);
        }
        return tree;
    }

    public double setHauteurSource(double height) {
        double hsource = this.getSource().getHeight();
        Iterator iter = this.nodeList.iterator();
        while (iter.hasNext()) {
            Node node = (Node)iter.next();
            node.setHeight(node.getHeight() + height - hsource);
        }
        return hsource;
    }
}

