/*
 * Decompiled with CFR 0.152.
 */
package neatwork.project;

import java.util.AbstractList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Properties;
import java.util.TreeSet;
import java.util.Vector;
import neatwork.project.Database;
import neatwork.project.Diameter;
import neatwork.project.Network;
import neatwork.project.Node;
import neatwork.project.Pipe;
import neatwork.project.Project;
import neatwork.project.Topographie;
import neatwork.utils.Same;
import neatwork.utils.Tools;
import neatwork.utils.VectorComparator;

public class Design
extends Network {
    private Hashtable diamTable;
    private Hashtable loadFactor;
    private Vector orifice;

    public Design(String name, String content, Properties defaultProperties) {
        super(1, name);
        this.setProperties(defaultProperties);
        this.setContent(content);
    }

    public void setContent(String content) {
        Vector t;
        this.freeInfoModif();
        Vector v = Tools.readCSV(content);
        Properties properties = new Properties(this.getProperties());
        this.diamTable = new Hashtable();
        this.loadFactor = new Hashtable();
        this.orifice = new Vector();
        this.removeNetwork();
        Enumeration e = v.elements();
        while (e.hasMoreElements()) {
            t = (Vector)e.nextElement();
            if (t.size() == 9) {
                this.addDiameter(t);
            }
            if (t.size() == 7) {
                this.addNode(t);
            }
            if (t.size() == 2) {
                properties.setProperty("topo." + t.get(0).toString() + ".value", t.get(1).toString());
            }
            if (t.size() == 3) {
                this.loadFactor.put(t.get(0).toString(), t.get(1).toString());
            }
            if (t.size() != 6) continue;
            this.orifice.add(t.get(0));
        }
        e = v.elements();
        while (e.hasMoreElements()) {
            t = (Vector)e.nextElement();
            if (t.size() != 8) continue;
            this.addPipe(t);
        }
        if (!this.thereIsAlreadyASource()) {
            this.addNewSource();
        }
        Collections.sort(this.nodeList, new Node());
        if (this.getInfoModif().indexOf(Project.ERROR) == -1) {
            this.setProperties(properties);
            super.setContent(this.getContent());
        }
    }

    public Vector getOrifices() {
        return this.orifice;
    }

    public String getContent() {
        String content = "";
        content = String.valueOf(content) + this.getNodesContent();
        content = String.valueOf(content) + this.getPipesContent();
        content = String.valueOf(content) + this.getPropertiesContent();
        content = String.valueOf(content) + this.getDiametersContent();
        content = String.valueOf(content) + this.getOrificesContent();
        return content;
    }

    public String getNodesContent() {
        String content = "";
        content = String.valueOf(content) + "!Nodes\n";
        Iterator iter = this.getNodeIterator();
        while (iter.hasNext()) {
            content = String.valueOf(content) + this.getNodeCSV((Node)iter.next()) + "\n";
        }
        return content;
    }

    private String getNodeCSV(Node node) {
        return String.valueOf(node.getName()) + "," + node.getHeight() + "," + node.getCoordX() + "," + node.getCoordY() + "," + node.getOrifice() + "," + node.getComercialOrifice() + "," + node.getType();
    }

    public String getPipesContent() {
        String content = "";
        content = String.valueOf(content) + "!Pipes\n";
        Iterator iter = this.getPipeIterator();
        while (iter.hasNext()) {
            content = String.valueOf(content) + this.getPipeCSV((Pipe)iter.next()) + "\n";
        }
        return content;
    }

    private String getPipeCSV(Pipe pipe) {
        return String.valueOf(pipe.getBegin()) + "," + pipe.getEnd() + "," + pipe.getLength() + "," + pipe.getLength1() + "," + pipe.getRefDiam1() + "," + pipe.getLength2() + "," + pipe.getRefDiam2() + "," + "N";
    }

    public String getDiametersContent() {
        String content = "";
        content = String.valueOf(content) + "!Diameters\n";
        Iterator iter = this.diamTable.keySet().iterator();
        while (iter.hasNext()) {
            content = String.valueOf(content) + this.getDiameterCSV(iter.next().toString()) + "\n";
        }
        return content;
    }

    public String getOrificesContent() {
        String content = "";
        content = String.valueOf(content) + "!Orifices\n";
        Iterator iter = ((AbstractList)this.orifice).iterator();
        while (iter.hasNext()) {
            content = String.valueOf(content) + iter.next().toString() + ",N,N,N,N,N\n";
        }
        return content;
    }

    public Hashtable getDiamTable() {
        return this.diamTable;
    }

    public Hashtable getLoadFactorTable() {
        return this.loadFactor;
    }

    public void setLoadFactorTable(Hashtable table) {
        this.loadFactor.clear();
        this.loadFactor.putAll(table);
    }

    private String getDiameterCSV(String ref) {
        Diameter diam = (Diameter)this.diamTable.get(ref);
        return String.valueOf(ref) + "," + diam.getNominal() + "," + diam.getSdr() + "," + diam.getDiameter() + "," + diam.getCost() + "," + diam.getMaxLength() + "," + diam.getType() + "," + diam.getRoughness() + "," + "N";
    }

    public String getPropertiesContent() {
        String name;
        String content = "";
        content = String.valueOf(content) + "!Default properties\n";
        Enumeration<Object> iter = this.getProperties().propertyNames();
        while (iter.hasMoreElements()) {
            name = iter.nextElement().toString();
            if (!name.startsWith("topo.") || !name.endsWith(".value")) continue;
            content = String.valueOf(content) + name.substring(5, name.length() - 6) + "," + this.getProperties().getProperty(name) + "\n";
        }
        content = String.valueOf(content) + "!loadfactor\n";
        iter = this.loadFactor.keys();
        while (iter.hasMoreElements()) {
            name = iter.nextElement().toString();
            content = String.valueOf(content) + name + "," + this.loadFactor.get(name).toString() + ",0\n";
        }
        return content;
    }

    private void addNode(Vector v) {
        boolean isOk = true;
        Node n = new Node();
        n.setName(v.get(0).toString());
        try {
            n.setHeight(Double.parseDouble(v.get(1).toString()));
        }
        catch (NumberFormatException e) {
            isOk = false;
        }
        try {
            n.setCoordX(Double.parseDouble(v.get(2).toString()));
        }
        catch (NumberFormatException e) {
            isOk = false;
        }
        try {
            n.setCoordY(Double.parseDouble(v.get(3).toString()));
        }
        catch (NumberFormatException e) {
            isOk = false;
        }
        try {
            n.setOrifice(Double.parseDouble(v.get(4).toString()));
        }
        catch (NumberFormatException e) {
            isOk = false;
        }
        try {
            n.setComercialOrifice(Double.parseDouble(v.get(5).toString()));
        }
        catch (NumberFormatException e) {
            isOk = false;
        }
        try {
            n.setType(Integer.parseInt(v.get(6).toString()));
            if (n.getType() > 2 || n.getType() < 0) {
                isOk = false;
            }
        }
        catch (NumberFormatException e) {
            isOk = false;
        }
        if (isOk) {
            this.addNode(n);
        }
    }

    private void addPipe(Vector v) {
        boolean isOk = true;
        Pipe p = new Pipe();
        p.setBegin(v.get(0).toString());
        p.setEnd(v.get(1).toString());
        try {
            p.setLength(Double.parseDouble(v.get(2).toString()));
        }
        catch (NumberFormatException e) {
            isOk = false;
        }
        try {
            p.setLength1(Double.parseDouble(v.get(3).toString()));
        }
        catch (NumberFormatException e) {
            isOk = false;
        }
        p.setRefDiam1(v.get(4).toString());
        try {
            p.setLength2(Double.parseDouble(v.get(5).toString()));
        }
        catch (NumberFormatException e) {
            isOk = false;
        }
        p.setRefDiam2(v.get(6).toString());
        if (isOk) {
            this.addPipe(p);
        }
    }

    private void addDiameter(Vector v) {
        boolean isOk = true;
        Diameter d = new Diameter();
        d.setNominal(v.get(1).toString());
        try {
            d.setSdr(Double.parseDouble(v.get(2).toString()));
        }
        catch (NumberFormatException e) {
            isOk = false;
        }
        try {
            d.setDiameter(Double.parseDouble(v.get(3).toString()));
        }
        catch (NumberFormatException e) {
            isOk = false;
        }
        try {
            d.setCost(Double.parseDouble(v.get(4).toString()));
        }
        catch (NumberFormatException e) {
            isOk = false;
        }
        try {
            d.setMaxLength(Double.parseDouble(v.get(5).toString()));
        }
        catch (NumberFormatException e) {
            isOk = false;
        }
        try {
            d.setType(Integer.parseInt(v.get(6).toString()));
        }
        catch (NumberFormatException e) {
            isOk = false;
        }
        try {
            d.setRoughness(Double.parseDouble(v.get(7).toString()));
        }
        catch (NumberFormatException e) {
            isOk = false;
        }
        if (isOk) {
            this.diamTable.put(v.get(0), d);
        }
    }

    public void refreshDesign(Database database) {
        Enumeration enumeration = this.diamTable.keys();
        while (enumeration.hasMoreElements()) {
            String clef = enumeration.nextElement().toString();
            Diameter item = (Diameter)this.diamTable.get(clef);
            Diameter finded = database.getDiameter(item);
            if (finded == null) continue;
            this.diamTable.put(clef, finded);
        }
        this.setChanged();
        this.notifyObservers(new Integer(0));
    }

    public double getCost() {
        double cost = 0.0;
        Iterator iter = this.getPipeIterator();
        while (iter.hasNext()) {
            Diameter diam;
            Pipe item = (Pipe)iter.next();
            if (item.getLength1() > 0.0) {
                diam = (Diameter)this.diamTable.get(item.getRefDiam1());
                cost += diam.getCost() * item.getLength1();
            }
            if (!(item.getLength2() > 0.0)) continue;
            diam = (Diameter)this.diamTable.get(item.getRefDiam2());
            cost += diam.getCost() * item.getLength2();
        }
        return cost;
    }

    public Hashtable getSummary() {
        Hashtable<String, Double> h = new Hashtable<String, Double>();
        Iterator i = this.getPipeIterator();
        while (i.hasNext()) {
            Pipe p = (Pipe)i.next();
            if (h.get(p.getRefDiam1()) == null) {
                h.put(p.getRefDiam1(), new Double(0.0));
            }
            if (h.get(p.getRefDiam2()) == null) {
                h.put(p.getRefDiam2(), new Double(0.0));
            }
            if (!p.getRefDiam1().equals("0")) {
                h.put(p.getRefDiam1(), new Double((Double)h.get(p.getRefDiam1()) + p.getLength1()));
            }
            if (p.getRefDiam2().equals("0")) continue;
            h.put(p.getRefDiam2(), new Double((Double)h.get(p.getRefDiam2()) + p.getLength2()));
        }
        h.remove("0");
        return h;
    }

    public Vector getCoreDesign() {
        double hsource = this.getSource().getHeight();
        Collections.sort(this.nodeList, new Node());
        Vector data = new Vector();
        String source = this.getSource().getName();
        Vector<String> pipe0 = new Vector<String>();
        pipe0.add(source);
        pipe0.add(source);
        int i = 0;
        while (i < 9) {
            pipe0.add("0");
            ++i;
        }
        data.add(pipe0);
        Iterator i2 = this.pipeList.iterator();
        while (i2.hasNext()) {
            Pipe pipe = (Pipe)i2.next();
            Node node = this.getNode(pipe.getEnd());
            Vector<String> line = new Vector<String>();
            line.add(pipe.getEnd());
            line.add(pipe.getBegin());
            line.add("" + (node.getHeight() - hsource));
            line.add("" + pipe.getLength());
            line.add(node.getType() == 2 ? "1" : "0");
            line.add("" + pipe.getLength1());
            line.add("" + pipe.getLength2());
            Diameter diam = (Diameter)this.diamTable.get(pipe.getRefDiam1());
            line.add("" + diam.getDiameter());
            if (pipe.getLength2() > 0.0) {
                diam = (Diameter)this.diamTable.get(pipe.getRefDiam2());
                line.add("" + diam.getDiameter());
            } else {
                line.add("0");
            }
            line.add("" + node.getOrifice());
            line.add("" + node.getComercialOrifice());
            data.add(line);
        }
        Object source0 = data.remove(0);
        Collections.sort(data, new VectorComparator(0));
        Collections.sort(data, new VectorComparator(4));
        data.insertElementAt(source0, 0);
        return data;
    }

    public Vector getCoreOrifice() {
        TreeSet<String> data = new TreeSet<String>();
        Iterator i = this.nodeList.iterator();
        while (i.hasNext()) {
            data.add("" + ((Node)i.next()).getComercialOrifice());
        }
        Vector data0 = new Vector();
        Iterator iterator = data.iterator();
        while (iterator.hasNext()) {
            Vector line = new Vector();
            line.add(iterator.next());
            data0.add(line);
        }
        return data0;
    }

    public Vector getCoreDiameter() {
        Vector data = new Vector();
        Enumeration enumeration = this.diamTable.elements();
        while (enumeration.hasMoreElements()) {
            Diameter diam = (Diameter)enumeration.nextElement();
            Vector<String> line = new Vector<String>();
            line.add(diam.getNominal());
            line.add("" + diam.getSdr());
            line.add("" + diam.getDiameter());
            line.add("" + diam.getCost());
            line.add("" + diam.getMaxLength());
            line.add("" + diam.getType());
            line.add("" + diam.getRoughness());
            data.add(line);
        }
        return data;
    }

    public String extractTopoContent() {
        String name;
        Same item;
        String content = "";
        Hashtable<String, Integer> nbfaucet = new Hashtable<String, Integer>();
        Iterator iter = this.getNodeIterator();
        while (iter.hasNext()) {
            item = (Node)iter.next();
            ((Node)item).setNbTaps(0);
            if (((Node)item).getType() == 2) {
                ((Node)item).setNbTaps(1);
            }
            if ((name = ((Node)item).getName()).indexOf("_") <= 0) continue;
            name = name.substring(0, name.indexOf("_"));
            int nb = 1;
            if (nbfaucet.get(name) != null) {
                nb = (Integer)nbfaucet.get(name) + 1;
            }
            nbfaucet.put(name, new Integer(nb));
        }
        iter = this.getNodeIterator();
        while (iter.hasNext()) {
            item = (Node)iter.next();
            if (((Node)item).getName().indexOf("_") >= 0) continue;
            if (nbfaucet.get(((Node)item).getName()) != null) {
                ((Node)item).setNbTaps((Integer)nbfaucet.get(((Node)item).getName()));
            }
            content = String.valueOf(content) + Topographie.getNodeCSV((Node)item) + "\n";
        }
        iter = this.getPipeIterator();
        while (iter.hasNext()) {
            item = (Pipe)iter.next();
            if (((Pipe)item).getBegin().indexOf("_") >= 0 || ((Pipe)item).getEnd().indexOf("_") >= 0) continue;
            content = String.valueOf(content) + Topographie.getPipeCSV((Pipe)item) + "\n";
        }
        content = String.valueOf(content) + "!Default properties\n";
        Enumeration<?> enumeration = this.getProperties().propertyNames();
        while (enumeration.hasMoreElements()) {
            name = enumeration.nextElement().toString();
            if (!name.startsWith("topo.") || !name.endsWith(".value")) continue;
            content = String.valueOf(content) + name.substring(5, name.length() - 6) + "," + this.getProperties().getProperty(name) + "\n";
        }
        return content;
    }
}

