/*
 * Decompiled with CFR 0.152.
 */
package neatwork.project;

import java.util.Collections;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.Observable;
import java.util.Properties;
import java.util.Vector;
import neatwork.file.AbstractFileManager;
import neatwork.project.Diameter;
import neatwork.project.Orifice;
import neatwork.utils.Tools;

public class Database
extends Observable {
    public static final int MODIF_DIAMETER = 0;
    public static final int MODIF_ORIFICE = 1;
    private AbstractFileManager fileManager;
    private Properties properties;
    private Hashtable diamList;
    private Vector oriList;

    public Database(AbstractFileManager fileManager, Properties properties) {
        this.fileManager = fileManager;
        this.properties = properties;
        this.setOrificesContent(this.readData(properties.getProperty("file.orifices", "orifices.db"), "/neatwork/orifices.db"));
        this.setDiametersContent(this.readData(properties.getProperty("file.diameters", "diameters.db"), "/neatwork/diameters.db"));
    }

    public void setOrificesContent(String content) {
        Vector data = Tools.readCSV(content);
        this.oriList = new Vector();
        Enumeration e = data.elements();
        while (e.hasMoreElements()) {
            Vector t = (Vector)e.nextElement();
            if (t.size() != 1) continue;
            this.addOrifice(t);
        }
        Collections.sort(this.oriList, new Orifice());
        this.setChanged();
        this.notifyObservers(new Integer(1));
    }

    public void setDiametersContent(String content) {
        Vector data = Tools.readCSV(content);
        this.diamList = new Hashtable();
        Enumeration e = data.elements();
        while (e.hasMoreElements()) {
            Vector t = (Vector)e.nextElement();
            if (t.size() != 7) continue;
            this.addDiameter(t);
        }
        this.setChanged();
        this.notifyObservers(new Integer(0));
    }

    private String readData(String firstfile, String defaultfile) {
        String content = this.fileManager.readDbFile(firstfile);
        if (content.equals("")) {
            content = Tools.readStream(this.getClass().getResourceAsStream(defaultfile));
        }
        return content;
    }

    public void saveOrifices(String content) {
        this.fileManager.writeDbFile(this.properties.getProperty("file.orifices", "orifices.db"), content);
    }

    public void saveDiameters(String content) {
        this.fileManager.writeDbFile(this.properties.getProperty("file.diameters", "diameters.db"), content);
    }

    public Enumeration getDiameters() {
        Vector temp = new Vector(this.diamList.values());
        Collections.sort(temp, new Diameter());
        return temp.elements();
    }

    public Diameter getDiameter(Diameter diameter) {
        Enumeration enumeration = this.getDiameters();
        while (enumeration.hasMoreElements()) {
            Diameter item = (Diameter)enumeration.nextElement();
            if (!item.isSame(diameter)) continue;
            return item;
        }
        return null;
    }

    public Hashtable getDiametersTable() {
        return this.diamList;
    }

    public List getOrifices() {
        return this.oriList;
    }

    public void addDiameter(Vector v) {
        boolean isOk = true;
        Diameter d = new Diameter();
        d.setNominal(v.get(0).toString());
        try {
            d.setSdr(Double.parseDouble(v.get(1).toString()));
        }
        catch (NumberFormatException e) {
            isOk = false;
        }
        try {
            d.setDiameter(Double.parseDouble(v.get(2).toString()));
        }
        catch (NumberFormatException e) {
            isOk = false;
        }
        try {
            d.setCost(Double.parseDouble(v.get(3).toString()));
        }
        catch (NumberFormatException e) {
            isOk = false;
        }
        try {
            d.setMaxLength(Double.parseDouble(v.get(4).toString()));
        }
        catch (NumberFormatException e) {
            isOk = false;
        }
        try {
            d.setType(Integer.parseInt(v.get(5).toString()));
            if (d.getType() > Diameter.typeName.length || d.getType() < 1) {
                isOk = false;
            }
        }
        catch (NumberFormatException e) {
            isOk = false;
        }
        try {
            d.setRoughness(Double.parseDouble(v.get(6).toString()));
        }
        catch (NumberFormatException e) {
            isOk = false;
        }
        if (isOk) {
            this.diamList.put(this.firstValideRef(), d);
        }
    }

    public String firstValideRef() {
        int cpt = 0;
        boolean find = true;
        while (find) {
            find = this.diamList.keySet().contains("D" + ++cpt);
        }
        return "D" + cpt;
    }

    public void addOrifice(Vector v) {
        boolean isOk = true;
        Orifice o = new Orifice();
        try {
            o.setDiameter(Double.parseDouble(v.get(0).toString()));
        }
        catch (NumberFormatException e) {
            isOk = false;
        }
        if (Tools.findIndex(this.oriList, o) != -1) {
            isOk = false;
        }
        if (isOk) {
            this.oriList.add(o);
        }
    }

    public Properties getProperties() {
        return this.properties;
    }
}

