/*
 * Decompiled with CFR 0.152.
 */
package neatwork.gui.tree;

import java.awt.Color;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Observable;
import java.util.Observer;
import java.util.Vector;
import javax.swing.Icon;
import javax.swing.JTable;
import javax.swing.table.DefaultTableModel;
import neatwork.Messages;
import neatwork.gui.tree.TreeCellRenderer;
import neatwork.gui.tree.TreeNetworkModel;
import neatwork.project.Network;
import neatwork.project.Node;
import neatwork.project.Pipe;
import neatwork.utils.MapComparator;

public class TreeNetwork
extends JTable
implements Observer,
MouseListener {
    private Network network;
    private Icon icoReservoir = null;
    private Icon icoDispatch = null;
    private Icon icoFaucet = null;
    private boolean isAtree;
    private Hashtable nodePath = new Hashtable();
    static /* synthetic */ Class class$0;

    public TreeNetwork(Network network) {
        this.setNetwork(network);
        this.setShowGrid(false);
        this.getTableHeader().setReorderingAllowed(false);
        this.getTableHeader().setResizingAllowed(true);
        this.setRowMargin(0);
        this.setAutoResizeMode(0);
        this.getColumnModel().setColumnMargin(0);
        TreeCellRenderer renderer = new TreeCellRenderer(network, this.nodePath);
        TreeCellRenderer.color = new Hashtable();
        TreeCellRenderer.color.put(new Integer(2), new Color(47, 177, 209));
        TreeCellRenderer.color.put(new Integer(1), new Color(200, 200, 200));
        TreeCellRenderer.color.put(new Integer(0), new Color(35, 209, 47));
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("java.lang.String");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.setDefaultRenderer(clazz, renderer);
        renderer.setFont(this.getFont());
        this.addMouseListener(this);
    }

    public void setNetwork(Network network) {
        this.network = network;
        network.addObserver(this);
        boolean profondeur = false;
        Vector data = new Vector();
        if (network.isATree()) {
            this.isAtree = true;
            TreeNetworkModel model = new TreeNetworkModel(this.buildTree());
            this.setModel(model);
        } else {
            this.isAtree = false;
            Vector<String> line = new Vector<String>();
            line.add("_" + network.getName() + Messages.getString("TreeNetwork._is_not_a_tree"));
            data.add(line);
            Vector<String> header = new Vector<String>();
            header.add("");
            this.setModel(new DefaultTableModel(data, header));
        }
    }

    public void search(String nodeName) {
        if (this.isAtree) {
            TreeNetworkModel model = (TreeNetworkModel)this.getModel();
            boolean find = false;
            Iterator iter = model.tableCoord.keySet().iterator();
            Point item = new Point(0, 0);
            while (iter.hasNext() && !find) {
                item = (Point)iter.next();
                find = model.tableCoord.get(item).toString().equalsIgnoreCase(nodeName);
            }
            if (find) {
                this.scrollRectToVisible(this.getCellRect(item.y, item.x, true));
            }
        }
    }

    public void update(Observable observable, Object param) {
        if (observable.getClass().isInstance(this.network)) {
            switch ((Integer)param) {
                case 0: {
                    this.setNetwork((Network)observable);
                }
            }
        }
    }

    public Hashtable buildTree() {
        this.nodePath.clear();
        Hashtable<String, Integer> map = new Hashtable<String, Integer>();
        Iterator iter = this.network.getNodeIterator();
        while (iter.hasNext()) {
            Node item = (Node)iter.next();
            map.put(item.getName(), new Integer(0));
            this.nodePath.put(item.getName(), new Integer(0));
        }
        this.profondeur(this.network.getSource(), map, 0);
        int prof = 0;
        Vector nprof = new Vector();
        while (!map.isEmpty()) {
            Vector<String> line = new Vector<String>();
            iter = map.keySet().iterator();
            while (iter.hasNext()) {
                String n = iter.next().toString();
                Integer p = (Integer)map.get(n);
                if (p != prof) continue;
                line.add(n);
                iter.remove();
            }
            nprof.add(line);
            ++prof;
        }
        map = new Hashtable();
        iter = this.network.getNodeIterator();
        while (iter.hasNext()) {
            Node item = (Node)iter.next();
            map.put(item.getName(), new Integer(0));
        }
        iter = this.network.getNodeIterator();
        int row = 0;
        while (iter.hasNext()) {
            Node item = (Node)iter.next();
            if (item.getType() != 2) continue;
            this.remonteSource(item, map);
            ++row;
        }
        Enumeration enumeration = nprof.elements();
        MapComparator comparator = new MapComparator(map);
        while (enumeration.hasMoreElements()) {
            Vector item = (Vector)enumeration.nextElement();
            Collections.sort(item, comparator);
        }
        Hashtable mapX = new Hashtable();
        int i = 0;
        while (i < nprof.size()) {
            Vector line = (Vector)nprof.get(i);
            int j = 0;
            while (j < line.size()) {
                mapX.put(line.get(j), new Integer(i));
                ++j;
            }
            ++i;
        }
        Hashtable<String, Integer> mapY = new Hashtable<String, Integer>();
        mapY.put(this.network.getSource().getName(), new Integer(0));
        int i2 = 0;
        while (i2 < nprof.size() - 1) {
            Vector line = (Vector)nprof.get(i2);
            Vector lineSuiv = (Vector)nprof.get(i2 + 1);
            int j = 0;
            while (j < line.size()) {
                String node = line.get(j).toString();
                int pos = (Integer)mapY.get(node);
                int k = 0;
                while (k < lineSuiv.size()) {
                    String succ = lineSuiv.get(k).toString();
                    if (this.network.isSucc(node, succ)) {
                        mapY.put(succ, new Integer(pos));
                        pos += ((Integer)map.get(succ)).intValue();
                    }
                    ++k;
                }
                ++j;
            }
            ++i2;
        }
        Hashtable<Point, String> coord = new Hashtable<Point, String>();
        iter = mapX.keySet().iterator();
        while (iter.hasNext()) {
            String item = iter.next().toString();
            coord.put(new Point((Integer)mapX.get(item), (Integer)mapY.get(item)), item);
        }
        int i3 = 0;
        while (i3 < 2) {
            iter = this.network.getNodeIterator();
            while (iter.hasNext()) {
                Node item = (Node)iter.next();
                int y = (Integer)mapY.get(item.getName());
                int x = (Integer)mapX.get(item.getName());
                if (y > 0 && coord.get(new Point(x - 1, y)) == null) {
                    coord.put(new Point(x - 1, y), "_*L");
                    Object z = coord.get(new Point(--x, --y));
                    while (y > 0 && z == null) {
                        coord.put(new Point(x, y), "_*I");
                        z = coord.get(new Point(x, --y));
                    }
                    if (!z.toString().equals("_*I") && !z.toString().equals("_*L")) continue;
                    coord.put(new Point(x, y), "_*T");
                    continue;
                }
                if (y <= 0 || !coord.get(new Point(x - 1, y)).toString().equals("_*I")) continue;
                coord.put(new Point(x - 1, y), "_*T");
            }
            ++i3;
        }
        return coord;
    }

    public void profondeur(Node node, Map map, int prof) {
        map.put(node.getName(), new Integer(prof));
        Iterator iter = this.network.getPipeIterator();
        while (iter.hasNext()) {
            Pipe p = (Pipe)iter.next();
            if (!p.getBegin().equals(node.getName())) continue;
            this.profondeur(this.network.getNode(p.getEnd()), map, prof + 1);
        }
    }

    public void remonteSource(Node node, Map map) {
        Integer i = (Integer)map.get(node.getName());
        i = new Integer(i + 1);
        map.put(node.getName(), i);
        if (node.getType() != 0) {
            this.remonteSource(this.network.getFirstPred(node), map);
        }
    }

    public void mouseClicked(MouseEvent e) {
        int row = this.rowAtPoint(e.getPoint());
        int col = this.columnAtPoint(e.getPoint());
        String node = this.getModel().getValueAt(row, col).toString();
        if (node.length() > 0 && !node.substring(0, 1).equals("_")) {
            this.nodePath.clear();
            Iterator iter = this.network.getNodeIterator();
            while (iter.hasNext()) {
                Node item = (Node)iter.next();
                this.nodePath.put(item.getName(), new Integer(0));
            }
            this.remonteSource(this.network.getNode(node), this.nodePath);
            this.repaint();
        }
    }

    public void mousePressed(MouseEvent e) {
    }

    public void mouseReleased(MouseEvent e) {
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }
}

