/*
 * Decompiled with CFR 0.152.
 */
package neatwork.gui.tree;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.geom.Line2D;
import java.awt.geom.RoundRectangle2D;
import java.util.Hashtable;
import java.util.Map;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;
import neatwork.project.Network;

public class TreeCellRenderer
extends JLabel
implements TableCellRenderer {
    public static Hashtable color;
    private Network network;
    private int type = -1;
    private Map nodePath;
    private boolean isPath;

    public TreeCellRenderer(Network network, Map nodePath) {
        super("");
        this.network = network;
        this.setBackground(Color.white);
        this.setForeground(Color.black);
        this.setHorizontalAlignment(0);
        this.nodePath = nodePath;
    }

    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        Object z;
        this.setText(value.toString());
        this.type = -1;
        if (!this.getText().equals("") && !this.getText().startsWith("_")) {
            this.type = this.network.getNode(this.getText()).getType();
        }
        this.isPath = (z = this.nodePath.get(value.toString())) != null && (Integer)z > 0;
        return this;
    }

    public void paint(Graphics g) {
        Shape l;
        Graphics2D g2 = (Graphics2D)g;
        if (this.isPath) {
            g2.setColor(new Color(24, 216, 249));
            g2.fillOval(0, 0, this.getWidth(), this.getHeight());
        }
        g2.setStroke(new BasicStroke(2.0f));
        g2.setColor(Color.black);
        if (this.getText().equals("_*I") || this.getText().equals("_*T")) {
            l = new Line2D.Double(this.getWidth() / 2, 0.0, this.getWidth() / 2, this.getHeight());
            g2.draw(l);
        }
        if (this.getText().equals("_*L") || this.getText().equals("_*T")) {
            l = new RoundRectangle2D.Double((double)this.getWidth() / 2.0, (double)(-this.getHeight()) / 2.0, (double)this.getWidth() * 1.0, (double)this.getHeight() * 1.0, 10.0, 10.0);
            g2.draw(l);
        }
        if (this.type > -1) {
            if (this.type == 0) {
                l = new Line2D.Double(this.getWidth() / 2, this.getHeight() / 2, this.getWidth(), this.getHeight() / 2);
                g2.draw(l);
            }
            if (this.type == 1) {
                l = new Line2D.Double(0.0, this.getHeight() / 2, this.getWidth(), this.getHeight() / 2);
                g2.draw(l);
            }
            if (this.type == 2) {
                l = new Line2D.Double(0.0, this.getHeight() / 2, this.getWidth() / 2, this.getHeight() / 2);
                g2.draw(l);
            }
            g2.setColor((Color)color.get(new Integer(this.type)));
            g2.setStroke(new BasicStroke(1.0f));
            FontMetrics fm = g2.getFontMetrics();
            int w = fm.stringWidth(this.getText()) + 10;
            int h = this.getHeight() - 2;
            int x = this.getWidth() / 2;
            int y = this.getHeight() / 2 + 1;
            g2.fillRect(x - w / 2, y - h / 2, w, h);
            g2.setColor(Color.black);
            g2.drawRect(x - w / 2, y - h / 2, w - 1, h - 1);
            g2.drawString(this.getText(), x - (w - 10) / 2, y - (h - 4) / 2 + fm.getAscent() - 3);
        }
    }
}

