/*
 * Decompiled with CFR 0.152.
 */
package neatwork.gui.topographie;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.Observable;
import java.util.Observer;
import javax.swing.Action;
import javax.swing.ImageIcon;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import neatwork.Messages;
import neatwork.gui.fancytable.FancyTable;
import neatwork.gui.fancytable.FancyTablePanel;
import neatwork.gui.topographie.TopoNodeTableModel;
import neatwork.gui.topographie.TopoPipeTableModel;
import neatwork.project.Topographie;
import neatwork.utils.NeatworkAction;

public class TopoTablePane
extends JPanel
implements Observer {
    private Topographie topo;
    private TopoNodeTableModel nodesTableModel;
    private TopoPipeTableModel pipesTableModel;
    private FancyTable jTablePipe;
    private FancyTable jTableNode;
    private JSplitPane jSplitPane;
    String pathImage = "/neatwork/gui/images/";

    public TopoTablePane(Topographie topo0) {
        this.topo = topo0;
        this.topo.addObserver(this);
        this.nodesTableModel = new TopoNodeTableModel(this.topo);
        this.pipesTableModel = new TopoPipeTableModel(this.topo);
        this.jTablePipe = new FancyTable(this.pipesTableModel, true);
        this.jTableNode = new FancyTable(this.nodesTableModel, true);
        this.setLayout(new BorderLayout());
        this.jSplitPane = new JSplitPane();
        Action[] actions = new Action[8];
        actions[0] = this.jTableNode.insertRowAction;
        actions[0].putValue("ShortDescription", Messages.getString("TopoTablePane.Insert_a_new_node"));
        actions[1] = this.jTableNode.deleteRowAction;
        actions[1].putValue("ShortDescription", Messages.getString("TopoTablePane.Delete_selected_node(s)"));
        actions[2] = null;
        actions[6] = this.jTableNode.updateAction;
        actions[6].putValue("ShortDescription", Messages.getString("TopoTablePane.Undo_modifications"));
        ImageIcon icon = new ImageIcon(this.getClass().getResource(String.valueOf(this.pathImage) + "Check.gif"));
        actions[7] = new NeatworkAction(Messages.getString("TopoTablePane.Apply"), icon, Messages.getString("TopoTablePane.Apply_modifications"), 'A'){

            public void actionPerformed(ActionEvent e) {
                TopoTablePane.this.apply();
            }
        };
        actions[5] = null;
        actions[3] = this.jTableNode.copyAction;
        actions[4] = this.jTableNode.pasteAction;
        this.jSplitPane.setTopComponent(new FancyTablePanel(Messages.getString("TopoTablePane.Node_list"), actions, this.jTableNode));
        actions = new Action[8];
        actions[0] = this.jTablePipe.insertRowAction;
        actions[0].putValue("ShortDescription", Messages.getString("TopoTablePane.Insert_a_new_pipe"));
        actions[1] = this.jTablePipe.deleteRowAction;
        actions[1].putValue("ShortDescription", Messages.getString("TopoTablePane.Delete_selected_pipe(s)"));
        actions[2] = null;
        actions[3] = this.jTablePipe.copyAction;
        actions[4] = this.jTablePipe.pasteAction;
        actions[5] = null;
        actions[6] = this.jTablePipe.updateAction;
        actions[6].putValue("ShortDescription", Messages.getString("TopoTablePane.Undo_modifications"));
        icon = new ImageIcon(this.getClass().getResource(String.valueOf(this.pathImage) + "Check.gif"));
        actions[7] = new NeatworkAction(Messages.getString("TopoTablePane.Apply"), icon, Messages.getString("TopoTablePane.Apply_modifications"), 'A'){

            public void actionPerformed(ActionEvent e) {
                TopoTablePane.this.apply();
            }
        };
        this.jSplitPane.setBottomComponent(new FancyTablePanel(Messages.getString("TopoTablePane.Arc_list"), actions, this.jTablePipe));
        this.jSplitPane.setOrientation(0);
        this.jSplitPane.setContinuousLayout(false);
        this.jSplitPane.setResizeWeight(0.5);
        this.jSplitPane.setOneTouchExpandable(true);
        this.jSplitPane.setDividerLocation(200);
        this.add((Component)this.jSplitPane, "Center");
        this.updateNodesTable();
        this.updatePipesTable();
    }

    private void updateNodesTable() {
        this.jTableNode.updateData();
    }

    private void updatePipesTable() {
        this.jTablePipe.updateData();
    }

    private void apply() {
        this.topo.freeInfoModif();
        String content = String.valueOf(this.topo.getPropertiesContent()) + this.nodesTableModel.getContent() + this.pipesTableModel.getContent();
        this.topo.setContent(content);
        if (!this.topo.getInfoModif().equals("")) {
            JOptionPane.showMessageDialog(null, Messages.getString("TopoTablePane.error_in_your_project"));
            JOptionPane.showMessageDialog(null, this.topo.getInfoModif());
        }
    }

    public void update(Observable observable, Object param) {
        if (observable.getClass().isInstance(this.topo)) {
            switch ((Integer)param) {
                case 0: {
                    this.updateNodesTable();
                    this.updatePipesTable();
                }
            }
        }
    }
}

