/*
 * Decompiled with CFR 0.152.
 */
package neatwork.gui.topographie;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Properties;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import neatwork.Messages;
import neatwork.gui.fancytable.FancyTable;
import neatwork.gui.topographie.QuickCheckTableModel;
import neatwork.project.Topographie;

public class QuickCheckDialog
extends JDialog
implements ActionListener {
    private JButton apply = new JButton(Messages.getString("QuickCheckDialog.Apply"));
    private JTextField textSeuil;
    private JTextField textAlpha;
    private QuickCheckTableModel tableModel;
    Topographie topo;

    public QuickCheckDialog(JFrame frame, Topographie topo) {
        super(frame, Messages.getString("QuickCheckDialog.Quick_Check"), true);
        this.setDefaultCloseOperation(2);
        ((Component)this).setSize(400, 300);
        Dimension d = Toolkit.getDefaultToolkit().getScreenSize();
        ((Component)this).setLocation((d.width - this.getSize().width) / 2, (d.height - this.getSize().height) / 2);
        this.topo = topo;
        this.tableModel = new QuickCheckTableModel(topo);
        FancyTable table = new FancyTable(this.tableModel);
        Container pane = this.getContentPane();
        pane.setLayout(new BorderLayout(5, 5));
        JPanel top = new JPanel(new BorderLayout());
        top.setBorder(BorderFactory.createEmptyBorder(3, 3, 3, 3));
        JPanel top2 = new JPanel(new GridLayout(2, 1));
        JLabel lbl = new JLabel(String.valueOf(Messages.getString("topo.seuil.name")) + " :");
        top2.add(lbl);
        JLabel lbl2 = new JLabel(String.valueOf(Messages.getString("topo.faucetcoef.name")) + " :");
        top2.add(lbl2);
        top.add((Component)top2, "West");
        this.apply.setActionCommand("apply");
        this.apply.addActionListener(this);
        top.add((Component)this.apply, "East");
        JPanel top3 = new JPanel(new GridLayout(2, 1));
        this.textSeuil = new JTextField(topo.getProperties().getProperty("topo.seuil.value", "0.1"));
        this.textSeuil.addActionListener(this);
        this.textSeuil.setActionCommand("apply");
        top3.add(this.textSeuil);
        this.textAlpha = new JTextField(topo.getProperties().getProperty("topo.faucetcoef.value", "0.1"));
        this.textAlpha.addActionListener(this);
        this.textAlpha.setActionCommand("apply");
        top3.add(this.textAlpha);
        top.add((Component)top3, "Center");
        pane.add((Component)top, "North");
        pane.add((Component)new JScrollPane(table), "Center");
        JButton button = new JButton(Messages.getString("QuickCheckDialog.Close"));
        button.setActionCommand("close");
        JPanel panel = new JPanel(new FlowLayout());
        panel.add(button);
        button.addActionListener(this);
        pane.add((Component)panel, "South");
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getActionCommand().equals("close")) {
            this.dispose();
        }
        if (e.getActionCommand().equals("apply")) {
            Properties p;
            try {
                double seuil = Double.parseDouble(this.textSeuil.getText());
                p = new Properties();
                p.setProperty("topo.seuil.value", this.textSeuil.getText());
                this.topo.setProperties(p);
                this.tableModel.updateData();
            }
            catch (NumberFormatException seuil) {
                // empty catch block
            }
            try {
                double alpha = Double.parseDouble(this.textAlpha.getText());
                p = new Properties();
                p.setProperty("topo.faucetcoef.value", this.textAlpha.getText());
                this.topo.setProperties(p);
                this.tableModel.updateData();
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
    }
}

