/*
 * Decompiled with CFR 0.152.
 */
package neatwork.gui.tabbedpane;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JTabbedPane;
import javax.swing.plaf.basic.BasicTabbedPaneUI;
import javax.swing.plaf.metal.MetalTabbedPaneUI;
import neatwork.gui.tabbedpane.SingleRowTabbedPane;

public class SingleRowTabbedPaneUI
extends MetalTabbedPaneUI {
    protected ActionListener[] buttonListeners;

    public void installUI(JComponent c) {
        this.tabPane = (JTabbedPane)c;
        c.setLayout(this.createLayoutManager());
        this.installDefaults();
        this.installComponents();
        this.installListeners();
        this.installKeyboardActions();
        this.runCount = 1;
        this.selectedRun = 0;
    }

    public void uninstallUI(JComponent c) {
        this.uninstallComponents();
        super.uninstallUI(c);
    }

    protected LayoutManager createLayoutManager() {
        return new SingleRowTabbedLayout(this.tabPane);
    }

    protected void installComponents() {
        JButton[] buttons = ((SingleRowTabbedPane)this.tabPane).getButtons();
        int i = 0;
        while (i < buttons.length) {
            this.tabPane.add(buttons[i]);
            ++i;
        }
    }

    protected void uninstallComponents() {
        JButton[] buttons = ((SingleRowTabbedPane)this.tabPane).getButtons();
        int i = 0;
        while (i < buttons.length) {
            this.tabPane.remove(buttons[i]);
            ++i;
        }
    }

    protected void installListeners() {
        super.installListeners();
        SingleRowTabbedPane stabPane = (SingleRowTabbedPane)this.tabPane;
        JButton[] buttons = stabPane.getButtons();
        int n = buttons.length;
        this.buttonListeners = new ActionListener[n];
        int i = 0;
        while (i < n) {
            this.buttonListeners[i] = null;
            String str = buttons[i].getActionCommand();
            if (str.equals(SingleRowTabbedPane.ROTATE)) {
                this.buttonListeners[i] = new ShiftTabs(){

                    protected int getStartIndex() {
                        int index = this.sPane.getVisibleStartIndex() + this.sPane.getVisibleCount();
                        return index < this.sPane.getTabCount() ? index : 0;
                    }
                };
            } else if (str.equals(SingleRowTabbedPane.PREVIOUS)) {
                this.buttonListeners[i] = new ShiftTabs(){

                    protected int getStartIndex() {
                        return this.getStartIndex(this.sPane.getVisibleStartIndex() - 1);
                    }
                };
            } else if (str.equals(SingleRowTabbedPane.NEXT)) {
                this.buttonListeners[i] = new ShiftTabs(){

                    protected int getStartIndex() {
                        return this.sPane.getVisibleStartIndex() + this.sPane.getVisibleCount();
                    }
                };
            } else if (str.equals(SingleRowTabbedPane.FIRST)) {
                this.buttonListeners[i] = new ShiftTabs();
            } else if (str.equals(SingleRowTabbedPane.LEFT_SHIFT)) {
                this.buttonListeners[i] = new ShiftTabs(){

                    protected int getStartIndex() {
                        return this.sPane.getVisibleStartIndex() - 1;
                    }
                };
            } else if (str.equals(SingleRowTabbedPane.RIGHT_SHIFT)) {
                this.buttonListeners[i] = new ShiftTabs(){

                    protected int getStartIndex() {
                        return this.sPane.getVisibleStartIndex() + 1;
                    }
                };
            } else if (str.equals(SingleRowTabbedPane.LAST)) {
                this.buttonListeners[i] = new ShiftTabs(){

                    protected int getStartIndex() {
                        return this.getStartIndex(this.sPane.getTabCount() - 1);
                    }
                };
            }
            buttons[i].addActionListener(this.buttonListeners[i]);
            ++i;
        }
    }

    protected void uninstallListeners() {
        super.uninstallListeners();
        JButton[] buttons = ((SingleRowTabbedPane)this.tabPane).getButtons();
        int i = 0;
        while (i < buttons.length) {
            buttons[i].removeActionListener(this.buttonListeners[i]);
            ++i;
        }
    }

    public int tabForCoordinate(JTabbedPane pane, int x, int y) {
        int tabCount = this.tabPane.getTabCount();
        SingleRowTabbedPane stabPane = (SingleRowTabbedPane)this.tabPane;
        int visibleCount = stabPane.getVisibleCount();
        int visibleStartIndex = stabPane.getVisibleStartIndex();
        int i = 0;
        int index = visibleStartIndex;
        while (i < visibleCount) {
            if (this.rects[index].contains(x, y)) {
                return index;
            }
            ++i;
            ++index;
        }
        return -1;
    }

    public void paint(Graphics g, JComponent c) {
        int selectedIndex = this.tabPane.getSelectedIndex();
        int tabPlacement = this.tabPane.getTabPlacement();
        int tabCount = this.tabPane.getTabCount();
        this.ensureCurrentLayout();
        SingleRowTabbedPane stabPane = (SingleRowTabbedPane)this.tabPane;
        int visibleCount = stabPane.getVisibleCount();
        int visibleStartIndex = stabPane.getVisibleStartIndex();
        Rectangle iconRect = new Rectangle();
        Rectangle textRect = new Rectangle();
        Rectangle clipRect = g.getClipBounds();
        Insets insets = this.tabPane.getInsets();
        this.tabRuns[0] = visibleStartIndex;
        int i = 0;
        int index = visibleStartIndex;
        while (i < visibleCount) {
            if (this.rects[index].intersects(clipRect)) {
                this.paintTab(g, tabPlacement, this.rects, index, iconRect, textRect);
            }
            ++i;
            ++index;
        }
        if (stabPane.isVisibleTab(selectedIndex) && this.rects[selectedIndex].intersects(clipRect)) {
            this.paintTab(g, tabPlacement, this.rects, selectedIndex, iconRect, textRect);
        }
        this.paintContentBorder(g, tabPlacement, selectedIndex);
    }

    protected void paintContentBorderTopEdge(Graphics g, int tabPlacement, int selectedIndex, int x, int y, int w, int h) {
        g.setColor(this.selectHighlight);
        if (tabPlacement != 1 || selectedIndex < 0 || this.rects[selectedIndex].y + this.rects[selectedIndex].height + 1 < y || !((SingleRowTabbedPane)this.tabPane).isVisibleTab(selectedIndex)) {
            g.drawLine(x, y, x + w - 2, y);
        } else {
            Rectangle selRect = this.rects[selectedIndex];
            g.drawLine(x, y, selRect.x + 1, y);
            if (selRect.x + selRect.width < x + w - 2) {
                g.drawLine(selRect.x + selRect.width, y, x + w - 2, y);
            } else {
                g.setColor(this.shadow);
                g.drawLine(x + w - 2, y, x + w - 2, y);
            }
        }
    }

    protected void paintContentBorderBottomEdge(Graphics g, int tabPlacement, int selectedIndex, int x, int y, int w, int h) {
        g.setColor(this.darkShadow);
        if (tabPlacement != 3 || selectedIndex < 0 || this.rects[selectedIndex].y - 1 > h || !((SingleRowTabbedPane)this.tabPane).isVisibleTab(selectedIndex)) {
            g.drawLine(x, y + h - 1, x + w - 1, y + h - 1);
        } else {
            Rectangle selRect = this.rects[selectedIndex];
            g.drawLine(x, y + h - 1, selRect.x, y + h - 1);
            if (selRect.x + selRect.width < x + w - 2) {
                g.drawLine(selRect.x + selRect.width, y + h - 1, x + w - 1, y + h - 1);
            }
        }
    }

    protected Insets getTabAreaInsets(int tabPlacement) {
        SingleRowTabbedPane stabPane = (SingleRowTabbedPane)this.tabPane;
        Dimension d = stabPane.getButtonPreferredSize();
        int n = stabPane.getButtonCount();
        int buttonPlacement = stabPane.getButtonPlacement();
        Insets currentInsets = new Insets(0, 0, 0, 0);
        if (tabPlacement == 1) {
            currentInsets.top = this.tabAreaInsets.top;
            currentInsets.bottom = this.tabAreaInsets.bottom;
        } else {
            currentInsets.top = this.tabAreaInsets.bottom;
            currentInsets.bottom = this.tabAreaInsets.top;
        }
        if (buttonPlacement == 4) {
            currentInsets.left = this.tabAreaInsets.left;
            currentInsets.right = this.tabAreaInsets.right + n * d.width;
        } else {
            currentInsets.left = this.tabAreaInsets.left + n * d.width;
            currentInsets.right = this.tabAreaInsets.right;
        }
        return currentInsets;
    }

    protected int lastTabInRun(int tabCount, int run) {
        SingleRowTabbedPane stabPane = (SingleRowTabbedPane)this.tabPane;
        return stabPane.getVisibleStartIndex() + stabPane.getVisibleCount() - 1;
    }

    protected void ensureCurrentLayout() {
        SingleRowTabbedLayout layout = (SingleRowTabbedLayout)this.tabPane.getLayout();
        layout.calculateLayoutInfo();
        this.setButtonsEnabled();
    }

    protected void setButtonsEnabled() {
        SingleRowTabbedPane stabPane = (SingleRowTabbedPane)this.tabPane;
        int visibleCount = stabPane.getVisibleCount();
        int visibleStartIndex = stabPane.getVisibleStartIndex();
        JButton[] buttons = stabPane.getButtons();
        boolean lEnable = visibleStartIndex > 0;
        boolean rEnable = visibleStartIndex + visibleCount < this.tabPane.getTabCount();
        int i = 0;
        while (i < buttons.length) {
            boolean enable = false;
            String str = buttons[i].getActionCommand();
            if (str.equals(SingleRowTabbedPane.ROTATE)) {
                enable = lEnable || rEnable;
            } else if (str.equals(SingleRowTabbedPane.PREVIOUS)) {
                enable = lEnable;
            } else if (str.equals(SingleRowTabbedPane.NEXT)) {
                enable = rEnable;
            } else if (str.equals(SingleRowTabbedPane.FIRST)) {
                enable = lEnable;
            } else if (str.equals(SingleRowTabbedPane.LEFT_SHIFT)) {
                enable = lEnable;
            } else if (str.equals(SingleRowTabbedPane.RIGHT_SHIFT)) {
                enable = rEnable;
            } else if (str.equals(SingleRowTabbedPane.LAST)) {
                enable = rEnable;
            }
            buttons[i].setEnabled(enable);
            ++i;
        }
    }

    protected void ensureVisibleTabAt(int index) {
        int startIndex;
        int count;
        boolean directionIsRight;
        SingleRowTabbedPane stabPane = (SingleRowTabbedPane)this.tabPane;
        int visibleCount = stabPane.getVisibleCount();
        int visibleStartIndex = stabPane.getVisibleStartIndex();
        int visibleEndIndex = visibleStartIndex + visibleCount - 1;
        if (visibleStartIndex < index && index < visibleEndIndex) {
            return;
        }
        int selectedIndex = this.tabPane.getSelectedIndex();
        boolean bl = directionIsRight = index - selectedIndex > 0;
        if (index <= visibleStartIndex) {
            if (visibleStartIndex == 0) {
                return;
            }
            stabPane.setVisibleStartIndex(--visibleStartIndex);
            ((SingleRowTabbedLayout)this.tabPane.getLayout()).calculateLayoutInfo();
            count = stabPane.getVisibleCount();
            startIndex = stabPane.getVisibleStartIndex();
            if (startIndex > index || index > startIndex + count - 1) {
                stabPane.setVisibleStartIndex(++visibleStartIndex);
            }
        }
        if (visibleEndIndex <= index) {
            if (visibleStartIndex == visibleCount + 1) {
                return;
            }
            stabPane.setVisibleStartIndex(++visibleStartIndex);
            ((SingleRowTabbedLayout)this.tabPane.getLayout()).calculateLayoutInfo();
            count = stabPane.getVisibleCount();
            startIndex = stabPane.getVisibleStartIndex();
            if (startIndex > index || index > startIndex + count - 1) {
                stabPane.setVisibleStartIndex(--visibleStartIndex);
            }
        }
        int c = stabPane.getVisibleCount();
        int s = stabPane.getVisibleStartIndex();
    }

    protected void selectNextTab(int current) {
        int i = current + 1;
        while (i < this.tabPane.getTabCount()) {
            if (this.tabPane.isEnabledAt(i)) {
                this.ensureVisibleTabAt(i);
                this.tabPane.setSelectedIndex(i);
                break;
            }
            ++i;
        }
    }

    protected void selectPreviousTab(int current) {
        int i = current - 1;
        while (i >= 0) {
            if (this.tabPane.isEnabledAt(i)) {
                this.ensureVisibleTabAt(i);
                this.tabPane.setSelectedIndex(i);
                break;
            }
            --i;
        }
    }

    void setMaxTabHeight(int maxTabHeight) {
        this.maxTabHeight = maxTabHeight;
    }

    int getMaxTabHeight() {
        return this.maxTabHeight;
    }

    Rectangle[] getRects() {
        return this.rects;
    }

    SingleRowTabbedPane getTabbedPane() {
        return (SingleRowTabbedPane)this.tabPane;
    }

    protected int calculateMaxTabHeight(int tabPlacement) {
        return super.calculateMaxTabHeight(tabPlacement);
    }

    protected int calculateTabWidth(int tabPlacement, int tabIndex, FontMetrics metrics) {
        return super.calculateTabWidth(tabPlacement, tabIndex, metrics);
    }

    protected void assureRectsCreated(int tabCount) {
        super.assureRectsCreated(tabCount);
    }

    protected class ShiftTabs
    implements ActionListener {
        SingleRowTabbedPane sPane;

        protected ShiftTabs() {
        }

        public void actionPerformed(ActionEvent e) {
            this.sPane = SingleRowTabbedPaneUI.this.getTabbedPane();
            int index = this.getStartIndex();
            this.sPane.setVisibleStartIndex(index);
            this.sPane.repaint();
        }

        protected int getStartIndex() {
            return 0;
        }

        protected int getStartIndex(int lastIndex) {
            Insets insets = this.sPane.getInsets();
            Insets tabAreaInsets = SingleRowTabbedPaneUI.this.getTabAreaInsets(this.sPane.getTabPlacement());
            int width = this.sPane.getSize().width - (insets.left + insets.right) - (tabAreaInsets.left + tabAreaInsets.right);
            Rectangle[] rects = SingleRowTabbedPaneUI.this.getRects();
            int index = lastIndex;
            while (index >= 0) {
                if ((width -= rects[index].width) < 0) break;
                --index;
            }
            return ++index;
        }
    }

    class SingleRowTabbedLayout
    extends BasicTabbedPaneUI.TabbedPaneLayout {
        JTabbedPane tabPane;

        SingleRowTabbedLayout(JTabbedPane tabPane) {
            super(SingleRowTabbedPaneUI.this);
            this.tabPane = tabPane;
        }

        public void layoutContainer(Container parent) {
            super.layoutContainer(parent);
            if (this.tabPane.getComponentCount() < 1) {
                return;
            }
            int tabPlacement = this.tabPane.getTabPlacement();
            int maxTabHeight = SingleRowTabbedPaneUI.this.calculateMaxTabHeight(tabPlacement);
            Insets tabAreaInsets = SingleRowTabbedPaneUI.this.getTabAreaInsets(tabPlacement);
            Insets insets = this.tabPane.getInsets();
            Rectangle bounds = this.tabPane.getBounds();
            SingleRowTabbedPane stabPane = (SingleRowTabbedPane)this.tabPane;
            Dimension d = stabPane.getButtonPreferredSize();
            JButton[] buttons = stabPane.getButtons();
            int buttonPlacement = stabPane.getButtonPlacement();
            int y = tabPlacement == 1 ? bounds.y + insets.top + tabAreaInsets.top : bounds.y + bounds.height - insets.bottom - tabAreaInsets.bottom - maxTabHeight;
            if (buttonPlacement == 4) {
                int x = bounds.x + bounds.width - insets.right;
                int i = buttons.length - 1;
                while (i >= 0) {
                    buttons[i].setBounds(x -= d.width, y, d.width, d.height);
                    --i;
                }
            } else {
                int x = bounds.x + insets.left;
                int i = 0;
                while (i < buttons.length) {
                    buttons[i].setBounds(x, y, d.width, d.height);
                    x += d.width;
                    ++i;
                }
            }
        }

        public void calculateLayoutInfo() {
            int tabCount = this.tabPane.getTabCount();
            SingleRowTabbedPaneUI.this.assureRectsCreated(tabCount);
            this.calculateTabWidths(this.tabPane.getTabPlacement(), tabCount);
            this.calculateTabRects(this.tabPane.getTabPlacement(), tabCount);
        }

        protected void calculateTabWidths(int tabPlacement, int tabCount) {
            if (tabCount == 0) {
                return;
            }
            Font font = this.tabPane.getFont();
            FontMetrics metrics = ((Component)this.tabPane).getFontMetrics(font);
            int fontHeight = metrics.getHeight();
            int maxTabHeight = SingleRowTabbedPaneUI.this.calculateMaxTabHeight(tabPlacement);
            SingleRowTabbedPaneUI.this.setMaxTabHeight(maxTabHeight);
            Rectangle[] rects = SingleRowTabbedPaneUI.this.getRects();
            int i = 0;
            while (i < tabCount) {
                rects[i].width = SingleRowTabbedPaneUI.this.calculateTabWidth(tabPlacement, i, metrics);
                rects[i].height = maxTabHeight;
                ++i;
            }
        }

        protected void calculateTabRects(int tabPlacement, int tabCount) {
            if (tabCount == 0) {
                return;
            }
            SingleRowTabbedPane stabPane = (SingleRowTabbedPane)this.tabPane;
            Dimension size = this.tabPane.getSize();
            Insets insets = this.tabPane.getInsets();
            Insets tabAreaInsets = SingleRowTabbedPaneUI.this.getTabAreaInsets(tabPlacement);
            int selectedIndex = this.tabPane.getSelectedIndex();
            int maxTabHeight = SingleRowTabbedPaneUI.this.getMaxTabHeight();
            int x = insets.left + tabAreaInsets.left;
            int y = tabPlacement == 1 ? insets.top + tabAreaInsets.top : size.height - insets.bottom - tabAreaInsets.bottom - maxTabHeight;
            int returnAt = size.width - (insets.right + tabAreaInsets.right);
            Rectangle[] rects = SingleRowTabbedPaneUI.this.getRects();
            int visibleStartIndex = stabPane.getVisibleStartIndex();
            int visibleCount = 0;
            int i = visibleStartIndex;
            while (i < tabCount) {
                Rectangle rect = rects[i];
                rect.x = visibleStartIndex < i ? rects[i - 1].x + rects[i - 1].width : x;
                if (rect.x + rect.width > returnAt) break;
                ++visibleCount;
                rect.y = y;
                ++i;
            }
            stabPane.setVisibleCount(visibleCount);
            stabPane.setVisibleStartIndex(visibleStartIndex);
        }
    }
}

