/*
 * Decompiled with CFR 0.152.
 */
package neatwork.gui.tabbedpane;

import java.awt.Component;
import java.awt.Dimension;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JTabbedPane;
import javax.swing.plaf.basic.BasicArrowButton;
import neatwork.Messages;
import neatwork.gui.tabbedpane.SingleRowTabbedPaneUI;
import neatwork.gui.tabbedpane.StopArrowButton;
import neatwork.gui.tabbedpane.TabbedPaneButton;

public class SingleRowTabbedPane
extends JTabbedPane {
    public static final String ROTATE = Messages.getString("SingleRowTabbedPane.Rotate");
    public static final String PREVIOUS = Messages.getString("SingleRowTabbedPane.Previous");
    public static final String NEXT = Messages.getString("SingleRowTabbedPane.Next");
    public static final String FIRST = Messages.getString("SingleRowTabbedPane.First");
    public static final String LEFT_SHIFT = Messages.getString("SingleRowTabbedPane.Left");
    public static final String RIGHT_SHIFT = Messages.getString("SingleRowTabbedPane.Right");
    public static final String LAST = Messages.getString("SingleRowTabbedPane.Last");
    public static final int ONE_BUTTON = 1;
    public static final int TWO_BUTTONS = 2;
    public static final int FOUR_BUTTONS = 4;
    protected int buttonPlacement;
    protected int buttonCount;
    protected JButton[] tabPaneButtons;
    protected Dimension buttonSize;
    protected int visibleCount;
    protected int visibleStartIndex;
    private final int BUTTON_WIDTH = 16;
    private final int BUTTON_HEIGHT = 17;

    public SingleRowTabbedPane() {
        this(2, 4);
    }

    public SingleRowTabbedPane(int buttonCount, int buttonPlacement) {
        this.setButtonPreferredSize(new Dimension(16, 17));
        this.tabPaneButtons = this.createButtons(buttonCount);
        this.buttonPlacement = buttonPlacement;
        this.visibleStartIndex = 0;
        this.setUI(new SingleRowTabbedPaneUI());
    }

    public void setTabPlacement(int tabPlacement) {
        if (tabPlacement == 2 || tabPlacement == 4) {
            throw new IllegalArgumentException("not suported: LEFT and RIGHT");
        }
        super.setTabPlacement(tabPlacement);
    }

    public int getButtonPlacement() {
        return this.buttonPlacement;
    }

    public void setButtonPreferredSize(Dimension d) {
        if (d != null) {
            this.buttonSize = d;
        }
    }

    public Dimension getButtonPreferredSize() {
        return this.buttonSize;
    }

    public JButton[] getButtons() {
        return this.tabPaneButtons;
    }

    public int getButtonCount() {
        return this.buttonCount;
    }

    public void insertTab(String title, Icon icon, Component component, String tip, int index) {
        if (component instanceof TabbedPaneButton) {
            component.setVisible(true);
            this.addImpl(component, null, -1);
            return;
        }
        super.insertTab(title, icon, component, tip, index);
    }

    public boolean isVisibleTab(int index) {
        return this.visibleStartIndex <= index && index < this.visibleStartIndex + this.visibleCount;
    }

    public int getVisibleCount() {
        return this.visibleCount;
    }

    public void setVisibleCount(int visibleCount) {
        if (visibleCount < 0) {
            return;
        }
        this.visibleCount = visibleCount;
    }

    public int getVisibleStartIndex() {
        return this.visibleStartIndex;
    }

    public void setVisibleStartIndex(int visibleStartIndex) {
        if (visibleStartIndex < 0 || this.getTabCount() <= visibleStartIndex) {
            return;
        }
        this.visibleStartIndex = visibleStartIndex;
    }

    protected JButton[] createButtons(int buttonCount) {
        JButton[] tabPaneButtons = null;
        switch (buttonCount) {
            case 1: {
                this.buttonCount = buttonCount;
                tabPaneButtons = new JButton[buttonCount];
                tabPaneButtons[0] = new PrevOrNextButton(3);
                tabPaneButtons[0].setActionCommand(ROTATE);
                break;
            }
            case 2: {
                this.buttonCount = buttonCount;
                tabPaneButtons = new JButton[buttonCount];
                tabPaneButtons[0] = new PrevOrNextButton(7);
                tabPaneButtons[0].setActionCommand(PREVIOUS);
                tabPaneButtons[1] = new PrevOrNextButton(3);
                tabPaneButtons[1].setActionCommand(NEXT);
                break;
            }
            case 4: {
                this.buttonCount = buttonCount;
                tabPaneButtons = new JButton[buttonCount];
                tabPaneButtons[0] = new FirstOrLastButton(7);
                tabPaneButtons[0].setActionCommand(FIRST);
                tabPaneButtons[1] = new PrevOrNextButton(7);
                tabPaneButtons[1].setActionCommand(LEFT_SHIFT);
                tabPaneButtons[2] = new PrevOrNextButton(3);
                tabPaneButtons[2].setActionCommand(RIGHT_SHIFT);
                tabPaneButtons[3] = new FirstOrLastButton(3);
                tabPaneButtons[3].setActionCommand(LAST);
            }
        }
        return tabPaneButtons;
    }

    class FirstOrLastButton
    extends StopArrowButton
    implements TabbedPaneButton {
        public FirstOrLastButton(int direction) {
            super(direction);
        }
    }

    class PrevOrNextButton
    extends BasicArrowButton
    implements TabbedPaneButton {
        public PrevOrNextButton(int direction) {
            super(direction);
        }
    }
}

