/*
 * Decompiled with CFR 0.152.
 */
package neatwork.gui.simu;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextArea;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import neatwork.Messages;
import neatwork.file.AbstractFileManager;
import neatwork.gui.SolverProgressDialog;
import neatwork.gui.fancytable.FancyTable;
import neatwork.gui.simu.NewSimuDialog;
import neatwork.gui.simu.SimuTableModel;
import neatwork.gui.simu.ThreadRunSimulation;
import neatwork.project.Design;
import neatwork.project.Simulation;
import neatwork.solver.AbstractSolver;
import neatwork.solver.SolverClient;
import neatwork.solver.SolverDisk;
import neatwork.utils.Tools;

public class SimulationPane
extends JPanel
implements ActionListener,
ListSelectionListener {
    private Vector listSimu;
    private String[] listTable = new String[]{"", Messages.getString("SimulationPane.Flows_at_faucets"), Messages.getString("SimulationPane.Percentiles_at_faucets"), Messages.getString("SimulationPane.Speed_in_pipes"), Messages.getString("SimulationPane.Nodes_pressure")};
    private Design design;
    private AbstractFileManager fileManager;
    private Properties properties;
    private Action deleteSimuAction;
    private Action reportAction;
    private SimuTableModel simuTableModel;
    private Simulation simu;
    private JButton buttonNew;
    private JTextArea textAreaParam;
    private JComboBox comboSimu;
    private JList listTableau;
    private FancyTable table;

    public SimulationPane(Design design, AbstractFileManager fileManager, Properties defProp) {
        this.design = design;
        this.fileManager = fileManager;
        this.properties = defProp;
        this.setListSimu(fileManager.getListFile(2));
        ImageIcon icon = new ImageIcon(this.getClass().getResource("/neatwork/gui/images/Delete.png"));
        this.deleteSimuAction = new AbstractAction("", icon){

            public void actionPerformed(ActionEvent e) {
                SimulationPane.this.deleteSimu();
            }
        };
        this.deleteSimuAction.putValue("ShortDescription", Messages.getString("SimulationPane.Delete_this_simulation"));
        icon = new ImageIcon(this.getClass().getResource("/neatwork/gui/images/report.png"));
        this.reportAction = new AbstractAction("", icon){

            public void actionPerformed(ActionEvent e) {
                int i;
                Vector v;
                String s = "<html><head><title>";
                s = String.valueOf(s) + Messages.getString("SimulationPane.Simulation_report");
                s = String.valueOf(s) + "</title></head><body>";
                s = String.valueOf(s) + "<h1>" + Messages.getString("SimulationPane.Simulation_report0") + SimulationPane.this.simu.getName() + "</h1>";
                s = String.valueOf(s) + "<h2>" + Messages.getString("SimulationPane.Parameters") + "</h2>";
                s = String.valueOf(s) + Messages.getString("SimulationPane.Simulated_design") + SimulationPane.this.design.getName() + "<br>";
                s = String.valueOf(s) + Messages.getString("SimulationPane.Type_of_simulation0") + SimulationPane.this.simu.getProperties().getProperty("simu.typesimu.value");
                if (SimulationPane.this.simu.getProperties().getProperty("simu.typesimu.value").equals("random")) {
                    s = String.valueOf(s) + Messages.getString("SimulationPane.<br>Number_of_simulations") + SimulationPane.this.simu.getProperties().getProperty("simu.nbsim.value");
                    s = String.valueOf(s) + Messages.getString("SimulationPane.<br>Fraction_of_open_faucets") + SimulationPane.this.simu.getProperties().getProperty("simu.simopentaps.value");
                }
                if (SimulationPane.this.simu.getProperties().getProperty("simu.typesimu.value").equals("tapbytap")) {
                    s = String.valueOf(s) + Messages.getString("SimulationPane.<br>Number_of_simulations") + SimulationPane.this.simu.getProperties().getProperty("simu.nbsim.value");
                }
                s = String.valueOf(s) + Messages.getString("SimulationPane.<br>Used_type_of_orifice") + SimulationPane.this.simu.getProperties().getProperty("simu.typeorifice.value");
                s = String.valueOf(s) + Messages.getString("SimulationPane.<h2>Flows_at_faucet</h2>");
                s = String.valueOf(s) + "<table BORDER CELLPADDING=0 CELLSPACING=0>";
                s = String.valueOf(s) + Messages.getString("SimulationPane.<tr><th>Faucet_ID</th><th>Nb_of_occurences</th><th>Min</th>") + Messages.getString("SimulationPane.<th>Average</th><th>Max</th><th>Variability</th><th>&lt;") + SimulationPane.this.simu.getProperties().getProperty("simu.mincriticalflow.value", "") + "</th><th>&gt; " + SimulationPane.this.simu.getProperties().getProperty("simu.maxcriticalflow.value", "") + Messages.getString("SimulationPane.</th><th>nb_of_failures</th></tr>");
                Enumeration en = SimulationPane.this.simu.getFlowTaps().elements();
                while (en.hasMoreElements()) {
                    v = (Vector)en.nextElement();
                    s = String.valueOf(s) + "<tr>";
                    i = 0;
                    while (i < v.size()) {
                        s = String.valueOf(s) + "<td>" + v.get(i) + "</td>";
                        ++i;
                    }
                    s = String.valueOf(s) + "</tr>";
                }
                s = String.valueOf(s) + "</table>";
                s = String.valueOf(s) + Messages.getString("SimulationPane.<h2>Percentiles_at_faucet</h2>");
                s = String.valueOf(s) + "<table BORDER CELLPADDING=0 CELLSPACING=0>";
                s = String.valueOf(s) + Messages.getString("SimulationPane.<tr><th>Faucet_ID</th><th>Nb_of_occurences</th><th>Min</th>") + Messages.getString("SimulationPane.<th>&lt;_10</th><th>&lt;_25</th><th>&lt;_50</th><th>&lt;_75</th>") + Messages.getString("SimulationPane.<th>&lt;_90</th><th>Max</th></tr>");
                en = SimulationPane.this.simu.getQuartileTaps().elements();
                while (en.hasMoreElements()) {
                    v = (Vector)en.nextElement();
                    s = String.valueOf(s) + "<tr>";
                    i = 0;
                    while (i < v.size()) {
                        s = String.valueOf(s) + "<td>" + v.get(i) + "</td>";
                        ++i;
                    }
                    s = String.valueOf(s) + "</tr>";
                }
                s = String.valueOf(s) + "</table>";
                s = String.valueOf(s) + Messages.getString("SimulationPane.<h2>Speed_in_pipes</h2>");
                s = String.valueOf(s) + "<table BORDER CELLPADDING=0 CELLSPACING=0>";
                s = String.valueOf(s) + Messages.getString("SimulationPane.<tr><th>Pipe_ID</th><th>Nb_of_simulation</th><th>Average</th>") + Messages.getString("SimulationPane.<th>Maximum</th></tr>");
                en = SimulationPane.this.simu.getQuartileTaps().elements();
                while (en.hasMoreElements()) {
                    v = (Vector)en.nextElement();
                    s = String.valueOf(s) + "<tr>";
                    i = 0;
                    while (i < 4) {
                        s = String.valueOf(s) + "<td>" + v.get(i) + "</td>";
                        ++i;
                    }
                    s = String.valueOf(s) + "</tr>";
                }
                s = String.valueOf(s) + "</table>";
                s = String.valueOf(s) + Messages.getString("SimulationPane.<h2>Nodes_Pressure</h2>");
                s = String.valueOf(s) + "<table BORDER CELLPADDING=0 CELLSPACING=0>";
                s = String.valueOf(s) + Messages.getString("SimulationPane.<tr><th>Node_ID</th><th>Minimum</th><th>Average</th>") + Messages.getString("SimulationPane.<th>Maximum</th></tr>");
                en = SimulationPane.this.simu.getNodesPressure().elements();
                while (en.hasMoreElements()) {
                    v = (Vector)en.nextElement();
                    s = String.valueOf(s) + "<tr>";
                    i = 0;
                    while (i < v.size()) {
                        s = String.valueOf(s) + "<td>" + v.get(i) + "</td>";
                        ++i;
                    }
                    s = String.valueOf(s) + "</tr>";
                }
                s = String.valueOf(s) + "</table>";
                Tools.enregFich(s);
            }
        };
        this.reportAction.putValue("ShortDescription", Messages.getString("SimulationPane.report_in_HTML"));
        this.simuTableModel = new SimuTableModel(design, this.simu, this.table);
        this.dessinComponent();
        if (this.listSimu.size() > 0) {
            this.comboSimu.setSelectedIndex(0);
        }
        this.updateComponent();
    }

    private void runSimulation(NewSimuDialog dialog) {
        AbstractSolver solver = null;
        solver = this.properties.getProperty("solver.distant").equals("true") ? new SolverClient(this.properties) : new SolverDisk();
        solver.init();
        ThreadRunSimulation thread = new ThreadRunSimulation(dialog, solver);
        SolverProgressDialog solverDialog = new SolverProgressDialog(solver, thread);
        ((Component)solverDialog).setVisible(true);
        String firstName = this.getFirstPossibleSimuName();
        String fileName = String.valueOf(this.design.getName()) + "." + firstName;
        this.fileManager.writeFile(fileName, solver.getSimulationContent(), 2);
        this.comboSimu.addItem("simu " + firstName);
        this.comboSimu.setSelectedIndex(this.comboSimu.getModel().getSize() - 1);
    }

    private void deleteSimu() {
        if (this.comboSimu.getSelectedIndex() > -1) {
            String simuName = this.comboSimu.getSelectedItem().toString().substring(5);
            this.fileManager.deleteFile(String.valueOf(this.design.getName()) + "." + simuName, 2);
            this.comboSimu.removeItemAt(this.comboSimu.getSelectedIndex());
        }
    }

    private void setListSimu(String[] names) {
        this.listSimu = new Vector();
        int i = 0;
        while (i < names.length) {
            if (names[i].startsWith(String.valueOf(this.design.getName()) + ".")) {
                this.listSimu.add("simu " + names[i].substring(this.design.getName().length() + 1));
            }
            ++i;
        }
    }

    private String getFirstPossibleSimuName() {
        int num = 0;
        Enumeration enumeration = this.listSimu.elements();
        while (enumeration.hasMoreElements()) {
            String item = enumeration.nextElement().toString();
            int itemNum = Integer.parseInt(item.substring("simu ".length()));
            num = Math.max(num, itemNum + 1);
        }
        return "" + num;
    }

    private void dessinComponent() {
        JPanel panel0 = new JPanel(new BorderLayout(3, 3));
        this.comboSimu = new JComboBox(this.listSimu);
        this.comboSimu.setActionCommand("SelectSimu");
        this.comboSimu.addActionListener(this);
        this.buttonNew = new JButton(Messages.getString("SimulationPane.New_Simulation..."));
        this.buttonNew.setActionCommand("NewSim");
        this.buttonNew.addActionListener(this);
        JPanel panel02 = new JPanel(new FlowLayout(0));
        panel02.add(this.buttonNew);
        JButton b0 = new JButton(this.deleteSimuAction);
        b0.setBorder(BorderFactory.createEtchedBorder());
        panel02.add(b0);
        JButton b1 = new JButton(this.reportAction);
        b1.setBorder(BorderFactory.createEtchedBorder());
        panel02.add(b1);
        JPanel jpanelT = new JPanel(new BorderLayout());
        jpanelT.add((Component)panel02, "North");
        jpanelT.add((Component)this.comboSimu, "South");
        this.textAreaParam = new JTextArea("");
        this.textAreaParam.setEditable(false);
        panel0.add((Component)jpanelT, "North");
        panel0.add((Component)new JScrollPane(this.textAreaParam), "Center");
        this.listTableau = new JList<String>(this.listTable);
        this.listTableau.addListSelectionListener(this);
        this.table = new FancyTable(this.simuTableModel);
        JSplitPane split1 = new JSplitPane(1, panel0, new JScrollPane(this.listTableau));
        split1.setOneTouchExpandable(true);
        split1.setDividerLocation(300);
        JSplitPane split2 = new JSplitPane(0, split1, new JScrollPane(this.table));
        split2.setOneTouchExpandable(true);
        split2.setDividerLocation(200);
        this.setLayout(new BorderLayout());
        this.add((Component)split2, "Center");
    }

    public void updateComponent() {
        boolean itsOK = this.simu != null;
        this.textAreaParam.setEnabled(itsOK);
        this.table.setEnabled(itsOK);
        this.listTableau.setEnabled(itsOK);
        String content = "";
        String[] listTypeSimu = new String[]{Messages.getString("NewSimuDialog.monte-carlo_sampling"), Messages.getString("NewSimuDialog.individual_faucets"), Messages.getString("NewSimuDialog.user-defined")};
        String[] listTypeOrifice = new String[]{Messages.getString("NewSimuDialog.ideal"), Messages.getString("NewSimuDialog.commercial")};
        if (this.simu != null) {
            ((Hashtable)this.properties).putAll(this.simu.getProperties());
            content = String.valueOf(Messages.getString("simu.nbsim.name")) + "\t: " + this.properties.getProperty("simu.nbsim.value") + "\n";
            content = String.valueOf(content) + Messages.getString("simu.simopentaps.name") + "\t: " + this.properties.getProperty("simu.simopentaps.value") + "\n";
            content = String.valueOf(content) + Messages.getString("simu.typeorifice.name") + "\t\t: ";
            content = this.properties.getProperty("simu.typeorifice.value").equals("commercial") ? String.valueOf(content) + listTypeOrifice[1] + "\n" : String.valueOf(content) + listTypeOrifice[0] + "\n";
            content = String.valueOf(content) + Messages.getString("simu.typesimu.name") + "\t: ";
            content = this.properties.getProperty("simu.typesimu.value").equals("random") ? String.valueOf(content) + listTypeSimu[0] : (this.properties.getProperty("simu.typesimu.value").equals("tapbytap") ? String.valueOf(content) + listTypeSimu[1] : String.valueOf(content) + listTypeSimu[2]);
        }
        this.textAreaParam.setText(content);
        this.setResultsTable();
    }

    private void setResultsTable() {
        this.table.setVisible(true);
        if (this.simu != null) {
            switch (this.listTableau.getSelectedIndex()) {
                case 0: {
                    this.simuTableModel.setModel(1);
                    break;
                }
                case 1: {
                    this.simuTableModel.setModel(2);
                    break;
                }
                case 2: {
                    this.simuTableModel.setModel(3);
                    break;
                }
                case 3: {
                    this.simuTableModel.setModel(4);
                    break;
                }
                case 4: {
                    this.simuTableModel.setModel(5);
                    break;
                }
                default: {
                    this.simuTableModel.setModel(0);
                    break;
                }
            }
        } else {
            this.table.setVisible(false);
        }
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getActionCommand().equals("NewSim")) {
            boolean isOk = false;
            if (!this.isDesignSaved()) {
                JOptionPane.showMessageDialog(null, Messages.getString("SimulationPane.You_have_to_save_this_design_in_order_to_run_a_simulation."), Messages.getString("SimulationPane.Design_not_saved"), 2);
            } else {
                isOk = true;
            }
            if (isOk) {
                NewSimuDialog dialog = new NewSimuDialog(this.design, this.fileManager, this.design.getProperties());
                ((Component)dialog).setVisible(true);
                if (dialog.runSimu) {
                    this.runSimulation(dialog);
                }
                this.eatProperties("simu.simopentaps.value", dialog.getParameters());
                this.eatProperties("simu.typeorifice.value", dialog.getParameters());
                this.eatProperties("simu.typesimu.value", dialog.getParameters());
                this.eatProperties("simu.nbsim.value", dialog.getParameters());
                this.eatProperties("simu.targetflow.value", dialog.getParameters());
                this.eatProperties("simu.maxcriticalflow.value", dialog.getParameters());
                this.eatProperties("simu.mincriticalflow.value", dialog.getParameters());
            }
        }
        if (e.getActionCommand().equals("SelectSimu")) {
            if (this.comboSimu.getSelectedIndex() > -1) {
                String name = this.comboSimu.getSelectedItem().toString().substring("simu ".length());
                this.simu = new Simulation(String.valueOf(this.design.getName()) + "." + name);
                this.simu.setContent(this.fileManager.readFile(this.simu.getName(), 2));
                this.simuTableModel = new SimuTableModel(this.design, this.simu, this.table);
                this.table.setModel(this.simuTableModel);
                this.simuTableModel.fireTableDataChanged();
            } else {
                this.simu = null;
            }
            this.updateComponent();
        }
    }

    public void valueChanged(ListSelectionEvent e) {
        this.setResultsTable();
    }

    public boolean isDesignSaved() {
        String[] fdsg = this.fileManager.getListFile(1);
        boolean find = false;
        int i = 0;
        while (i < fdsg.length && !find) {
            find = fdsg[i].equals(this.design.getName());
            ++i;
        }
        return find;
    }

    private void eatProperties(String n, Properties p) {
        this.design.getProperties().setProperty(n, p.getProperty(n));
    }
}

