/*
 * Decompiled with CFR 0.152.
 */
package neatwork.gui.simu;

import java.awt.Color;
import java.util.Hashtable;
import java.util.Vector;
import neatwork.Messages;
import neatwork.gui.fancytable.FancyTable;
import neatwork.gui.fancytable.FancyTableModel;
import neatwork.project.Design;
import neatwork.project.Simulation;
import neatwork.utils.ProgressCellRenderer;

public class SimuTableModel
extends FancyTableModel {
    public static final int TYPE_NULL = 0;
    public static final int TYPE_DESIGNDIFF = 1;
    public static final int TYPE_FLOWTAPS = 2;
    public static final int TYPE_QUARTILETAPS = 3;
    public static final int TYPE_SPEEDPIPE = 4;
    public static final int TYPE_NODEPRESSURE = 5;
    private String[] myHeader1 = new String[]{Messages.getString("SimuTableModel.Comments")};
    private int[] myWhidth1 = new int[]{100};
    private String[] myHeader2 = new String[]{Messages.getString("SimuTableModel.Faucet_ID"), Messages.getString("SimuTableModel._#_of_occurences"), Messages.getString("SimuTableModel.Min"), Messages.getString("SimuTableModel.Average"), Messages.getString("SimuTableModel.Max"), Messages.getString("SimuTableModel.Variability"), "<", ">", Messages.getString("SimuTableModel._#_of_failures")};
    private int[] myWhidth2 = new int[]{50, 50, 50, 50, 50, 50, 50, 50, 50};
    private String[] myHeader3 = new String[]{Messages.getString("SimuTableModel.Faucet_ID"), Messages.getString("SimuTableModel._#_of_occurences"), Messages.getString("SimuTableModel.Min"), Messages.getString("SimuTableModel.<10%"), Messages.getString("SimuTableModel.<25%"), Messages.getString("SimuTableModel.<50%"), Messages.getString("SimuTableModel.<75%"), Messages.getString("SimuTableModel.<90%"), Messages.getString("SimuTableModel.Max")};
    private int[] myWhidth3 = new int[]{50, 50, 50, 50, 50, 50, 50, 50, 50};
    private String[] myHeader4 = new String[]{Messages.getString("SimuTableModel.Pipe_ID"), Messages.getString("SimuTableModel._#_of_simulation"), Messages.getString("SimuTableModel.Average"), Messages.getString("SimuTableModel.Maximum")};
    private int[] myWhidth4 = new int[]{50, 50, 50, 50};
    private String[] myHeader5 = new String[]{Messages.getString("SimuTableModel.Node_ID"), Messages.getString("SimuTableModel.Minimum"), Messages.getString("SimuTableModel.Average"), Messages.getString("SimuTableModel.Maximum")};
    private int[] myWhidth5 = new int[]{50, 50, 50, 50};
    private String[] myHeader = new String[]{""};
    private int[] myWhidthHeader = new int[]{100};
    private int currentType = 0;
    private Simulation simu;
    private Design design;
    private FancyTable table;
    static /* synthetic */ Class class$0;

    public SimuTableModel(Design design, Simulation simu, FancyTable table) {
        this.simu = simu;
        this.table = table;
        this.header = this.myHeader;
        this.widthHeader = this.myWhidthHeader;
        this.updateData();
    }

    public void setModel(int type) {
        this.currentType = type;
        this.updateData();
        this.table.autoFit();
    }

    public void updateData() {
        this.data = new Vector();
        switch (this.currentType) {
            case 1: {
                this.header = this.myHeader1;
                this.widthHeader = this.myWhidth1;
                Vector<String> v = new Vector<String>();
                v.add(Messages.getString("SimuTableModel.Not_yet_implemented__!"));
                this.data.add(v);
                break;
            }
            case 2: {
                this.header = this.myHeader2;
                this.widthHeader = this.myWhidth2;
                this.header[6] = "< " + this.simu.getProperties().getProperty("simu.mincriticalflow.value", "");
                this.header[7] = "> " + this.simu.getProperties().getProperty("simu.maxcriticalflow.value", "");
                this.data = this.simu.getFlowTaps();
                break;
            }
            case 3: {
                this.header = this.myHeader3;
                this.widthHeader = this.myWhidth3;
                this.data = this.simu.getQuartileTaps();
                break;
            }
            case 4: {
                this.header = this.myHeader4;
                this.widthHeader = this.myWhidth4;
                this.data = this.simu.getSpeedPipe();
                break;
            }
            case 5: {
                this.header = this.myHeader5;
                this.widthHeader = this.myWhidth5;
                this.data = this.simu.getNodesPressure();
                break;
            }
            default: {
                this.header = this.myHeader;
                this.widthHeader = this.myWhidthHeader;
            }
        }
        this.fireTableStructureChanged();
        switch (this.currentType) {
            case 1: {
                break;
            }
            case 2: {
                ProgressCellRenderer renderer = new ProgressCellRenderer();
                renderer.setStringPainted(true);
                renderer.setBackground(this.table.getBackground());
                renderer.setForeground(this.table.getForeground());
                renderer.setFont(this.table.getFont());
                Hashtable<Integer, Color> limitColors = new Hashtable<Integer, Color>();
                limitColors.put(new Integer(0), Color.green);
                limitColors.put(new Integer(60), Color.yellow);
                limitColors.put(new Integer(80), Color.red);
                renderer.setLimits(limitColors);
                this.table.getColumnModel().getColumn(5).setCellRenderer(renderer);
                this.table.getColumnModel().getColumn(6).setCellRenderer(renderer);
                this.table.getColumnModel().getColumn(7).setCellRenderer(renderer);
                break;
            }
            case 3: {
                break;
            }
            case 4: {
                break;
            }
        }
    }

    public Class getColumnClass(int col) {
        if (this.data.size() > 0) {
            return ((Vector)this.data.get(0)).get(col).getClass();
        }
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("java.lang.Object");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return clazz;
    }

    protected Vector getNewVector() {
        return null;
    }

    public boolean isCellEditable(int row, int col) {
        return true;
    }

    public void setValueAt(Object o, int row, int col) {
    }
}

