/*
 * Decompiled with CFR 0.152.
 */
package neatwork.gui.simu;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Properties;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import neatwork.Messages;
import neatwork.file.AbstractFileManager;
import neatwork.gui.simu.TapSelectionDialog;
import neatwork.project.Design;
import neatwork.project.Node;
import neatwork.utils.DoubleInputVerifier;
import neatwork.utils.IntegerInputVerifier;

public class NewSimuDialog
extends JDialog
implements ActionListener {
    private JTextField nbSimField;
    private JTextField openTapsField;
    private JTextField outFlowField;
    private JTextField critFlowLowField;
    private JTextField critFlowHighField;
    private JComboBox typeOrificeCombo;
    private JComboBox typeSimuCombo;
    private Properties prop;
    private Design design;
    private Hashtable table = new Hashtable();
    public boolean runSimu = false;

    public NewSimuDialog(Design design, AbstractFileManager fileManager, Properties defProp) {
        this.setTitle(Messages.getString("NewSimuDialog.Simulation_parameters"));
        this.setModal(true);
        ((Component)this).setSize(400, 350);
        Dimension d = Toolkit.getDefaultToolkit().getScreenSize();
        ((Component)this).setLocation((d.width - this.getSize().width) / 2, (d.height - this.getSize().height) / 2);
        this.setDefaultCloseOperation(2);
        this.design = design;
        this.prop = new Properties(defProp);
        ((Hashtable)this.prop).putAll(design.getProperties());
        DoubleInputVerifier dblInput = new DoubleInputVerifier();
        IntegerInputVerifier intInput = new IntegerInputVerifier();
        this.nbSimField = new JTextField(this.prop.getProperty("simu.nbsim.value"), 15);
        this.nbSimField.setInputVerifier(intInput);
        this.openTapsField = new JTextField(this.prop.getProperty("simu.simopentaps.value"), 15);
        this.openTapsField.setInputVerifier(dblInput);
        this.outFlowField = new JTextField(this.prop.getProperty("simu.targetflow.value"), 15);
        this.outFlowField.setInputVerifier(dblInput);
        this.critFlowLowField = new JTextField(this.prop.getProperty("simu.mincriticalflow.value"), 15);
        this.critFlowLowField.setInputVerifier(dblInput);
        this.critFlowHighField = new JTextField(this.prop.getProperty("simu.maxcriticalflow.value"), 15);
        this.critFlowHighField.setInputVerifier(dblInput);
        String[] listTypeOrifice = new String[]{Messages.getString("NewSimuDialog.ideal"), Messages.getString("NewSimuDialog.commercial")};
        this.typeOrificeCombo = new JComboBox<String>(listTypeOrifice);
        if (this.prop.getProperty("simu.typeorifice.value").equals("commercial")) {
            this.typeOrificeCombo.setSelectedIndex(1);
        } else {
            this.typeOrificeCombo.setSelectedIndex(0);
        }
        String[] listTypeSimu = new String[]{Messages.getString("NewSimuDialog.monte-carlo_sampling"), Messages.getString("NewSimuDialog.individual_faucets"), Messages.getString("NewSimuDialog.user-defined")};
        this.typeSimuCombo = new JComboBox<String>(listTypeSimu);
        if (this.prop.getProperty("simu.typesimu.value").equals("random")) {
            this.typeSimuCombo.setSelectedIndex(0);
        } else if (this.prop.getProperty("simu.typesimu.value").equals("tapbytap")) {
            this.typeSimuCombo.setSelectedIndex(1);
        } else {
            this.typeSimuCombo.setSelectedIndex(2);
        }
        JPanel fieldPane = new JPanel(new GridLayout(0, 2, 2, 2));
        fieldPane.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEtchedBorder(), BorderFactory.createEmptyBorder(5, 5, 5, 5)));
        fieldPane.add(new JLabel(String.valueOf(Messages.getString("simu.nbsim.name")) + ":"));
        fieldPane.add(this.nbSimField);
        fieldPane.add(new JLabel(String.valueOf(Messages.getString("simu.simopentaps.name")) + ":"));
        fieldPane.add(this.openTapsField);
        fieldPane.add(new JLabel(Messages.getString("NewSimuDialog.critical_flows")));
        fieldPane.add(new JLabel(""));
        fieldPane.add(new JLabel("     " + Messages.getString("simu.mincriticalflow.name") + ":"));
        fieldPane.add(this.critFlowLowField);
        fieldPane.add(new JLabel("     " + Messages.getString("simu.maxcriticalflow.name") + ":"));
        fieldPane.add(this.critFlowHighField);
        fieldPane.add(new JLabel(String.valueOf(Messages.getString("simu.targetflow.name")) + ":"));
        fieldPane.add(this.outFlowField);
        fieldPane.add(new JLabel(String.valueOf(Messages.getString("simu.typeorifice.name")) + ":"));
        fieldPane.add(this.typeOrificeCombo);
        fieldPane.add(new JLabel(String.valueOf(Messages.getString("simu.typesimu.name")) + ":"));
        fieldPane.add(this.typeSimuCombo);
        JPanel bottomPane = new JPanel(new FlowLayout(2));
        JButton runSimu = new JButton(Messages.getString("NewSimuDialog.Run_Simulation..."));
        runSimu.setActionCommand("runSimu");
        runSimu.addActionListener(this);
        JButton close = new JButton(Messages.getString("NewSimuDialog.Close"));
        close.setActionCommand("close");
        close.addActionListener(this);
        bottomPane.add(close);
        bottomPane.add(runSimu);
        JPanel container = (JPanel)this.getContentPane();
        container.setLayout(new BorderLayout(5, 5));
        container.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        container.add((Component)bottomPane, "Center");
        container.add((Component)fieldPane, "North");
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getActionCommand().equals("close")) {
            this.dispose();
        }
        if (e.getActionCommand().equals("runSimu")) {
            if (this.typeSimuCombo.getSelectedIndex() == 1) {
                int cpt = 0;
                Iterator iter = this.design.getNodeIterator();
                while (iter.hasNext()) {
                    Node item = (Node)iter.next();
                    cpt += item.getType() == 2 ? 1 : 0;
                }
                this.nbSimField.setText("" + cpt);
                this.openTapsField.setText("-");
            }
            if (this.typeSimuCombo.getSelectedIndex() == 2) {
                this.nbSimField.setText("1");
                this.openTapsField.setText("-");
                TapSelectionDialog dialog = new TapSelectionDialog(this.design, this);
                ((Component)dialog).setVisible(true);
                this.table = dialog.getFaucetRef();
            }
            this.runSimu = true;
            this.dispose();
        }
    }

    public Design getDesign() {
        return this.design;
    }

    public Properties getParameters() {
        Properties p = new Properties(this.prop);
        p.setProperty("simu.nbsim.value", this.nbSimField.getText());
        p.setProperty("simu.simopentaps.value", this.openTapsField.getText());
        p.setProperty("simu.targetflow.value", this.outFlowField.getText());
        p.setProperty("simu.mincriticalflow.value", this.critFlowLowField.getText());
        p.setProperty("simu.maxcriticalflow.value", this.critFlowHighField.getText());
        p.setProperty("simu.typeorifice.value", this.typeOrificeCombo.getSelectedItem().toString());
        String value = "";
        switch (this.typeSimuCombo.getSelectedIndex()) {
            case 0: {
                value = "random";
                break;
            }
            case 1: {
                value = "tapbytap";
                break;
            }
            case 2: {
                value = "handmade";
            }
        }
        p.setProperty("simu.typesimu.value", value);
        return p;
    }

    public Hashtable getFaucetRef() {
        return this.table;
    }
}

