/*
 * Decompiled with CFR 0.152.
 */
package neatwork.gui.makedesign;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Observable;
import java.util.Observer;
import java.util.Properties;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import neatwork.Messages;
import neatwork.project.Topographie;
import neatwork.utils.DoubleInputVerifier;
import neatwork.utils.IntegerInputVerifier;

public class ParametersPane
extends JPanel
implements Observer,
ActionListener {
    private Topographie topo;
    private JTextField[] textfield;

    public ParametersPane(Topographie topo0) {
        this.topo = topo0;
        this.topo.addObserver(this);
        DoubleInputVerifier dblInput = new DoubleInputVerifier();
        IntegerInputVerifier intInput = new IntegerInputVerifier();
        this.textfield = new JTextField[8];
        int i = 0;
        while (i < this.textfield.length) {
            this.textfield[i] = new JTextField(10);
            this.textfield[i].setInputVerifier(dblInput);
            ++i;
        }
        JPanel fieldPane = new JPanel(new GridLayout(0, 2, 2, 2));
        fieldPane.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEtchedBorder(), BorderFactory.createEmptyBorder(5, 5, 5, 5)));
        Properties prop = this.topo.getProperties();
        fieldPane.add(new JLabel(Messages.getString("ParametersPane.<html><b>-_Make_Design_Parameters</b>")));
        fieldPane.add(new JLabel(""));
        fieldPane.add(new JLabel(String.valueOf(Messages.getString("topo.opentaps.name")) + ":"));
        fieldPane.add(this.textfield[0]);
        fieldPane.add(new JLabel(String.valueOf(Messages.getString("topo.servicequal.name")) + ":"));
        fieldPane.add(this.textfield[1]);
        fieldPane.add(new JLabel(String.valueOf(Messages.getString("topo.targetflow.name")) + ":"));
        fieldPane.add(this.textfield[2]);
        fieldPane.add(new JLabel(String.valueOf(Messages.getString("topo.limitbudget.name")) + ":"));
        fieldPane.add(this.textfield[3]);
        fieldPane.add(new JLabel(Messages.getString("ParametersPane.<html><b>-_Physical_Parameters</b>")));
        fieldPane.add(new JLabel(""));
        fieldPane.add(new JLabel(String.valueOf(Messages.getString("topo.watertemp.name")) + ":"));
        JPanel pann = new JPanel(new BorderLayout());
        pann.add((Component)this.textfield[4], "Center");
        fieldPane.add(pann);
        fieldPane.add(new JLabel(String.valueOf(Messages.getString("topo.pipelength.name")) + ":"));
        fieldPane.add(this.textfield[5]);
        fieldPane.add(new JLabel(Messages.getString("ParametersPane.<html><b>-_Advanced_Parameters</b>")));
        fieldPane.add(new JLabel(""));
        fieldPane.add(new JLabel(String.valueOf(Messages.getString("topo.orifcoef.name")) + ":"));
        fieldPane.add(this.textfield[6]);
        fieldPane.add(new JLabel(String.valueOf(Messages.getString("topo.faucetcoef.name")) + ":"));
        fieldPane.add(this.textfield[7]);
        JPanel paneltop = new JPanel(new FlowLayout(2));
        ImageIcon icon0 = new ImageIcon(this.getClass().getResource("/neatwork/gui/images/Undo.png"));
        JButton button0 = new JButton(Messages.getString("ParametersPane.Reset"), icon0);
        button0.setActionCommand("reset");
        button0.addActionListener(this);
        paneltop.add(button0);
        ImageIcon icon = new ImageIcon(this.getClass().getResource("/neatwork/gui/images/Check.gif"));
        JButton button = new JButton(Messages.getString("ParametersPane.Apply"), icon);
        button.setActionCommand("apply");
        button.addActionListener(this);
        paneltop.add(button);
        this.setLayout(new BorderLayout(5, 5));
        this.add((Component)new JScrollPane(fieldPane), "Center");
        this.add((Component)paneltop, "North");
        this.loadValue();
    }

    private void loadValue() {
        this.textfield[0].setText(this.topo.getProperties().getProperty("topo.opentaps.value"));
        this.textfield[1].setText(this.topo.getProperties().getProperty("topo.servicequal.value"));
        this.textfield[2].setText(this.topo.getProperties().getProperty("topo.targetflow.value"));
        this.textfield[3].setText(this.topo.getProperties().getProperty("topo.limitbudget.value"));
        this.textfield[4].setText(this.topo.getProperties().getProperty("topo.watertemp.value"));
        this.textfield[5].setText(this.topo.getProperties().getProperty("topo.pipelength.value"));
        this.textfield[6].setText(this.topo.getProperties().getProperty("topo.orifcoef.value"));
        this.textfield[7].setText(this.topo.getProperties().getProperty("topo.faucetcoef.value"));
    }

    private void saveValue() {
        Properties prop = new Properties();
        try {
            prop.setProperty("topo.opentaps.value", "" + Double.parseDouble(this.textfield[0].getText()));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        try {
            prop.setProperty("topo.servicequal.value", "" + Double.parseDouble(this.textfield[1].getText()));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        try {
            prop.setProperty("topo.targetflow.value", "" + Double.parseDouble(this.textfield[2].getText()));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        try {
            prop.setProperty("topo.limitbudget.value", "" + Double.parseDouble(this.textfield[3].getText()));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        try {
            prop.setProperty("topo.watertemp.value", "" + Double.parseDouble(this.textfield[4].getText()));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        try {
            prop.setProperty("topo.pipelength.value", "" + Double.parseDouble(this.textfield[5].getText()));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        try {
            prop.setProperty("topo.orifcoef.value", "" + Double.parseDouble(this.textfield[6].getText()));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        try {
            prop.setProperty("topo.faucetcoef.value", "" + Double.parseDouble(this.textfield[7].getText()));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        this.topo.setProperties(prop);
    }

    private Properties getProperties(String data) {
        this.saveValue();
        return this.topo.getProperties();
    }

    public void update(Observable observable, Object param) {
        if (observable.getClass().isInstance(this.topo)) {
            switch ((Integer)param) {
                case 1: {
                    this.loadValue();
                }
            }
        }
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getActionCommand().equals("apply")) {
            this.saveValue();
        }
        if (e.getActionCommand().equals("reset")) {
            this.loadValue();
        }
    }
}

