/*
 * Decompiled with CFR 0.152.
 */
package neatwork.gui.makedesign;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import neatwork.Messages;
import neatwork.gui.makedesign.ChooseMaterialPane;
import neatwork.gui.makedesign.ConstraintsPane;
import neatwork.gui.makedesign.LoadFactorPane;
import neatwork.gui.makedesign.ParametersPane;
import neatwork.project.Database;
import neatwork.project.Topographie;

public class MakeDesignDialog
extends JDialog
implements ActionListener {
    private ChooseMaterialPane materialPane;
    private ParametersPane parametersPane;
    private LoadFactorPane loadFactorPane;
    private ConstraintsPane constraintsPane;
    private Topographie topographie;
    private double hsource;
    private boolean canceled = true;

    public MakeDesignDialog(JFrame frame, Database database, Topographie topographie) {
        super(frame, Messages.getString("MakeDesignDialog.Make_Design"), true);
        ((Component)this).setSize(600, 400);
        Dimension d = Toolkit.getDefaultToolkit().getScreenSize();
        ((Component)this).setLocation((d.width - this.getSize().width) / 2, (d.height - this.getSize().height) / 2);
        this.setDefaultCloseOperation(2);
        this.topographie = topographie;
        this.hsource = topographie.setHauteurSource(0.0);
        topographie.makeExpandedTopo();
        this.materialPane = new ChooseMaterialPane(database, topographie);
        this.parametersPane = new ParametersPane(topographie);
        this.loadFactorPane = new LoadFactorPane(topographie);
        this.constraintsPane = new ConstraintsPane(topographie, database);
        Container container = this.getContentPane();
        JTabbedPane tabbedPane = new JTabbedPane();
        tabbedPane.addTab(Messages.getString("MakeDesignDialog.Hardware"), this.materialPane);
        tabbedPane.addTab(Messages.getString("MakeDesignDialog.Parameters"), this.parametersPane);
        tabbedPane.addTab(Messages.getString("MakeDesignDialog.Constraints"), this.constraintsPane);
        tabbedPane.addTab(Messages.getString("MakeDesignDialog.Load_Factors"), this.loadFactorPane);
        container.setLayout(new BorderLayout(5, 5));
        container.add((Component)tabbedPane, "Center");
        JPanel panelBottom = new JPanel(new FlowLayout(2));
        panelBottom.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        JButton button = new JButton(Messages.getString("MakeDesignDialog.Run_Make_Design"));
        button.setActionCommand(Messages.getString("MakeDesignDialog.Make_Design"));
        button.addActionListener(this);
        button.setMnemonic('M');
        JButton button0 = new JButton(Messages.getString("MakeDesignDialog.Abort"));
        button0.setActionCommand(Messages.getString("MakeDesignDialog.Close"));
        button0.addActionListener(this);
        button0.setMnemonic('A');
        panelBottom.add(button0);
        panelBottom.add(button);
        container.add((Component)panelBottom, "South");
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getActionCommand().equals(Messages.getString("MakeDesignDialog.Close"))) {
            this.dispose();
        }
        if (e.getActionCommand().equals(Messages.getString("MakeDesignDialog.Make_Design"))) {
            if (this.getDiametersContent().equals("")) {
                JOptionPane.showMessageDialog(this, Messages.getString("MakeDesignDialog.You_must_choose_at_least_one_diameter"));
            } else {
                this.canceled = false;
                this.dispose();
            }
        }
    }

    public boolean getCanceled() {
        return this.canceled;
    }

    public Topographie getTopographie() {
        return this.topographie;
    }

    public String getOrificesContent() {
        return this.materialPane.getOrificesContent();
    }

    public String getDiametersContent() {
        return this.materialPane.getDiametersContent();
    }

    public Hashtable getLoadFactors() {
        return this.loadFactorPane.getLoadFactor();
    }

    public Vector getConstraints() {
        return this.constraintsPane.getContraints();
    }

    public double getHSource() {
        return this.hsource;
    }
}

