/*
 * Decompiled with CFR 0.152.
 */
package neatwork.gui.makedesign;

import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;
import neatwork.Messages;
import neatwork.gui.fancytable.FancyTableModel;
import neatwork.project.Node;
import neatwork.project.Topographie;

public class LoadFactorTableModel
extends FancyTableModel {
    private String[] myHeader = new String[]{Messages.getString("LoadFactorTableModel.Begin"), Messages.getString("LoadFactorTableModel.End_2"), Messages.getString("LoadFactorTableModel.__#_of_faucets"), Messages.getString("LoadFactorTableModel.Theoric_load_factor"), Messages.getString("LoadFactorTableModel.Modified_load_factor")};
    private int[] myWhidthHeader = new int[]{50, 50, 100, 120, 120};
    private Topographie topo;
    private Hashtable loadTaps;
    private Hashtable loadFactors;
    private Hashtable modifLoadFactor;
    private double targetflow;
    private double servicequal;
    private double opentaps;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;

    public LoadFactorTableModel(Topographie topographie) {
        this.topo = topographie;
        this.header = this.myHeader;
        this.widthHeader = this.myWhidthHeader;
        this.targetflow = -99.0;
        this.opentaps = -99.0;
        this.servicequal = -99.0;
        this.updateData();
    }

    public void updateData() {
        boolean changed = this.propertiesHasChanged();
        if (changed) {
            this.loadTaps = this.topo.getLoadTaps();
            this.loadFactors = this.topo.getLoadFactor(this.loadTaps);
            this.modifLoadFactor = new Hashtable(this.loadFactors);
        }
        this.data = new Vector();
        Iterator iter = this.topo.getExpandedNodeIterator();
        while (iter.hasNext()) {
            Node node = (Node)iter.next();
            if (node.getType() == 0) continue;
            Vector<Object> line = new Vector<Object>();
            line.add(this.topo.getExpandedPredPipe(node).getBegin());
            line.add(node.getName());
            line.add(new Integer(this.loadTaps.get(node.getName()).toString()));
            line.add(new Double(this.loadFactors.get(node.getName()).toString()));
            line.add(new Double(this.modifLoadFactor.get(node.getName()).toString()));
            this.data.add(line);
        }
        this.fireTableDataChanged();
    }

    public Class getColumnClass(int col) {
        switch (col) {
            case 0: {
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = class$0 = Class.forName("java.lang.String");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                return clazz;
            }
            case 1: {
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = class$0 = Class.forName("java.lang.String");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                return clazz;
            }
            case 2: {
                Class<?> clazz = class$1;
                if (clazz == null) {
                    try {
                        clazz = class$1 = Class.forName("java.lang.Integer");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                return clazz;
            }
            case 3: {
                Class<?> clazz = class$2;
                if (clazz == null) {
                    try {
                        clazz = class$2 = Class.forName("java.lang.Double");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                return clazz;
            }
            case 4: {
                Class<?> clazz = class$2;
                if (clazz == null) {
                    try {
                        clazz = class$2 = Class.forName("java.lang.Double");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                return clazz;
            }
        }
        Class<?> clazz = class$3;
        if (clazz == null) {
            try {
                clazz = class$3 = Class.forName("java.lang.Object");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return clazz;
    }

    protected Vector getNewVector() {
        Vector<Object> line = new Vector<Object>();
        line.add("");
        line.add("");
        line.add(new Integer(0));
        line.add(new Double(0.0));
        line.add(new Double(0.0));
        line.add("");
        return line;
    }

    public boolean isCellEditable(int row, int col) {
        return col == 4;
    }

    public void setValueAt(Object object, int row, int col) {
        super.setValueAt(object, row, col);
        if (col == 4) {
            this.modifLoadFactor.put(this.getValueAt(row, 1), object);
        }
    }

    public void reset() {
        this.modifLoadFactor = new Hashtable(this.loadFactors);
    }

    private boolean propertiesHasChanged() {
        double targetflow0 = Double.parseDouble(this.topo.getProperties().getProperty("topo.targetflow.value"));
        double opentaps0 = Double.parseDouble(this.topo.getProperties().getProperty("topo.opentaps.value"));
        double qualite0 = Double.parseDouble(this.topo.getProperties().getProperty("topo.servicequal.value"));
        boolean changed = this.targetflow != targetflow0 || this.opentaps != opentaps0 || qualite0 != this.servicequal;
        this.targetflow = targetflow0;
        this.opentaps = opentaps0;
        this.servicequal = qualite0;
        return changed;
    }

    public Hashtable getLoadFactor() {
        return this.modifLoadFactor;
    }
}

