/*
 * Decompiled with CFR 0.152.
 */
package neatwork.gui.makedesign;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.Hashtable;
import java.util.Observable;
import java.util.Observer;
import javax.swing.Action;
import javax.swing.ImageIcon;
import javax.swing.JPanel;
import neatwork.Messages;
import neatwork.gui.fancytable.FancyTable;
import neatwork.gui.fancytable.FancyTablePanel;
import neatwork.gui.makedesign.LoadFactorTableModel;
import neatwork.project.Topographie;
import neatwork.utils.NeatworkAction;

public class LoadFactorPane
extends JPanel
implements Observer {
    private Topographie topo;
    private LoadFactorTableModel tableModel;
    private FancyTable table;

    public LoadFactorPane(Topographie topo) {
        this.topo = topo;
        topo.addObserver(this);
        this.tableModel = new LoadFactorTableModel(topo);
        this.table = new FancyTable(this.tableModel);
        Action[] actions = new Action[1];
        ImageIcon icon = new ImageIcon(this.getClass().getResource("/neatwork/gui/images/Undo.png"));
        actions[0] = new NeatworkAction(Messages.getString("LoadFactorPane.Apply"), icon, Messages.getString("LoadFactorPane.Reset"), 'R'){

            public void actionPerformed(ActionEvent e) {
                LoadFactorPane.this.tableModel.reset();
                LoadFactorPane.this.updateTable();
            }
        };
        this.setLayout(new BorderLayout());
        this.add((Component)new FancyTablePanel(Messages.getString("LoadFactorPane.Load_factors"), actions, this.table, true), "Center");
        this.updateTable();
    }

    public void updateTable() {
        this.table.updateData();
    }

    public Hashtable getLoadFactor() {
        return this.tableModel.getLoadFactor();
    }

    public void update(Observable observable, Object param) {
        if (observable.getClass().isInstance(this.topo)) {
            switch ((Integer)param) {
                case 1: {
                    this.updateTable();
                }
            }
        }
    }
}

