/*
 * Decompiled with CFR 0.152.
 */
package neatwork.gui.makedesign;

import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import neatwork.Messages;
import neatwork.gui.design.ComboDatabase;
import neatwork.gui.makedesign.ConstraintsListModel;
import neatwork.project.Database;
import neatwork.project.Pipe;
import neatwork.project.Topographie;
import neatwork.utils.DoubleInputVerifier;

public class ConstraintsPane
extends JPanel
implements ActionListener {
    private JComboBox comboPipe;
    private JComboBox comboConstraint;
    private JButton buttonAddConstraint;
    private JButton buttonDeleteConstraint;
    private JList listConstraint;
    private JTextField textFieldGreaterThan = new JTextField(10);
    private JTextField textFieldLowerThan = new JTextField(10);
    private ComboDatabase comboDiameter0;
    private ComboDatabase comboDiameter1;
    private ComboDatabase comboDiameter2;
    private JTextField textFieldLength1 = new JTextField(10);
    private JLabel label1 = new JLabel();
    private CardLayout cardLayout;
    private JPanel ypanel;
    private Vector constraints = new Vector();

    public ConstraintsPane(Topographie topo, Database database) {
        DoubleInputVerifier dblInput = new DoubleInputVerifier();
        this.textFieldGreaterThan.setInputVerifier(dblInput);
        this.textFieldLength1.setInputVerifier(dblInput);
        this.textFieldLowerThan.setInputVerifier(dblInput);
        Vector pipelist = new Vector();
        Iterator iter = topo.getExpandedPipeIterator();
        while (iter.hasNext()) {
            pipelist.add(iter.next());
        }
        this.comboPipe = new JComboBox(pipelist);
        Vector<String> typeConstraint = new Vector<String>();
        typeConstraint.add(Messages.getString("ConstraintsPane.pipe(s)_must_be_greater_than"));
        typeConstraint.add(Messages.getString("ConstraintsPane.pipe(s)_must_be_lower_than"));
        typeConstraint.add(Messages.getString("ConstraintsPane.pipe(s)_must_be_equal_to"));
        typeConstraint.add(Messages.getString("ConstraintsPane.the_two_pipes_must_be"));
        this.comboConstraint = new JComboBox(typeConstraint);
        this.comboDiameter0 = new ComboDatabase(database);
        this.comboDiameter1 = new ComboDatabase(database);
        this.comboDiameter2 = new ComboDatabase(database);
        JPanel paneltop = new JPanel(new BorderLayout(5, 5));
        paneltop.setBorder(BorderFactory.createEtchedBorder());
        JPanel zpanel = new JPanel(new FlowLayout(0));
        zpanel.add(new JLabel(Messages.getString("ConstraintsPane.Constraint_on")));
        zpanel.add(this.comboPipe);
        zpanel.add(new JLabel(","));
        zpanel.add(this.comboConstraint);
        paneltop.add((Component)zpanel, "North");
        this.cardLayout = new CardLayout();
        this.ypanel = new JPanel(this.cardLayout);
        JPanel p0 = new JPanel(new FlowLayout(0));
        p0.add(new JLabel(Messages.getString("ConstraintsPane.diameter")));
        p0.add(this.textFieldGreaterThan);
        this.ypanel.add((Component)p0, "0");
        JPanel p1 = new JPanel(new FlowLayout(0));
        p1.add(new JLabel(Messages.getString("ConstraintsPane.diameter")));
        p1.add(this.textFieldLowerThan);
        this.ypanel.add((Component)p1, "1");
        JPanel p2 = new JPanel(new FlowLayout(0));
        p2.add(new JLabel(Messages.getString("ConstraintsPane.diameter")));
        p2.add(this.comboDiameter0);
        this.ypanel.add((Component)p2, "2");
        JPanel p3 = new JPanel(new GridLayout(2, 1));
        JPanel p31 = new JPanel(new FlowLayout(0));
        p31.add(new JLabel(Messages.getString("ConstraintsPane.diameter_1")));
        p31.add(this.comboDiameter1);
        p31.add(new JLabel(Messages.getString("ConstraintsPane.length_1")));
        p31.add(this.textFieldLength1);
        p3.add(p31);
        JPanel p32 = new JPanel(new FlowLayout(0));
        p32.add(new JLabel(Messages.getString("ConstraintsPane.diameter_2")));
        p32.add(this.comboDiameter2);
        p32.add(new JLabel(Messages.getString("ConstraintsPane.length_2")));
        p32.add(new JLabel());
        p3.add(p32);
        this.ypanel.add((Component)p3, "3");
        paneltop.add((Component)this.ypanel, "Center");
        JPanel wpanel = new JPanel(new FlowLayout(2));
        this.buttonAddConstraint = new JButton(Messages.getString("ConstraintsPane.Add_new_constraint"));
        this.buttonAddConstraint.addActionListener(this);
        this.buttonDeleteConstraint = new JButton(Messages.getString("ConstraintsPane.Delete"));
        this.buttonDeleteConstraint.addActionListener(this);
        wpanel.add(this.buttonAddConstraint);
        wpanel.add(this.buttonDeleteConstraint);
        JPanel xpanel = new JPanel(new BorderLayout());
        xpanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        xpanel.add((Component)wpanel, "North");
        this.listConstraint = new JList(new ConstraintsListModel(this.constraints));
        xpanel.add((Component)new JScrollPane(this.listConstraint), "Center");
        this.setLayout(new BorderLayout());
        this.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
        this.add((Component)paneltop, "North");
        this.add((Component)xpanel, "Center");
        this.cardLayout.show(this.ypanel, "" + this.comboConstraint.getSelectedIndex());
        this.comboConstraint.addActionListener(this);
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getSource().equals(this.comboConstraint)) {
            this.cardLayout.show(this.ypanel, "" + this.comboConstraint.getSelectedIndex());
        }
        if (e.getSource().equals(this.buttonDeleteConstraint) && this.listConstraint.getSelectedIndex() > -1) {
            this.constraints.remove(this.listConstraint.getSelectedIndex());
            ((ConstraintsListModel)this.listConstraint.getModel()).removeConstraints();
        }
        if (e.getSource().equals(this.buttonAddConstraint)) {
            Vector<Object> line = new Vector<Object>();
            line.add(new Integer(this.comboConstraint.getSelectedIndex()));
            line.add(new Pipe(this.comboPipe.getSelectedItem().toString()));
            switch (this.comboConstraint.getSelectedIndex()) {
                case 0: {
                    line.add(this.textFieldGreaterThan.getText());
                    break;
                }
                case 1: {
                    line.add(this.textFieldLowerThan.getText());
                    break;
                }
                case 2: {
                    line.add(this.comboDiameter0.getSelectedDiameter());
                    break;
                }
                case 3: {
                    line.add(this.comboDiameter1.getSelectedDiameter());
                    line.add(this.textFieldLength1.getText());
                    line.add(this.comboDiameter2.getSelectedDiameter());
                }
            }
            this.constraints.add(line);
            ((ConstraintsListModel)this.listConstraint.getModel()).addConstraints();
        }
    }

    public Vector getContraints() {
        return this.constraints;
    }
}

