/*
 * Decompiled with CFR 0.152.
 */
package neatwork.gui.makedesign;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import neatwork.Messages;
import neatwork.gui.fancytable.FancyTable;
import neatwork.gui.fancytable.FancyTablePanel;
import neatwork.gui.makedesign.ChooseDiameterTableModel;
import neatwork.gui.makedesign.ChooseOrificeTableModel;
import neatwork.project.Database;
import neatwork.project.Topographie;

public class ChooseMaterialPane
extends JPanel {
    private ChooseDiameterTableModel diamTableModel;
    private ChooseOrificeTableModel orifTableModel;
    private FancyTable diamTable;
    private FancyTable orifTable;
    private Topographie topo;

    public ChooseMaterialPane(Database database, Topographie topographie) {
        this.topo = topographie;
        JSplitPane splitPane = new JSplitPane();
        splitPane.setOrientation(1);
        splitPane.setDividerLocation(300);
        splitPane.setResizeWeight(0.8);
        splitPane.setOneTouchExpandable(true);
        this.diamTableModel = new ChooseDiameterTableModel(database);
        this.diamTable = new FancyTable(this.diamTableModel);
        Action[] actions = new Action[2];
        Icon icon = null;
        actions[1] = new AbstractAction(Messages.getString("ChooseMaterialPane.None"), icon){

            public void actionPerformed(ActionEvent e) {
                ChooseMaterialPane.this.diamTableModel.setall(ChooseMaterialPane.this.diamTable.getSelectedRows(), false);
            }
        };
        actions[1].putValue("ShortDescription", Messages.getString("ChooseMaterialPane.Select_none"));
        icon = null;
        actions[0] = new AbstractAction(Messages.getString("ChooseMaterialPane.All"), icon){

            public void actionPerformed(ActionEvent e) {
                ChooseMaterialPane.this.diamTableModel.setall(ChooseMaterialPane.this.diamTable.getSelectedRows(), true);
            }
        };
        actions[0].putValue("ShortDescription", Messages.getString("ChooseMaterialPane.Select_all"));
        FancyTablePanel diamPanel = new FancyTablePanel(Messages.getString("ChooseMaterialPane.Diameters"), actions, this.diamTable, false);
        splitPane.setTopComponent(diamPanel);
        this.orifTableModel = new ChooseOrificeTableModel(database);
        this.orifTable = new FancyTable(this.orifTableModel);
        actions = new Action[2];
        icon = null;
        actions[1] = new AbstractAction(Messages.getString("ChooseMaterialPane.None"), icon){

            public void actionPerformed(ActionEvent e) {
                ChooseMaterialPane.this.orifTableModel.setall(ChooseMaterialPane.this.orifTable.getSelectedRows(), false);
            }
        };
        actions[1].putValue("ShortDescription", Messages.getString("ChooseMaterialPane.Select_none"));
        icon = null;
        actions[0] = new AbstractAction(Messages.getString("ChooseMaterialPane.All"), icon){

            public void actionPerformed(ActionEvent e) {
                ChooseMaterialPane.this.orifTableModel.setall(ChooseMaterialPane.this.orifTable.getSelectedRows(), true);
            }
        };
        actions[0].putValue("ShortDescription", Messages.getString("ChooseMaterialPane.Select_all"));
        FancyTablePanel orifPanel = new FancyTablePanel(Messages.getString("ChooseMaterialPane.Orifices"), actions, this.orifTable, false);
        splitPane.setBottomComponent(orifPanel);
        this.setLayout(new BorderLayout());
        this.add((Component)splitPane, "Center");
    }

    public String getDiametersContent() {
        return this.diamTableModel.getContent();
    }

    public String getOrificesContent() {
        return this.orifTableModel.getContent();
    }
}

