/*
 * Decompiled with CFR 0.152.
 */
package neatwork.gui.fancytable;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.ToolTipManager;

public class FancyTablePanel
extends JPanel {
    public FancyTablePanel(String title, Action[] actions, JTable jTable) {
        this(title, actions, jTable, false);
    }

    public FancyTablePanel(String title, Action[] actions, JTable jTable, boolean wholeWidth) {
        this.setLayout(new BorderLayout(5, 5));
        this.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        if (!title.equals("")) {
            this.add((Component)new JLabel("<html>" + title), "North");
        }
        JPanel jPanelTop = new JPanel(new FlowLayout(0, 3, 3));
        int nbActions = actions == null ? 0 : actions.length;
        int i = 0;
        while (i < nbActions) {
            if (actions[i] == null) {
                jPanelTop.add(new JLabel(" "));
            } else {
                JButton jbutton = new JButton(actions[i]);
                jPanelTop.add(jbutton);
                if (jbutton.getIcon() != null) {
                    jbutton.setText("");
                }
                jbutton.setBorder(BorderFactory.createEtchedBorder());
            }
            ++i;
        }
        ToolTipManager.sharedInstance().unregisterComponent(jTable);
        ToolTipManager.sharedInstance().unregisterComponent(jTable.getTableHeader());
        JPanel jPanel2 = new JPanel(new BorderLayout(2, 2));
        jPanel2.add((Component)jPanelTop, "North");
        JScrollPane jScrollPane = new JScrollPane(jTable);
        jScrollPane.setVerticalScrollBarPolicy(20);
        jScrollPane.setHorizontalScrollBarPolicy(30);
        jScrollPane.setMaximumSize(jTable.getPreferredScrollableViewportSize());
        if (wholeWidth) {
            jTable.setAutoResizeMode(2);
            jPanel2.add((Component)jScrollPane, "Center");
        } else {
            jTable.setAutoResizeMode(0);
            Box box = Box.createHorizontalBox();
            box.add(jScrollPane);
            box.add(Box.createHorizontalGlue());
            jPanel2.add((Component)box, "Center");
        }
        this.add((Component)jPanel2, "Center");
    }
}

