/*
 * Decompiled with CFR 0.152.
 */
package neatwork.gui.fancytable;

import java.util.Arrays;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.table.AbstractTableModel;
import neatwork.utils.Tools;

public abstract class FancyTableModel
extends AbstractTableModel {
    protected Vector data = new Vector();
    protected String[] header = new String[0];
    protected int[] widthHeader = new int[0];
    protected int row;

    public abstract void updateData();

    public String getColumnName(int i) {
        return this.header[i];
    }

    public void setValueAt(Object object, int row, int col) {
        ((Vector)this.data.get(row)).set(col, object);
    }

    public boolean isCellEditable(int row, int col) {
        return true;
    }

    public abstract Class getColumnClass(int var1);

    public Object getValueAt(int row, int col) {
        return ((Vector)this.data.get(row)).get(col);
    }

    public int getColumnCount() {
        return this.header.length;
    }

    public int getRowCount() {
        return this.data.size();
    }

    public String getContent() {
        return Tools.getTxt(this.data);
    }

    public void addNewLine() {
        this.addNewLine(this.data.size());
    }

    public void addNewLine(int i) {
        if (i < 1 || i > this.data.size()) {
            i = this.data.size();
        }
        this.data.insertElementAt(this.getNewVector(), i);
        this.row = i;
        this.fireTableDataChanged();
    }

    public void deleteLines(int[] rows) {
        Arrays.sort(rows);
        int i = rows.length - 1;
        while (i > -1) {
            this.data.remove(rows[i]);
            this.row = rows[i];
            --i;
        }
        this.fireTableDataChanged();
    }

    public int getRow() {
        return this.row;
    }

    protected abstract Vector getNewVector();

    public int[] getWidthHeader() {
        return this.widthHeader;
    }

    public String getCopy() {
        String copy = "";
        int i = 0;
        while (i < this.getRowCount()) {
            int j = 0;
            while (j < this.getColumnCount()) {
                copy = String.valueOf(copy) + ((Vector)this.data.get(i)).get(j).toString();
                if (j < this.getColumnCount() - 1) {
                    copy = String.valueOf(copy) + "\t";
                }
                ++j;
            }
            if (i < this.getRowCount()) {
                copy = String.valueOf(copy) + "\n";
            }
            ++i;
        }
        return copy;
    }

    public boolean setPaste(String clip) {
        StringTokenizer st1 = new StringTokenizer(clip, "\n");
        boolean isOk = true;
        while (st1.hasMoreTokens() && isOk) {
            StringTokenizer st2 = new StringTokenizer(st1.nextToken(), "\t");
            boolean bl = isOk = st2.countTokens() == this.getColumnCount();
        }
        if (isOk) {
            this.data.clear();
            Vector nline = this.getNewVector();
            st1 = new StringTokenizer(clip, "\n");
            int i = 0;
            while (st1.hasMoreTokens()) {
                StringTokenizer st2 = new StringTokenizer(st1.nextToken(), "\t");
                Vector<Object> line = new Vector<Object>();
                int j = 0;
                while (st2.hasMoreTokens()) {
                    String cell = st2.nextToken();
                    if (nline.get(j) instanceof String) {
                        line.add(cell);
                    } else if (nline.get(j) instanceof Double) {
                        line.add(new Double(cell));
                    } else if (nline.get(j) instanceof Integer) {
                        line.add(new Integer(cell));
                    }
                    ++j;
                }
                this.data.add(line);
                ++i;
            }
            this.fireTableDataChanged();
        }
        return isOk;
    }
}

