/*
 * Decompiled with CFR 0.152.
 */
package neatwork.gui.fancytable;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.ActionEvent;
import java.io.IOException;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ImageIcon;
import javax.swing.JOptionPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import neatwork.Messages;
import neatwork.gui.fancytable.FancyTableCellRenderer;
import neatwork.gui.fancytable.FancyTableModel;
import neatwork.gui.fancytable.TableSorter;

public class FancyTable
extends JTable {
    private FancyTableModel fancyTableModel;
    public Action insertRowAction;
    public Action deleteRowAction;
    public Action updateAction;
    public Action copyAction;
    public Action pasteAction;
    private Color colorChanged;
    private Color colorUndo = this.getBackground();
    private boolean updateColor;
    String pathImage = "/neatwork/gui/images/";
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public FancyTable(FancyTableModel fancyTableModel) {
        this(fancyTableModel, false);
    }

    public FancyTable(FancyTableModel fancyTableModel, boolean updateColor) {
        this.colorChanged = new Color(200, 200, 200);
        this.updateColor = updateColor;
        TableSorter sorter = new TableSorter(fancyTableModel);
        this.setModel(sorter);
        this.fancyTableModel = fancyTableModel;
        ImageIcon icon = new ImageIcon(this.getClass().getResource(String.valueOf(this.pathImage) + "NewRow.png"));
        this.insertRowAction = new AbstractAction("+", icon){

            public void actionPerformed(ActionEvent e) {
                FancyTable.this.addNewRow();
            }
        };
        icon = new ImageIcon(this.getClass().getResource(String.valueOf(this.pathImage) + "DeleteRow.png"));
        this.deleteRowAction = new AbstractAction("-", icon){

            public void actionPerformed(ActionEvent e) {
                FancyTable.this.deleteRows();
            }
        };
        icon = new ImageIcon(this.getClass().getResource(String.valueOf(this.pathImage) + "Undo.png"));
        this.updateAction = new AbstractAction("u", icon){

            public void actionPerformed(ActionEvent e) {
                FancyTable.this.updateData();
            }
        };
        icon = new ImageIcon(this.getClass().getResource(String.valueOf(this.pathImage) + "Copy.png"));
        this.copyAction = new AbstractAction("c", icon){

            public void actionPerformed(ActionEvent e) {
                StringSelection stsel = new StringSelection(FancyTable.this.fancyTableModel.getCopy());
                Clipboard system = Toolkit.getDefaultToolkit().getSystemClipboard();
                system.setContents(stsel, stsel);
            }
        };
        this.copyAction.putValue("ShortDescription", Messages.getString("FancyTable.Copy"));
        icon = new ImageIcon(this.getClass().getResource(String.valueOf(this.pathImage) + "Paste.png"));
        this.pasteAction = new AbstractAction("v", icon){

            public void actionPerformed(ActionEvent e) {
                Clipboard system = Toolkit.getDefaultToolkit().getSystemClipboard();
                try {
                    String paste = system.getContents(this).getTransferData(DataFlavor.stringFlavor).toString();
                    if (!FancyTable.this.fancyTableModel.setPaste(paste)) {
                        JOptionPane.showMessageDialog(null, Messages.getString("FancyTable.Clipboard_is_not_well_formated"), Messages.getString("FancyTable.Format_error"), 0);
                    } else if (FancyTable.this.updateColor) {
                        FancyTable.this.setBackground(FancyTable.this.colorChanged);
                    }
                }
                catch (IOException iOException) {
                }
                catch (UnsupportedFlavorException unsupportedFlavorException) {
                    // empty catch block
                }
            }
        };
        this.pasteAction.putValue("ShortDescription", Messages.getString("FancyTable.Paste"));
        this.autoFit();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("java.lang.Double");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.setDefaultRenderer(clazz, new FancyTableCellRenderer());
        Class<?> clazz2 = class$1;
        if (clazz2 == null) {
            try {
                clazz2 = class$1 = Class.forName("java.lang.String");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.setDefaultRenderer(clazz2, new FancyTableCellRenderer());
    }

    public void autoFit() {
        if (this.fancyTableModel.getWidthHeader().length > 0) {
            int width = 0;
            int i = 0;
            while (i < this.fancyTableModel.getWidthHeader().length) {
                this.getColumnModel().getColumn(i).setPreferredWidth(this.fancyTableModel.getWidthHeader()[i]);
                width += this.fancyTableModel.getWidthHeader()[i];
                ++i;
            }
            this.setPreferredScrollableViewportSize(new Dimension(width + 15, 1000));
        }
    }

    public void addNewRow() {
        this.fancyTableModel.addNewLine(this.getSelectedRow() + 1);
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                FancyTable.this.scrollRectToVisible(FancyTable.this.getCellRect(FancyTable.this.fancyTableModel.getRow(), 1, true));
            }
        });
        this.copyAction.setEnabled(false);
        if (this.updateColor) {
            this.setBackground(this.colorChanged);
        }
    }

    public void deleteRows() {
        this.fancyTableModel.deleteLines(this.getSelectedRows());
        this.copyAction.setEnabled(false);
        if (this.updateColor) {
            this.setBackground(this.colorChanged);
        }
    }

    public void updateData() {
        if (this.updateColor) {
            this.setBackground(this.colorUndo);
        }
        this.fancyTableModel.updateData();
        this.copyAction.setEnabled(true);
    }

    public void editingStopped(ChangeEvent e) {
        if (this.updateColor) {
            this.setBackground(this.colorChanged);
        }
        this.copyAction.setEnabled(false);
        super.editingStopped(e);
    }
}

