/*
 * Decompiled with CFR 0.152.
 */
package neatwork.gui.design;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.util.Observable;
import java.util.Observer;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.event.ListDataEvent;
import neatwork.Messages;
import neatwork.gui.design.ComboDatabase;
import neatwork.gui.design.DesignNodeModel;
import neatwork.gui.design.DesignPipeModel;
import neatwork.gui.design.DiametersEditor;
import neatwork.gui.design.DiametersRender;
import neatwork.gui.fancytable.FancyTable;
import neatwork.gui.fancytable.FancyTableCellRenderer;
import neatwork.gui.fancytable.FancyTablePanel;
import neatwork.project.Database;
import neatwork.project.Design;
import neatwork.utils.NeatworkAction;
import neatwork.utils.Tools;

public class DesignTablePane
extends JPanel
implements Observer {
    private Design design;
    private DesignNodeModel nodesTableModel;
    private DesignPipeModel pipesTableModel;
    private FancyTable jTablePipe;
    private FancyTable jTableNode;
    private JSplitPane jSplitPane;
    private JLabel costLabel;

    public DesignTablePane(Design design, Database database) {
        this.design = design;
        design.addObserver(this);
        this.nodesTableModel = new DesignNodeModel(design);
        this.pipesTableModel = new DesignPipeModel(design, database, this.jTablePipe);
        this.jTablePipe = new FancyTable(this.pipesTableModel, true);
        this.jTableNode = new FancyTable(this.nodesTableModel, true);
        ComboDatabase combo = new ComboDatabase(database){

            public void contentsChanged(ListDataEvent e) {
                this.selectedItemReminder = null;
                super.contentsChanged(e);
            }
        };
        LblOrifice lblOrifice = new LblOrifice();
        this.jTableNode.getColumnModel().getColumn(4).setCellRenderer(lblOrifice);
        this.jTableNode.getColumnModel().getColumn(5).setCellRenderer(lblOrifice);
        Dimension d = combo.getPreferredSize();
        combo.setPopupWidth(200);
        combo.setBackground(this.jTablePipe.getBackground());
        combo.setFont(this.jTablePipe.getFont());
        combo.setForeground(this.jTablePipe.getForeground());
        DiametersEditor editor = new DiametersEditor(combo, design);
        this.jTablePipe.getColumnModel().getColumn(4).setCellEditor(editor);
        this.jTablePipe.getColumnModel().getColumn(6).setCellEditor(editor);
        DiametersRender renderer = new DiametersRender(design);
        renderer.setForeground(this.jTablePipe.getForeground());
        renderer.setFont(this.jTablePipe.getFont());
        renderer.setHorizontalAlignment(4);
        this.jTablePipe.getColumnModel().getColumn(4).setCellRenderer(renderer);
        this.jTablePipe.getColumnModel().getColumn(6).setCellRenderer(renderer);
        this.setLayout(new BorderLayout());
        this.jSplitPane = new JSplitPane();
        Action[] actions = new Action[8];
        actions[0] = this.jTableNode.insertRowAction;
        actions[0].putValue("ShortDescription", Messages.getString("DesignTablePane.Insert_a_new_node"));
        actions[1] = this.jTableNode.deleteRowAction;
        actions[1].putValue("ShortDescription", Messages.getString("DesignTablePane.Delete_selected_node(s)"));
        actions[2] = null;
        actions[3] = this.jTableNode.copyAction;
        actions[4] = this.jTableNode.pasteAction;
        actions[5] = null;
        actions[6] = this.jTableNode.updateAction;
        actions[6].putValue("ShortDescription", Messages.getString("DesignTablePane.Undo_modifications"));
        ImageIcon icon = new ImageIcon(this.getClass().getResource("/neatwork/gui/images/Check.gif"));
        actions[7] = new NeatworkAction(Messages.getString("DesignTablePane.Apply"), icon, Messages.getString("DesignTablePane.Apply_modifications"), 'A'){

            public void actionPerformed(ActionEvent e) {
                DesignTablePane.this.apply();
            }
        };
        this.jSplitPane.setTopComponent(new FancyTablePanel(Messages.getString("DesignTablePane.Node_list"), actions, this.jTableNode));
        actions = new Action[8];
        actions[0] = this.jTablePipe.insertRowAction;
        actions[0].putValue("ShortDescription", Messages.getString("DesignTablePane.Insert_a_new_pipe"));
        actions[1] = this.jTablePipe.deleteRowAction;
        actions[1].putValue("ShortDescription", Messages.getString("DesignTablePane.Delete_selected_pipe(s)"));
        actions[2] = null;
        actions[3] = this.jTablePipe.copyAction;
        actions[4] = this.jTablePipe.pasteAction;
        actions[5] = null;
        actions[6] = this.jTablePipe.updateAction;
        actions[6].putValue("ShortDescription", Messages.getString("DesignTablePane.Undo_modifications"));
        icon = new ImageIcon(this.getClass().getResource("/neatwork/gui/images/Check.gif"));
        actions[7] = new NeatworkAction(Messages.getString("DesignTablePane.Apply"), icon, Messages.getString("DesignTablePane.Apply_modifications"), 'A'){

            public void actionPerformed(ActionEvent e) {
                DesignTablePane.this.apply();
            }
        };
        this.jSplitPane.setBottomComponent(new FancyTablePanel(Messages.getString("DesignTablePane.Arc_list"), actions, this.jTablePipe));
        this.jSplitPane.setOrientation(0);
        this.jSplitPane.setContinuousLayout(false);
        this.jSplitPane.setResizeWeight(0.5);
        this.jSplitPane.setOneTouchExpandable(true);
        this.jSplitPane.setDividerLocation(200);
        this.add((Component)this.jSplitPane, "Center");
        this.costLabel = new JLabel();
        this.costLabel.setBorder(BorderFactory.createEmptyBorder(5, 20, 10, 5));
        this.add((Component)this.costLabel, "South");
        this.updateNodesTable();
        this.updatePipesTable();
        this.updateCostLabel();
    }

    private void updateNodesTable() {
        this.jTableNode.updateData();
    }

    private void updatePipesTable() {
        this.jTablePipe.updateData();
    }

    private void updateCostLabel() {
        this.costLabel.setText(String.valueOf(Messages.getString("DesignTablePane.Design_total_cost")) + Tools.doubleFormat("#,##0", this.design.getCost()));
    }

    private void apply() {
        this.design.freeInfoModif();
        String content = String.valueOf(this.design.getPropertiesContent()) + this.nodesTableModel.getContent() + this.pipesTableModel.getContent();
        this.design.setContent(content);
        if (!this.design.getInfoModif().equals("")) {
            JOptionPane.showMessageDialog(null, Messages.getString("DesignTablePane.error_in_your_project"));
        }
    }

    public void update(Observable observable, Object param) {
        if (observable.getClass().isInstance(this.design)) {
            switch ((Integer)param) {
                case 0: {
                    this.updateNodesTable();
                    this.updatePipesTable();
                    this.updateCostLabel();
                }
            }
        }
    }

    class LblOrifice
    extends FancyTableCellRenderer {
        LblOrifice() {
        }

        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            String t = Tools.doubleFormat("0.##########", Double.parseDouble(value.toString()));
            if (t.equals("10000")) {
                t = "-";
            }
            return super.getTableCellRendererComponent(table, t, isSelected, hasFocus, row, column);
        }
    }
}

