/*
 * Decompiled with CFR 0.152.
 */
package neatwork.gui.design;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.JComboBox;
import neatwork.Messages;
import neatwork.gui.fancytable.FancyTable;
import neatwork.gui.fancytable.FancyTableModel;
import neatwork.project.Database;
import neatwork.project.Design;
import neatwork.project.Diameter;
import neatwork.project.Pipe;
import neatwork.utils.Same;

public class DesignPipeModel
extends FancyTableModel {
    private String[] headerNode = new String[]{Messages.getString("DesignPipeModel.Begin"), Messages.getString("DesignPipeModel.End"), Messages.getString("DesignPipeModel.Length"), Messages.getString("DesignPipeModel.Length_1"), Messages.getString("DesignPipeModel.diam_1"), Messages.getString("DesignPipeModel.Length_2"), Messages.getString("DesignPipeModel.diam_2")};
    private int[] myWhidthHeader = new int[]{80, 80, 70, 80, 80, 80, 80};
    private Design design;
    private Database database;
    private JComboBox comboBox;
    private FancyTable table;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;

    public DesignPipeModel(Design design, Database database, FancyTable table) {
        this.design = design;
        this.database = database;
        this.header = this.headerNode;
        this.widthHeader = this.myWhidthHeader;
        this.updateData();
    }

    public void updateData() {
        this.data = new Vector();
        Iterator iter = this.design.getPipeIterator();
        while (iter.hasNext()) {
            Pipe pipe = (Pipe)iter.next();
            Vector<Object> line = new Vector<Object>();
            line.add(pipe.getBegin());
            line.add(pipe.getEnd());
            line.add(new Double(pipe.getLength()));
            line.add(new Double(pipe.getLength1()));
            line.add(pipe.getRefDiam1());
            line.add(new Double(pipe.getLength2()));
            line.add(pipe.getRefDiam2());
            line.add("N");
            this.data.add(line);
        }
    }

    public Class getColumnClass(int col) {
        switch (col + 1) {
            case 1: {
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = class$0 = Class.forName("java.lang.String");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                return clazz;
            }
            case 2: {
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = class$0 = Class.forName("java.lang.String");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                return clazz;
            }
            case 3: {
                Class<?> clazz = class$1;
                if (clazz == null) {
                    try {
                        clazz = class$1 = Class.forName("java.lang.Double");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                return clazz;
            }
            case 4: {
                Class<?> clazz = class$1;
                if (clazz == null) {
                    try {
                        clazz = class$1 = Class.forName("java.lang.Double");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                return clazz;
            }
            case 5: {
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = class$0 = Class.forName("java.lang.String");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                return clazz;
            }
            case 6: {
                Class<?> clazz = class$1;
                if (clazz == null) {
                    try {
                        clazz = class$1 = Class.forName("java.lang.Double");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                return clazz;
            }
            case 7: {
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = class$0 = Class.forName("java.lang.String");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                return clazz;
            }
        }
        Class<?> clazz = class$2;
        if (clazz == null) {
            try {
                clazz = class$2 = Class.forName("java.lang.Object");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return clazz;
    }

    protected Vector getNewVector() {
        Vector<Object> line = new Vector<Object>();
        line.add(this.design.getLastNode().getName());
        line.add(this.design.getLastNode().getName());
        line.add(new Double(0.0));
        line.add(new Double(0.0));
        line.add("0");
        line.add(new Double(0.0));
        line.add("0");
        line.add("N");
        return line;
    }

    public Object getValueAt(int row, int col) {
        Object o = super.getValueAt(row, col);
        if (col == 6 && (Double)this.getValueAt(row, 5) == 0.0) {
            return "-";
        }
        return o;
    }

    public boolean isCellEditable(int row, int col) {
        if (col == 6 && this.getValueAt(row, 6).toString().equals("-")) {
            return false;
        }
        return super.isCellEditable(row, col);
    }

    public void setValueAt(Object obj, int row, int col) {
        if ((col == 4 || col == 6) && obj != null) {
            String diam = ((String)obj).substring(5, obj.toString().indexOf(":"));
            String sdr = ((String)obj).substring(obj.toString().indexOf(":") + 5, obj.toString().lastIndexOf(":"));
            String type = ((String)obj).substring(obj.toString().lastIndexOf(":"));
            int ttype = 1;
            int i = 1;
            while (i < Diameter.typeName.length) {
                if (type.equals(Diameter.typeName[i])) {
                    ttype = i;
                }
                ++i;
            }
            Diameter temp = new Diameter();
            temp.setDiameter(Double.parseDouble(diam));
            temp.setSdr(Double.parseDouble(sdr));
            temp.setType(ttype);
            String ref = this.getRef(this.design.getDiamTable(), temp);
            if (ref != null) {
                obj = ref;
            } else {
                ref = this.getRef(this.database.getDiametersTable(), temp);
                obj = "D" + (this.design.getDiamTable().size() + 1);
                this.design.getDiamTable().put(obj.toString(), this.database.getDiametersTable().get(ref));
            }
        }
        super.setValueAt(obj, row, col);
    }

    public String getContent() {
        String content = super.getContent();
        content = String.valueOf(content) + this.design.getDiametersContent();
        return content;
    }

    private String getRef(Hashtable htable, Diameter diam) {
        String ref = null;
        Enumeration e = htable.keys();
        while (ref == null && e.hasMoreElements()) {
            String s = e.nextElement().toString();
            if (!((Same)htable.get(s)).isSame(diam)) continue;
            ref = s;
        }
        return ref;
    }

    public boolean setPaste(String clip) {
        StringTokenizer st1 = new StringTokenizer(clip, "\n");
        boolean isOk = true;
        while (st1.hasMoreTokens() && isOk) {
            StringTokenizer st2 = new StringTokenizer(st1.nextToken(), "\t");
            boolean bl = isOk = st2.countTokens() == this.getColumnCount();
        }
        if (isOk) {
            this.data.clear();
            Vector nline = this.getNewVector();
            st1 = new StringTokenizer(clip, "\n");
            int i = 0;
            while (st1.hasMoreTokens()) {
                StringTokenizer st2 = new StringTokenizer(st1.nextToken(), "\t");
                Vector<Object> line = new Vector<Object>();
                int j = 0;
                while (st2.hasMoreTokens()) {
                    String cell = st2.nextToken();
                    if (nline.get(j) instanceof String) {
                        line.add(cell);
                    } else if (nline.get(j) instanceof Double) {
                        line.add(new Double(cell));
                    } else if (nline.get(j) instanceof Integer) {
                        line.add(new Integer(cell));
                    }
                    ++j;
                }
                line.add("N");
                this.data.add(line);
                ++i;
            }
            this.fireTableDataChanged();
        }
        return isOk;
    }
}

