/*
 * Decompiled with CFR 0.152.
 */
package neatwork.gui.design;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;
import neatwork.Messages;
import neatwork.gui.design.DesignLoadFactorModel;
import neatwork.gui.fancytable.FancyTable;
import neatwork.gui.fancytable.FancyTablePanel;
import neatwork.gui.fancytable.TableSorter;
import neatwork.project.Design;

public class DesignLoadFactorDialog
extends JDialog
implements ActionListener {
    public DesignLoadFactorDialog(JFrame frame, Design design) {
        super(frame, Messages.getString("DesignLoadFactorDialog.Building_Load_Factors"), true);
        ((Component)this).setSize(400, 400);
        Dimension d = Toolkit.getDefaultToolkit().getScreenSize();
        ((Component)this).setLocation((d.width - this.getSize().width) / 2, (d.height - this.getSize().height) / 2);
        this.setDefaultCloseOperation(2);
        Hashtable table0 = design.getLoadFactorTable();
        Properties prop = new Properties();
        Enumeration enumeration = table0.keys();
        int bip = 0;
        String source = design.getSource().getName();
        while (enumeration.hasMoreElements()) {
            String item = enumeration.nextElement().toString();
            if (item.equals(source)) continue;
            prop.setProperty("topo." + bip + ".name", item);
            prop.setProperty("topo." + bip + ".value", table0.get(item).toString());
            ++bip;
        }
        DesignLoadFactorModel tableModel = new DesignLoadFactorModel(prop);
        FancyTable table = new FancyTable(tableModel);
        TableSorter sorter = (TableSorter)table.getModel();
        sorter.sortByColumn(0);
        Container pane = this.getContentPane();
        pane.setLayout(new BorderLayout(5, 5));
        pane.add((Component)new FancyTablePanel(String.valueOf(Messages.getString("DesignLoadFactorDialog.These_are_the_load_factors_used_by")) + Messages.getString("DesignLoadFactorDialog.the_MAKE_DESIGN_operation_for_building") + Messages.getString("DesignLoadFactorDialog._this_design"), null, table, true), "Center");
        JButton button = new JButton(Messages.getString("DesignLoadFactorDialog.Close"));
        JPanel panel = new JPanel(new FlowLayout(2));
        panel.add(button);
        button.addActionListener(this);
        pane.add((Component)panel, "South");
    }

    public void actionPerformed(ActionEvent e) {
        this.dispose();
    }
}

