/*
 * Decompiled with CFR 0.152.
 */
package neatwork.gui.design;

import java.awt.Dimension;
import java.util.Enumeration;
import javax.swing.JComboBox;
import neatwork.gui.design.SteppedComboBoxUI;
import neatwork.project.Database;
import neatwork.project.Diameter;

public class ComboDatabase
extends JComboBox {
    protected int popupWidth;
    private Database database;

    public ComboDatabase(Database database) {
        this.database = database;
        this.updateList();
        this.setUI(new SteppedComboBoxUI());
        this.popupWidth = 0;
    }

    public String getEnonce(Diameter diam) {
        return "diam " + diam.getDiameter() + ":sdr " + diam.getSdr() + ":(" + Diameter.typeName[diam.getType()] + ")";
    }

    public Double getSelectedDiameter() {
        String s = this.getSelectedItem().toString();
        return new Double(s.substring(5, s.indexOf(":")));
    }

    private void updateList() {
        this.removeAllItems();
        Enumeration enumeration = this.database.getDiameters();
        while (enumeration.hasMoreElements()) {
            Diameter item = (Diameter)enumeration.nextElement();
            this.addItem(this.getEnonce(item));
        }
    }

    public void setPopupWidth(int width) {
        this.popupWidth = width;
    }

    public Dimension getPopupSize() {
        Dimension size = this.getSize();
        if (this.popupWidth < 1) {
            this.popupWidth = size.width;
        }
        return new Dimension(this.popupWidth, size.height);
    }
}

