/*
 * Decompiled with CFR 0.152.
 */
package neatwork.gui.database;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Date;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Observable;
import java.util.Observer;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import neatwork.Messages;
import neatwork.gui.FrameNeatwork;
import neatwork.gui.database.DBDiameterTableModel;
import neatwork.gui.database.DBOrificeTableModel;
import neatwork.gui.fancytable.FancyTable;
import neatwork.gui.fancytable.FancyTablePanel;
import neatwork.project.Database;
import neatwork.project.Diameter;
import neatwork.project.Orifice;
import neatwork.utils.NeatworkAction;
import neatwork.utils.Tools;

public class DatabaseDialog
extends JDialog
implements Observer {
    private Database database;
    private DBDiameterTableModel diameterTableModel;
    private DBOrificeTableModel orificeTableModel;
    private FancyTable jTableOrifice;
    private FancyTable jTableDiameter;
    private JTabbedPane jTabbedPane;
    String pathImage = "/neatwork/gui/images/";

    public DatabaseDialog(FrameNeatwork frame, Database database0) {
        super(frame, Messages.getString("DatabaseDialog.Materials_database"), true);
        ((Component)this).setSize(640, 400);
        Dimension d = Toolkit.getDefaultToolkit().getScreenSize();
        ((Component)this).setLocation((d.width - this.getSize().width) / 2, (d.height - this.getSize().height) / 2);
        this.database = database0;
        this.database.addObserver(this);
        JPanel panel = new JPanel(new BorderLayout(10, 10));
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)panel, "Center");
        boolean standalone = frame.properties.getProperty("appli.standalone").equals("true");
        this.diameterTableModel = new DBDiameterTableModel(this.database);
        this.orificeTableModel = new DBOrificeTableModel(this.database);
        this.jTableDiameter = new FancyTable(this.diameterTableModel, true);
        this.jTableOrifice = new FancyTable(this.orificeTableModel, true);
        this.jTabbedPane = new JTabbedPane();
        Action[] actions = new Action[10];
        actions[0] = this.jTableDiameter.insertRowAction;
        actions[0].putValue("ShortDescription", Messages.getString("DatabaseDialog.Insert_a_new_diameter"));
        actions[1] = this.jTableDiameter.deleteRowAction;
        actions[1].putValue("ShortDescription", Messages.getString("DatabaseDialog.Delete_selected_diameter(s)"));
        actions[2] = null;
        actions[3] = this.jTableDiameter.copyAction;
        actions[4] = this.jTableDiameter.pasteAction;
        actions[5] = null;
        actions[6] = this.jTableDiameter.updateAction;
        actions[6].putValue("ShortDescription", Messages.getString("DatabaseDialog.Load_data"));
        actions[6].putValue("SmallIcon", new ImageIcon(this.getClass().getResource(String.valueOf(this.pathImage) + "DataExtract.png")));
        ImageIcon icon = new ImageIcon(this.getClass().getResource(String.valueOf(this.pathImage) + "DataStore.png"));
        actions[7] = new NeatworkAction(Messages.getString("DatabaseDialog.Apply"), icon, Messages.getString("DatabaseDialog.Save_data"), 'A'){

            public void actionPerformed(ActionEvent e) {
                DatabaseDialog.this.database.setDiametersContent(DatabaseDialog.this.diameterTableModel.getContent());
                DatabaseDialog.this.jTableDiameter.updateData();
                DatabaseDialog.this.database.saveDiameters(DatabaseDialog.this.diameterTableModel.getContent());
            }
        };
        actions[8] = null;
        ImageIcon icon3 = new ImageIcon(this.getClass().getResource(String.valueOf(this.pathImage) + "report.png"));
        actions[9] = new NeatworkAction(Messages.getString("DatabaseDialog.Export"), icon3, Messages.getString("DatabaseDialog.Report_in_HTML"), 'A'){

            public void actionPerformed(ActionEvent e) {
                String s = Messages.getString("DatabaseDialog.<html><head><title>");
                s = String.valueOf(s) + Messages.getString("DatabaseDialog.Database_-_Diameters");
                s = String.valueOf(s) + "</title></head><body>";
                s = String.valueOf(s) + "<h1>" + Messages.getString("DatabaseDialog.Database_-_Diameters") + "</h1>";
                s = String.valueOf(s) + "<table BORDER CELLPADDING=0 CELLSPACING=0>";
                s = String.valueOf(s) + Messages.getString("DatabaseDialog.<tr><th>Nominal</th><th>SDR</th><th>Cost</th><th>Max_Pressure</th><th>Type</th><th>Roughness</th></tr>");
                Enumeration en = DatabaseDialog.this.database.getDiameters();
                while (en.hasMoreElements()) {
                    Diameter d = (Diameter)en.nextElement();
                    s = String.valueOf(s) + "<tr>";
                    s = String.valueOf(s) + "<td>" + d.getNominal() + "</td>";
                    s = String.valueOf(s) + "<td>" + d.getSdr() + "</td>";
                    s = String.valueOf(s) + "<td>" + d.getCost() + "</td>";
                    s = String.valueOf(s) + "<td>" + d.getMaxLength() + "</td>";
                    s = String.valueOf(s) + "<td>" + d.getType() + "</td>";
                    s = String.valueOf(s) + "<td>" + d.getRoughness() + "</td>";
                    s = String.valueOf(s) + "</tr>";
                }
                s = String.valueOf(s) + "</table><p>" + new Date().toString() + "</p>";
                Tools.enregFich(s);
            }
        };
        actions[9].setEnabled(standalone);
        this.jTabbedPane.addTab(Messages.getString("DatabaseDialog.Diameters"), new FancyTablePanel(Messages.getString("DatabaseDialog.Diameters_list"), actions, this.jTableDiameter, true));
        actions = new Action[10];
        actions[0] = this.jTableOrifice.insertRowAction;
        actions[0].putValue("ShortDescription", Messages.getString("DatabaseDialog.Insert_a_new_orifice"));
        actions[1] = this.jTableOrifice.deleteRowAction;
        actions[1].putValue("ShortDescription", Messages.getString("DatabaseDialog.Delete_selected_orifice(s)"));
        actions[2] = null;
        actions[3] = this.jTableOrifice.copyAction;
        actions[4] = this.jTableOrifice.pasteAction;
        actions[5] = null;
        actions[6] = this.jTableOrifice.updateAction;
        actions[6].putValue("ShortDescription", Messages.getString("DatabaseDialog.Load_data"));
        actions[6].putValue("SmallIcon", new ImageIcon(this.getClass().getResource(String.valueOf(this.pathImage) + "DataExtract.png")));
        icon = new ImageIcon(this.getClass().getResource(String.valueOf(this.pathImage) + "DataStore.png"));
        actions[7] = new NeatworkAction(Messages.getString("DatabaseDialog.Apply"), icon, Messages.getString("DatabaseDialog.Save_data"), 'A'){

            public void actionPerformed(ActionEvent e) {
                DatabaseDialog.this.database.setOrificesContent(DatabaseDialog.this.orificeTableModel.getContent());
                DatabaseDialog.this.jTableOrifice.updateData();
                DatabaseDialog.this.database.saveOrifices(DatabaseDialog.this.orificeTableModel.getContent());
            }
        };
        actions[8] = null;
        ImageIcon icon4 = new ImageIcon(this.getClass().getResource(String.valueOf(this.pathImage) + "report.png"));
        actions[9] = new NeatworkAction(Messages.getString("DatabaseDialog.Export"), icon3, Messages.getString("DatabaseDialog.Report_in_HTML"), 'A'){

            public void actionPerformed(ActionEvent e) {
                String s = "<html><head><title>";
                s = String.valueOf(s) + Messages.getString("DatabaseDialog.Database_-_Orifices");
                s = String.valueOf(s) + "</title></head><body>";
                s = String.valueOf(s) + "<h1>" + Messages.getString("DatabaseDialog.Database_-_Orifices") + "</h1>";
                s = String.valueOf(s) + "<table BORDER CELLPADDING=0 CELLSPACING=0>";
                s = String.valueOf(s) + Messages.getString("DatabaseDialog.<tr><th>Diameter</th></tr>");
                Iterator en = DatabaseDialog.this.database.getOrifices().iterator();
                while (en.hasNext()) {
                    Orifice d = (Orifice)en.next();
                    s = String.valueOf(s) + "<tr>";
                    s = String.valueOf(s) + "<td>" + d.getDiameter() + "</td>";
                    s = String.valueOf(s) + "</tr>";
                }
                s = String.valueOf(s) + "</table><p>" + new Date().toString() + "</p>";
                Tools.enregFich(s);
            }
        };
        actions[9].setEnabled(standalone);
        this.jTabbedPane.addTab(Messages.getString("DatabaseDialog.Orifices"), Tools.getPanelTable(Messages.getString("DatabaseDialog.<html>Orifices_list"), actions, this.jTableOrifice));
        panel.add((Component)this.jTabbedPane, "Center");
        JPanel jPanel2 = new JPanel(new FlowLayout(2));
        jPanel2.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        JButton buttonClose = new JButton(Messages.getString("DatabaseDialog.Close"));
        jPanel2.add(buttonClose);
        buttonClose.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                DatabaseDialog.this.dispose();
            }
        });
        panel.add((Component)jPanel2, "South");
        this.setDefaultCloseOperation(2);
    }

    private void updateDiametersTable() {
        this.diameterTableModel.updateData();
    }

    private void updateOrificesTable() {
        this.orificeTableModel.updateData();
    }

    public void update(Observable observable, Object param) {
        if (observable.getClass().isInstance(this.database)) {
            switch ((Integer)param) {
                case 1: {
                    this.updateOrificesTable();
                    break;
                }
                case 0: {
                    this.updateDiametersTable();
                }
            }
        }
    }
}

