/*
 * Decompiled with CFR 0.152.
 */
package neatwork.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Observable;
import java.util.Observer;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import neatwork.Messages;
import neatwork.project.Project;

public class TextPane
extends JPanel
implements ActionListener,
Observer {
    private Project project;
    private JTextArea textArea = new JTextArea();
    private JButton button;
    private JButton button2;
    private JPanel jPanel = new JPanel();

    public TextPane(Project project) {
        this.project = project;
        project.addObserver(this);
        this.setLayout(new BorderLayout(5, 5));
        this.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        this.jPanel.setLayout(new FlowLayout(2));
        this.add((Component)new JScrollPane(this.textArea), "Center");
        this.add((Component)this.jPanel, "South");
        this.button = new JButton(Messages.getString("TextPane.Apply"), new ImageIcon(this.getClass().getResource("/neatwork/gui/images/Check.gif")));
        this.button.setActionCommand(Messages.getString("TextPane.Apply"));
        this.button2 = new JButton(Messages.getString("TextPane.Undo"), new ImageIcon(this.getClass().getResource("/neatwork/gui/images/Undo.png")));
        this.button2.setActionCommand(Messages.getString("TextPane.Reset"));
        this.jPanel.add(this.button2);
        this.jPanel.add(this.button);
        this.button2.addActionListener(this);
        this.button.addActionListener(this);
        this.updateTextArea();
    }

    private void updateTextArea() {
        this.textArea.setText(this.project.getContent());
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getActionCommand().equals(Messages.getString("TextPane.Apply"))) {
            this.project.freeInfoModif();
            this.project.setContent(this.textArea.getText());
            if (!this.project.getInfoModif().equals("")) {
                JOptionPane.showMessageDialog(this, Messages.getString("TextPane.error_in_your_project"));
            }
            if (this.project.getInfoModif().indexOf(Messages.getString("TextPane.error")) != -1) {
                this.updateTextArea();
            }
        } else if (e.getActionCommand().equals(Messages.getString("TextPane.Reset"))) {
            this.updateTextArea();
        }
    }

    public void update(Observable observable, Object param) {
        if (observable.getClass().isInstance(this.project)) {
            switch ((Integer)param) {
                case 0: {
                    this.updateTextArea();
                }
            }
        }
    }
}

