/*
 * Decompiled with CFR 0.152.
 */
package neatwork.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Observable;
import java.util.Observer;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import neatwork.Messages;
import neatwork.solver.AbstractSolver;

public class SolverProgressDialog
extends JDialog
implements Observer,
ActionListener {
    private AbstractSolver solver;
    private JLabel labelStatus = new JLabel("");
    private JProgressBar progressBar = new JProgressBar(0, 100);
    private JButton buttonClose;

    public SolverProgressDialog(AbstractSolver solver, Thread thread) {
        this.setTitle(Messages.getString("SolverProgressDialog.In_Progress"));
        this.setModal(true);
        ((Component)this).setSize(400, 150);
        Dimension d = Toolkit.getDefaultToolkit().getScreenSize();
        ((Component)this).setLocation((d.width - this.getSize().width) / 2, (d.height - this.getSize().height) / 2);
        this.setDefaultCloseOperation(0);
        this.solver = solver;
        solver.addObserver(this);
        Container container = this.getContentPane();
        container.setLayout(new BorderLayout(5, 5));
        JPanel panelT = new JPanel(new BorderLayout(5, 5));
        panelT.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        panelT.add((Component)this.progressBar, "South");
        this.progressBar.setStringPainted(true);
        panelT.add((Component)this.labelStatus, "North");
        JPanel panelB = new JPanel(new FlowLayout(1));
        panelB.setBorder(BorderFactory.createEmptyBorder(5, 10, 10, 5));
        this.buttonClose = new JButton(Messages.getString("SolverProgressDialog.Close"));
        this.buttonClose.setMnemonic('C');
        this.buttonClose.setEnabled(false);
        panelB.add(this.buttonClose);
        container.add((Component)panelT, "North");
        container.add((Component)panelB, "South");
        this.buttonClose.addActionListener(this);
        thread.start();
    }

    private void setProgress() {
        this.progressBar.setValue(this.solver.getProgress());
        this.buttonClose.setEnabled(this.solver.getProgress() == 100);
    }

    private void setStatus() {
        this.labelStatus.setText(this.solver.getStatut());
    }

    public void update(Observable observable, Object param) {
        if (observable.getClass().isInstance(this.solver)) {
            switch ((Integer)param) {
                case 0: {
                    this.setProgress();
                    break;
                }
                case 1: {
                    this.setStatus();
                }
            }
        }
    }

    public void actionPerformed(ActionEvent e) {
        this.dispose();
    }
}

