/*
 * Decompiled with CFR 0.152.
 */
package neatwork.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.util.Hashtable;
import java.util.ListIterator;
import java.util.Observable;
import java.util.Observer;
import java.util.Properties;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import neatwork.Messages;
import neatwork.file.AbstractFileManager;
import neatwork.gui.DesignPane;
import neatwork.gui.PresentationPanel;
import neatwork.gui.TopographiePane;
import neatwork.gui.tabbedpane.SingleRowTabbedPane;
import neatwork.project.Database;
import neatwork.project.Design;
import neatwork.project.Project;
import neatwork.project.ProjectManager;
import neatwork.project.Topographie;

public class ProjectPane
extends JPanel
implements Observer,
ChangeListener {
    private ProjectManager projectManager;
    private AbstractFileManager fileManager;
    private Properties properties;
    private Database database;
    private SingleRowTabbedPane tabbedPane;
    private Hashtable icons = new Hashtable();

    public ProjectPane(ProjectManager projectManager, AbstractFileManager fileManager, Properties properties, Database database) {
        this.projectManager = projectManager;
        this.fileManager = fileManager;
        this.properties = properties;
        this.database = database;
        this.icons.put(new Integer(0), new ImageIcon(this.getClass().getResource("/neatwork/gui/images/Topo.gif")));
        this.icons.put(new Integer(1), new ImageIcon(this.getClass().getResource("/neatwork/gui/images/Design.gif")));
        projectManager.addObserver(this);
        this.setLayout(new BorderLayout());
        this.tabbedPane = new SingleRowTabbedPane(4, 4);
        this.tabbedPane.setTabPlacement(3);
        this.tabbedPane.addChangeListener(this);
        this.createPanes();
        this.add((Component)this.tabbedPane, "Center");
    }

    private void createPanes() {
        int size = this.tabbedPane.getTabCount();
        int i = 0;
        while (i < size) {
            this.tabbedPane.removeTabAt(0);
            ++i;
        }
        ListIterator iter = this.projectManager.getProjectIterator();
        while (iter.hasNext()) {
            Project project = (Project)iter.next();
            this.tabbedPane.addTab(project.getShortName(), (Icon)this.icons.get(new Integer(project.getType())), this.createPanel(project), project.getName());
        }
        if (this.tabbedPane.getTabCount() == 0) {
            PresentationPanel panel = new PresentationPanel(this.properties);
            this.tabbedPane.addTab(Messages.getString("ProjectPane.NeatWork"), panel);
        }
        this.projectManager.setIndex(this.tabbedPane.getSelectedIndex());
    }

    private JPanel createPanel(Project project) {
        switch (project.getType()) {
            case 0: {
                return new TopographiePane((Topographie)project);
            }
            case 1: {
                return new DesignPane((Design)project, this.database, this.fileManager, this.properties);
            }
        }
        return new JPanel();
    }

    public void update(Observable observable, Object object) {
        if (observable.getClass().isInstance(this.projectManager)) {
            int choix = (Integer)object;
            switch (choix) {
                case 0: {
                    int cur = this.tabbedPane.getSelectedIndex();
                    this.createPanes();
                    this.tabbedPane.setSelectedIndex(cur);
                    break;
                }
                case 1: {
                    this.createPanes();
                    this.tabbedPane.setSelectedIndex(this.tabbedPane.getTabCount() - 1);
                    break;
                }
                case 2: {
                    int sel = this.tabbedPane.getSelectedIndex();
                    if (sel == this.tabbedPane.getTabCount() - 1) {
                        --sel;
                    }
                    this.createPanes();
                    if (sel <= -1) break;
                    this.tabbedPane.setSelectedIndex(sel);
                }
            }
        }
    }

    public void stateChanged(ChangeEvent e) {
        this.projectManager.setIndex(this.tabbedPane.getSelectedIndex());
    }
}

