/*
 * Decompiled with CFR 0.152.
 */
package neatwork.gui;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.ListIterator;
import java.util.Locale;
import java.util.Observable;
import java.util.Observer;
import java.util.Properties;
import java.util.Vector;
import javax.swing.Action;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JOptionPane;
import javax.swing.JRadioButtonMenuItem;
import neatwork.Messages;
import neatwork.file.AbstractFileManager;
import neatwork.file.FileManagerClient;
import neatwork.file.FileManagerDisk;
import neatwork.gui.AboutDialog;
import neatwork.gui.FileManagerDialog;
import neatwork.gui.LocaleAction;
import neatwork.gui.ProjectPane;
import neatwork.gui.SolverProgressDialog;
import neatwork.gui.UnitDialog;
import neatwork.gui.database.DatabaseDialog;
import neatwork.gui.design.DesignLoadFactorDialog;
import neatwork.gui.design.DesignParaDialog;
import neatwork.gui.makedesign.MakeDesignDialog;
import neatwork.gui.makedesign.NodeTapPressureDialog;
import neatwork.gui.makedesign.ThreadMakeDesign;
import neatwork.gui.topographie.QuickCheckDialog;
import neatwork.gui.topographie.TopoStatDialog;
import neatwork.project.Database;
import neatwork.project.Design;
import neatwork.project.Diameter;
import neatwork.project.Node;
import neatwork.project.Pipe;
import neatwork.project.Project;
import neatwork.project.ProjectManager;
import neatwork.project.Topographie;
import neatwork.solver.AbstractSolver;
import neatwork.solver.SolverClient;
import neatwork.solver.SolverDisk;
import neatwork.utils.NeatworkAction;
import neatwork.utils.Same;
import neatwork.utils.Tools;

public class FrameNeatwork
extends JFrame
implements Observer,
Runnable,
ItemListener {
    public Properties properties = new Properties();
    private JMenuBar menuBar;
    private JMenu fileMenu;
    private JMenu helpMenu;
    private JMenu databaseMenu;
    private JMenu topographyMenu;
    private JMenu designMenu;
    private JMenu langMenu;
    private JRadioButtonMenuItem menuItemSolverLocal;
    private JRadioButtonMenuItem menuItemSolverServer;
    private AbstractFileManager fileManager;
    private Database database;
    private FileManagerDialog dialog;
    private AboutDialog aboutDialog;
    private UnitDialog unitDialog;
    private ProjectManager projectManager;
    private ProjectPane projectPane;
    private DatabaseDialog databaseDialog;
    private Action debugAction;
    private Action exitAction;
    private Action newTopoAction;
    private Action openTopoAction;
    private Action openDesignAction;
    private Action saveAction;
    private Action saveAsAction;
    private Action deleteTopoAction;
    private Action deleteDesignAction;
    private Action closeAction;
    private Action closeAllAction;
    private Action aboutAction;
    private Action unitAction;
    private Action databaseAction;
    private Action makeDesignAction;
    private Action quickCheckAction;
    private Action topoStatAction;
    private Action designParameterAction;
    private Action designExtractTopoAction;
    private Action designLoadFactorAction;
    private Action reportTopoAction;
    private Action reportDesignAction;
    private String[] langList = new String[]{Messages.getString("FrameNeatwork.English"), Messages.getString("FrameNeatwork.Spanish"), Messages.getString("FrameNeatwork.French")};
    private String[] langcode = new String[]{Locale.ENGLISH.getLanguage(), "sp", Locale.FRENCH.getLanguage()};

    public FrameNeatwork(Properties properties) {
        super(properties.getProperty("appli.name", "NeatWork"));
        this.properties = properties;
        ((Component)this).setSize(750, 550);
        this.setDefaultCloseOperation(0);
        this.defineAction();
        this.defineMenu();
        this.fileManager = properties.getProperty("file.distant").equals("true") ? new FileManagerClient(properties) : new FileManagerDisk(properties);
        this.dialog = new FileManagerDialog(this, this.fileManager, properties);
        this.projectManager = new ProjectManager();
        this.aboutDialog = new AboutDialog(this, properties);
        this.unitDialog = new UnitDialog(this, properties);
        this.projectManager.addObserver(this);
        this.database = new Database(this.fileManager, properties);
        this.database.addObserver(this);
        this.databaseDialog = new DatabaseDialog(this, this.database);
        Container content = this.getContentPane();
        this.projectPane = new ProjectPane(this.projectManager, this.fileManager, properties, this.database);
        content.add(this.projectPane);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                FrameNeatwork.this.exitApplication();
            }
        });
        Dimension d = Toolkit.getDefaultToolkit().getScreenSize();
        ((Component)this).setLocation((d.width - this.getSize().width) / 2, (d.height - this.getSize().height) / 2);
        ((Component)this).setVisible(true);
    }

    private void defineAction() {
        String pathImg = "/neatwork/gui/images/";
        Icon exitIcon = null;
        this.exitAction = new NeatworkAction(Messages.getString("FrameNeatwork.Exit"), exitIcon, Messages.getString("FrameNeatwork.Exit_Application"), 'X'){

            public void actionPerformed(ActionEvent e) {
                FrameNeatwork.this.exitApplication();
            }
        };
        Icon newTopoIcon = null;
        this.newTopoAction = new NeatworkAction(Messages.getString("FrameNeatwork.New_Topography..."), newTopoIcon, Messages.getString("FrameNeatwork.New_Topography"), 'N'){

            public void actionPerformed(ActionEvent e) {
                FrameNeatwork.this.dialog.show(3, 0);
                if (!FrameNeatwork.this.dialog.getCancelled()) {
                    Topographie project = new Topographie(FrameNeatwork.this.dialog.getFileName(), FrameNeatwork.this.dialog.getContent(), FrameNeatwork.this.properties);
                    FrameNeatwork.this.projectManager.addProject(project);
                }
            }
        };
        Icon openTopoIcon = null;
        this.openTopoAction = new NeatworkAction(Messages.getString("FrameNeatwork.Open_Topography..."), openTopoIcon, Messages.getString("FrameNeatwork.Open_Topography"), 'T'){

            public void actionPerformed(ActionEvent e) {
                FrameNeatwork.this.dialog.show(0, 0);
                if (!FrameNeatwork.this.dialog.getCancelled()) {
                    Topographie project = new Topographie(FrameNeatwork.this.dialog.getFileName(), FrameNeatwork.this.dialog.getContent(), FrameNeatwork.this.properties);
                    project.setName(FrameNeatwork.this.projectManager.isAlreadyLoaded(project));
                    FrameNeatwork.this.projectManager.addProject(project);
                }
            }
        };
        Icon openDesignIcon = null;
        this.openDesignAction = new NeatworkAction(Messages.getString("FrameNeatwork.Open_Design..."), openDesignIcon, Messages.getString("FrameNeatwork.Open_Design"), 'T'){

            public void actionPerformed(ActionEvent e) {
                FrameNeatwork.this.dialog.show(0, 1);
                if (!FrameNeatwork.this.dialog.getCancelled()) {
                    Design project = new Design(FrameNeatwork.this.dialog.getFileName(), FrameNeatwork.this.dialog.getContent(), FrameNeatwork.this.properties);
                    project.setName(FrameNeatwork.this.projectManager.isAlreadyLoaded(project));
                    FrameNeatwork.this.projectManager.addProject(project);
                    project.refreshDesign(FrameNeatwork.this.database);
                }
            }
        };
        Icon saveIcon = null;
        this.saveAction = new NeatworkAction(Messages.getString("FrameNeatwork.Save"), saveIcon, Messages.getString("FrameNeatwork.Save"), 'S'){

            public void actionPerformed(ActionEvent e) {
                Project project = FrameNeatwork.this.projectManager.getCurrentProject();
                String newname = FrameNeatwork.this.fileManager.getFirstNameCompatible(project);
                if (newname.equals(project.getName())) {
                    FrameNeatwork.this.saveAsAction.actionPerformed(null);
                } else {
                    FrameNeatwork.this.fileManager.writeFile(FrameNeatwork.this.projectManager.getCurrentProject());
                }
            }
        };
        Icon saveAsIcon = null;
        this.saveAsAction = new NeatworkAction(Messages.getString("FrameNeatwork.Save_as..."), saveAsIcon, Messages.getString("FrameNeatwork.Save_as"), 'A'){

            public void actionPerformed(ActionEvent e) {
                Project project = FrameNeatwork.this.projectManager.getCurrentProject();
                FrameNeatwork.this.dialog.setFileName(project.getName());
                FrameNeatwork.this.dialog.setContent(project.getContent());
                FrameNeatwork.this.dialog.show(1, FrameNeatwork.this.projectManager.getCurrentProject().getType());
                if (!FrameNeatwork.this.dialog.getCancelled()) {
                    project.setName(FrameNeatwork.this.dialog.getFileName());
                    FrameNeatwork.this.projectManager.setCurrentProject(project);
                }
            }
        };
        Icon closeIcon = null;
        this.closeAction = new NeatworkAction(Messages.getString("FrameNeatwork.Close"), closeIcon, Messages.getString("FrameNeatwork.Close_this_file"), 'C'){

            public void actionPerformed(ActionEvent e) {
                Object[] options = new Object[]{Messages.getString("FrameNeatwork.Yes"), Messages.getString("FrameNeatwork.No")};
                if (JOptionPane.showOptionDialog(null, String.valueOf(Messages.getString("FrameNeatwork.Do_you_want_to_close_the_file")) + FrameNeatwork.this.projectManager.getCurrentProject().getName() + "?", Messages.getString("FrameNeatwork.Close_File"), 0, 2, null, options, options[0]) == 0) {
                    FrameNeatwork.this.projectManager.removeCurrentProject();
                }
            }
        };
        Icon closeAllIcon = null;
        this.closeAllAction = new NeatworkAction(Messages.getString("FrameNeatwork.Close_All"), closeAllIcon, Messages.getString("FrameNeatwork.Close_all_files"), 'A'){

            public void actionPerformed(ActionEvent e) {
                Object[] options = new Object[]{Messages.getString("FrameNeatwork.Yes"), Messages.getString("FrameNeatwork.No")};
                if (JOptionPane.showOptionDialog(null, Messages.getString("FrameNeatwork.Do_you_want_to_close_all_the_files"), Messages.getString("FrameNeatwork.Close_All_The_Files"), 0, 2, null, options, options[0]) == 0) {
                    int n = FrameNeatwork.this.projectManager.getNbProject();
                    int i = 0;
                    while (i < n) {
                        FrameNeatwork.this.projectManager.removeCurrentProject();
                        ++i;
                    }
                }
            }
        };
        Icon deleteTopoIcon = null;
        this.deleteTopoAction = new NeatworkAction(Messages.getString("FrameNeatwork.Delete_a_Topography..."), deleteTopoIcon, Messages.getString("FrameNeatwork.Delete_a_Topography"), 'T'){

            public void actionPerformed(ActionEvent e) {
                FrameNeatwork.this.dialog.setFileName("");
                FrameNeatwork.this.dialog.show(2, 0);
            }
        };
        Icon deleteDesignIcon = null;
        this.deleteDesignAction = new NeatworkAction(Messages.getString("FrameNeatwork.Delete_a_Design..."), deleteDesignIcon, Messages.getString("FrameNeatwork.Delete_a_Design"), 'D'){

            public void actionPerformed(ActionEvent e) {
                FrameNeatwork.this.dialog.setFileName("");
                FrameNeatwork.this.dialog.show(2, 1);
            }
        };
        ImageIcon aboutIcon = new ImageIcon(this.getClass().getResource(String.valueOf(pathImg) + "Inform.png"));
        this.aboutAction = new NeatworkAction(Messages.getString("FrameNeatwork.About"), aboutIcon, Messages.getString("FrameNeatwork.About_Neatwork"), 'A'){

            public void actionPerformed(ActionEvent e) {
                ((Component)FrameNeatwork.this.aboutDialog).setVisible(true);
            }
        };
        Icon unitIcon = null;
        this.unitAction = new NeatworkAction(Messages.getString("FrameNeatwork.Units"), unitIcon, Messages.getString("FrameNeatwork.Units"), 'A'){

            public void actionPerformed(ActionEvent e) {
                ((Component)FrameNeatwork.this.unitDialog).setVisible(true);
            }
        };
        ImageIcon databaseIcon = new ImageIcon(this.getClass().getResource(String.valueOf(pathImg) + "Cylinder.png"));
        this.databaseAction = new NeatworkAction(Messages.getString("FrameNeatwork.Edit_database..."), databaseIcon, Messages.getString("FrameNeatwork.Edit_database..."), 'B'){

            public void actionPerformed(ActionEvent e) {
                ((Component)FrameNeatwork.this.databaseDialog).setVisible(true);
            }
        };
        Icon makeDesignIcon = null;
        this.makeDesignAction = new NeatworkAction(Messages.getString("FrameNeatwork.Make_Design..."), makeDesignIcon, Messages.getString("FrameNeatwork.Make_a_design_from_your_current_topo"), 'K'){

            public void actionPerformed(ActionEvent e) {
                Topographie topo = (Topographie)FrameNeatwork.this.projectManager.getCurrentProject();
                topo.setContent(topo.getContent());
                if (!topo.isATree()) {
                    JOptionPane.showMessageDialog(FrameNeatwork.this, Messages.getString("FrameNeatwork.The_topography_must_be_a_tree__!"), Messages.getString("FrameNeatwork.Not_a_tree"), 1);
                } else if (!(topo.getMinLength() > 0.0)) {
                    JOptionPane.showMessageDialog(FrameNeatwork.this, Messages.getString("FrameNeatwork.All_pipe_lengths_must_be_greater_than_0__!"), Messages.getString("FrameNeatwork.Bad_length"), 1);
                } else {
                    MakeDesignDialog dialog = new MakeDesignDialog(FrameNeatwork.this, FrameNeatwork.this.database, topo);
                    topo.setHauteurSource(dialog.getHSource());
                    ((Component)dialog).setVisible(true);
                    if (!dialog.getCanceled()) {
                        FrameNeatwork.this.runMakeDesign(dialog);
                    }
                }
            }
        };
        Icon topoStatIcon = null;
        this.topoStatAction = new NeatworkAction(Messages.getString("FrameNeatwork.Network_summary..."), topoStatIcon, Messages.getString("FrameNeatwork.Network_summary"), 'U'){

            public void actionPerformed(ActionEvent e) {
                Topographie topo = (Topographie)FrameNeatwork.this.projectManager.getCurrentProject();
                TopoStatDialog dialog = new TopoStatDialog(topo, FrameNeatwork.this);
                ((Component)dialog).setVisible(true);
            }
        };
        Icon reportopoIcon = null;
        this.reportTopoAction = new NeatworkAction(Messages.getString("FrameNeatwork.Report_in_HTML..."), reportopoIcon, "", 'H'){

            public void actionPerformed(ActionEvent e) {
                Same n;
                Topographie topo = (Topographie)FrameNeatwork.this.projectManager.getCurrentProject();
                String s = "<html><head><title>";
                s = String.valueOf(s) + Messages.getString("FrameNeatwork.Topography_report");
                s = String.valueOf(s) + "</title></head><body>";
                s = String.valueOf(s) + "<h1>" + Messages.getString("FrameNeatwork.Topography_report0") + topo.getName() + "</h1>";
                s = String.valueOf(s) + "<h2>" + Messages.getString("FrameNeatwork.Node_List") + "</h2>";
                s = String.valueOf(s) + "<table BORDER CELLPADDING=0 CELLSPACING=0>";
                s = String.valueOf(s) + Messages.getString("FrameNeatwork.<tr><th>ID</th><th>Height</th><th>X</th><th>Y</th><th>Faucets</th><th>Nature</th></tr>");
                Iterator en = topo.getNodeIterator();
                while (en.hasNext()) {
                    n = (Node)en.next();
                    s = String.valueOf(s) + "<tr>";
                    s = String.valueOf(s) + "<td>" + ((Node)n).getName() + "</td>";
                    s = String.valueOf(s) + "<td>" + ((Node)n).getHeight() + "</td>";
                    s = String.valueOf(s) + "<td>" + ((Node)n).getCoordX() + "</td>";
                    s = String.valueOf(s) + "<td>" + ((Node)n).getCoordY() + "</td>";
                    s = String.valueOf(s) + "<td>" + ((Node)n).getNbTaps() + "</td>";
                    s = String.valueOf(s) + "<td>" + Node.getNameType(((Node)n).getType()) + "</td>";
                    s = String.valueOf(s) + "</tr>";
                }
                s = String.valueOf(s) + "</table>";
                s = String.valueOf(s) + "<h2>" + Messages.getString("FrameNeatwork.Arc_List") + "</h2>";
                s = String.valueOf(s) + "<table BORDER CELLPADDING=0 CELLSPACING=0>";
                s = String.valueOf(s) + Messages.getString("FrameNeatwork.<tr><th>Begin</th><th>End</th><th>Length</th></tr>");
                en = topo.getPipeIterator();
                while (en.hasNext()) {
                    n = (Pipe)en.next();
                    s = String.valueOf(s) + "<tr>";
                    s = String.valueOf(s) + "<td>" + ((Pipe)n).getBegin() + "</td>";
                    s = String.valueOf(s) + "<td>" + ((Pipe)n).getEnd() + "</td>";
                    s = String.valueOf(s) + "<td>" + ((Pipe)n).getLength() + "</td>";
                    s = String.valueOf(s) + "</tr>";
                }
                s = String.valueOf(s) + "</table>";
                s = String.valueOf(s) + "<h2>" + Messages.getString("FrameNeatwork.Summary") + Messages.getString("FrameNeatwork.</h2>");
                s = String.valueOf(s) + Messages.getString("FrameNeatwork.<B>Number_of_Nodes__</B>") + topo.getNbNodes() + "<UL>" + Messages.getString("FrameNeatwork.<LI>_<i>Branching_nodes__</i>") + topo.getNbNodes(1) + Messages.getString("FrameNeatwork.<LI>_<i>Faucet_nodes__</i>") + topo.getNbNodes(2) + Messages.getString("FrameNeatwork._(with__") + topo.getNbTotalTaps() + Messages.getString("FrameNeatwork._individual_faucets)_") + "</UL>" + Messages.getString("FrameNeatwork.<B>Total_height_change__</B>") + Tools.doubleFormat("#", topo.getTotalHeightChange()) + " m<BR><BR>" + Messages.getString("FrameNeatwork.<B>Number_of_Pipes__</B>") + topo.getNbPipes() + " <BR>" + Messages.getString("FrameNeatwork.<B>Total_length__</B>") + Tools.doubleFormat("#", topo.getTotalLength()) + " m ";
                s = String.valueOf(s) + "<p>" + new Date().toString() + "</p>";
                Tools.enregFich(s);
            }
        };
        Icon quickCheckIcon = null;
        this.quickCheckAction = new NeatworkAction(Messages.getString("FrameNeatwork.Quick_Check..."), quickCheckIcon, Messages.getString("FrameNeatwork.Quick_faucets_check"), 'U'){

            public void actionPerformed(ActionEvent e) {
                Topographie topo = (Topographie)FrameNeatwork.this.projectManager.getCurrentProject();
                QuickCheckDialog dialog = new QuickCheckDialog(FrameNeatwork.this, topo);
                ((Component)dialog).setVisible(true);
            }
        };
        Icon designParameterIcon = null;
        this.designParameterAction = new NeatworkAction(Messages.getString("FrameNeatwork.Design_Parameters..."), designParameterIcon, Messages.getString("FrameNeatwork.Design_Parameters"), 'U'){

            public void actionPerformed(ActionEvent e) {
                Design design = (Design)FrameNeatwork.this.projectManager.getCurrentProject();
                DesignParaDialog dialog = new DesignParaDialog(FrameNeatwork.this, design);
                ((Component)dialog).setVisible(true);
            }
        };
        Object designExtractTopoIcon = null;
        this.designExtractTopoAction = new NeatworkAction(Messages.getString("FrameNeatwork.Extract_topography"), designParameterIcon, Messages.getString("FrameNeatwork.Extract_topography"), 'U'){

            public void actionPerformed(ActionEvent e) {
                Design design = (Design)FrameNeatwork.this.projectManager.getCurrentProject();
                if (design.isATree()) {
                    Topographie project = new Topographie(design.getName(), design.extractTopoContent(), FrameNeatwork.this.properties);
                    project.setName(FrameNeatwork.this.projectManager.isAlreadyLoaded(project));
                    FrameNeatwork.this.projectManager.addProject(project);
                } else {
                    JOptionPane.showConfirmDialog(null, Messages.getString("FrameNeatwork.This_feature_is_not_valid_for_non-tree_design"));
                }
            }
        };
        Icon repordesignIcon = null;
        this.reportDesignAction = new NeatworkAction(Messages.getString("FrameNeatwork.Report_in_HTML..."), repordesignIcon, "", 'H'){

            public void actionPerformed(ActionEvent e) {
                Same n;
                Design dsg = (Design)FrameNeatwork.this.projectManager.getCurrentProject();
                String s = "<html><head><title>";
                s = String.valueOf(s) + Messages.getString("FrameNeatwork.Design_report");
                s = String.valueOf(s) + "</title></head><body>";
                s = String.valueOf(s) + "<h1>" + Messages.getString("FrameNeatwork.Design_report0") + dsg.getName() + "</h1>";
                s = String.valueOf(s) + "<h2>" + Messages.getString("FrameNeatwork.Node_List") + "</h2>";
                s = String.valueOf(s) + "<table BORDER CELLPADDING=0 CELLSPACING=0>";
                s = String.valueOf(s) + Messages.getString("FrameNeatwork.<tr><th>ID</th><th>Height</th><th>X</th><th>Y</th><th>Ideal_Orifice</th><th>Commercial_Orifice</th><th>Nature</th></tr>");
                Iterator en = dsg.getNodeIterator();
                while (en.hasNext()) {
                    n = (Node)en.next();
                    s = String.valueOf(s) + "<tr>";
                    s = String.valueOf(s) + "<td>" + ((Node)n).getName() + "</td>";
                    s = String.valueOf(s) + "<td>" + ((Node)n).getHeight() + "</td>";
                    s = String.valueOf(s) + "<td>" + ((Node)n).getCoordX() + "</td>";
                    s = String.valueOf(s) + "<td>" + ((Node)n).getCoordY() + "</td>";
                    s = String.valueOf(s) + "<td>" + ((Node)n).getOrifice() + "</td>";
                    s = String.valueOf(s) + "<td>" + ((Node)n).getComercialOrifice() + "</td>";
                    s = String.valueOf(s) + "<td>" + Node.getNameType(((Node)n).getType()) + "</td>";
                    s = String.valueOf(s) + "</tr>";
                }
                s = String.valueOf(s) + "</table>";
                s = String.valueOf(s) + "<h2>" + Messages.getString("FrameNeatwork.Arc_List") + "</h2>";
                s = String.valueOf(s) + "<table BORDER CELLPADDING=0 CELLSPACING=0>";
                s = String.valueOf(s) + Messages.getString("FrameNeatwork.<tr><th>Begin</th><th>End</th><th>Length</th><th>Length1</th><th>Diam1</th><th>Length2</th><th>Diam2</th></tr>");
                en = dsg.getPipeIterator();
                while (en.hasNext()) {
                    n = (Pipe)en.next();
                    s = String.valueOf(s) + "<tr>";
                    s = String.valueOf(s) + "<td>" + ((Pipe)n).getBegin() + "</td>";
                    s = String.valueOf(s) + "<td>" + ((Pipe)n).getEnd() + "</td>";
                    s = String.valueOf(s) + "<td>" + ((Pipe)n).getLength() + "</td>";
                    s = String.valueOf(s) + "<td>" + ((Pipe)n).getLength1() + "</td>";
                    s = String.valueOf(s) + "<td>" + ((Pipe)n).getRefDiam1() + "</td>";
                    s = String.valueOf(s) + "<td>" + ((Pipe)n).getLength2() + "</td>";
                    s = String.valueOf(s) + "<td>" + ((Pipe)n).getRefDiam2() + "</td>";
                    s = String.valueOf(s) + "</tr>";
                }
                s = String.valueOf(s) + "</table>";
                Hashtable usedlength = dsg.getSummary();
                s = String.valueOf(s) + "<h2>" + Messages.getString("FrameNeatwork.Diameter_references") + "</h2>";
                s = String.valueOf(s) + "<table BORDER CELLPADDING=0 CELLSPACING=0>";
                s = String.valueOf(s) + Messages.getString("FrameNeatwork.<tr><th>Ref</th><th>Nominal</th><th>SDR</th><th>Internal_Diameter</th><th>Unit_cost</th>") + Messages.getString("FrameNeatwork.<th>Max_Pressure</th><th>Type</th><th>Roughness</th>") + Messages.getString("FrameNeatwork.<th>Total_length</th><th>Total_cost</th></tr>");
                Vector v = new Vector(dsg.getDiamTable().keySet());
                Collections.sort(v);
                Enumeration<Object> en2 = v.elements();
                while (en2.hasMoreElements()) {
                    String k = en2.nextElement().toString();
                    Diameter d = (Diameter)dsg.getDiamTable().get(k);
                    double l = usedlength.get(k) == null ? 0.0 : Double.parseDouble(usedlength.get(k).toString());
                    s = String.valueOf(s) + "<tr>";
                    s = String.valueOf(s) + "<td>" + k + "</td>";
                    s = String.valueOf(s) + "<td>" + d.getNominal() + "</td>";
                    s = String.valueOf(s) + "<td>" + d.getSdr() + "</td>";
                    s = String.valueOf(s) + "<td>" + d.getDiameter() + "</td>";
                    s = String.valueOf(s) + "<td>" + Tools.doubleFormat("0.##", d.getCost()) + "</td>";
                    s = String.valueOf(s) + "<td>" + d.getMaxLength() + "</td>";
                    s = String.valueOf(s) + "<td>" + d.getType() + "</td>";
                    s = String.valueOf(s) + "<td>" + d.getRoughness() + "</td>";
                    s = String.valueOf(s) + "<td>" + l + "</td>";
                    s = String.valueOf(s) + "<td>" + l * d.getCost() + "</td>";
                    s = String.valueOf(s) + "</tr>";
                }
                s = String.valueOf(s) + "</table>";
                if (dsg.getOrifices().size() > 0) {
                    s = String.valueOf(s) + "<h2>" + Messages.getString("FrameNeatwork.Available_orifices") + "</h2>";
                    s = String.valueOf(s) + "<table BORDER CELLPADDING=0 CELLSPACING=0>";
                    s = String.valueOf(s) + Messages.getString("FrameNeatwork.<tr><th>Diameter</th></tr>");
                    en2 = dsg.getOrifices().elements();
                    while (en2.hasMoreElements()) {
                        s = String.valueOf(s) + "<tr>";
                        s = String.valueOf(s) + "<td>" + en2.nextElement().toString() + "</td>";
                        s = String.valueOf(s) + "</tr>";
                    }
                    s = String.valueOf(s) + "</table>";
                }
                s = String.valueOf(s) + "<h2>" + Messages.getString("FrameNeatwork.Summary") + "</h2>";
                s = String.valueOf(s) + "<h3>" + Messages.getString("FrameNeatwork.Project_cost") + Tools.doubleFormat("0", dsg.getCost()) + "</h3>";
                Properties p = dsg.getProperties();
                s = String.valueOf(s) + "<h3>" + Messages.getString("FrameNeatwork.Global_Parameter") + "</h3>";
                s = String.valueOf(s) + Messages.getString("topo.watertemp.name") + " : " + p.getProperty("topo.watertemp.value") + "<br>";
                s = String.valueOf(s) + Messages.getString("topo.pipelength.name") + " : " + p.getProperty("topo.pipelength.value") + "<br>";
                s = String.valueOf(s) + "<h3>Design Parameter</h3>";
                s = String.valueOf(s) + Messages.getString("topo.opentaps.name") + " : " + p.getProperty("topo.opentaps.value") + "<br>";
                s = String.valueOf(s) + Messages.getString("topo.servicequal.name") + " : " + p.getProperty("topo.servicequal.value") + "<br>";
                s = String.valueOf(s) + Messages.getString("topo.targetflow.name") + " : " + p.getProperty("topo.targetflow.value") + "<br>";
                s = String.valueOf(s) + Messages.getString("topo.limitbudget.name") + " : " + p.getProperty("topo.limitbudget.value") + "<br>";
                s = String.valueOf(s) + "<h3>" + Messages.getString("FrameNeatwork.Advanced_Parameter") + "</h3>";
                s = String.valueOf(s) + Messages.getString("topo.orifcoef.name") + " : " + p.getProperty("topo.orifcoef.value") + "<br>";
                s = String.valueOf(s) + Messages.getString("topo.faucetcoef.name") + " : " + p.getProperty("topo.faucetcoef.value") + "<br>";
                s = String.valueOf(s) + "<h3>" + Messages.getString("FrameNeatwork.Structure") + "</h3>";
                s = String.valueOf(s) + Messages.getString("FrameNeatwork.<B>Number_of_Nodes__</B>") + dsg.getNbNodes() + Messages.getString("FrameNeatwork.<UL>_270") + Messages.getString("FrameNeatwork.<LI>_<i>Branching_nodes__</i>") + dsg.getNbNodes(1) + Messages.getString("FrameNeatwork.<LI>_<i>Faucet_nodes__</i>") + dsg.getNbNodes(2) + Messages.getString("FrameNeatwork._(with") + dsg.getNbTotalTaps() + " " + Messages.getString("FrameNeatwork._individual_faucets)") + "</UL>" + Messages.getString("FrameNeatwork.<B>Total_height_change__</B>") + Tools.doubleFormat("#", dsg.getTotalHeightChange()) + " m<BR><BR>" + Messages.getString("FrameNeatwork.<B>Number_of_Pipes__</B>") + dsg.getNbPipes() + " <BR>" + Messages.getString("FrameNeatwork.<B>Total_length__</B>") + Tools.doubleFormat("#", dsg.getTotalLength()) + " m ";
                s = String.valueOf(s) + "<p>" + new Date().toString() + "</p>";
                Tools.enregFich(s);
            }
        };
        Object designLoadFactorIcon = null;
        this.designLoadFactorAction = new NeatworkAction(Messages.getString("FrameNeatwork.Design_Load_Factors..."), designParameterIcon, Messages.getString("FrameNeatwork.Design_Load_Factors"), 'U'){

            public void actionPerformed(ActionEvent e) {
                Design design = (Design)FrameNeatwork.this.projectManager.getCurrentProject();
                DesignLoadFactorDialog dialog = new DesignLoadFactorDialog(FrameNeatwork.this, design);
                ((Component)dialog).setVisible(true);
            }
        };
    }

    private void defineMenu() {
        boolean standalone = this.properties.getProperty("appli.standalone").equals("true");
        this.menuBar = new JMenuBar();
        this.fileMenu = new JMenu(Messages.getString("FrameNeatwork.File"));
        this.fileMenu.setMnemonic('F');
        this.fileMenu.add(this.newTopoAction).setIcon(null);
        this.fileMenu.addSeparator();
        this.fileMenu.add(this.openTopoAction).setIcon(null);
        this.fileMenu.add(this.openDesignAction).setIcon(null);
        this.fileMenu.addSeparator();
        this.fileMenu.add(this.closeAction).setIcon(null);
        this.fileMenu.add(this.closeAllAction).setIcon(null);
        this.fileMenu.addSeparator();
        this.fileMenu.add(this.saveAction).setIcon(null);
        this.fileMenu.add(this.saveAsAction).setIcon(null);
        this.fileMenu.addSeparator();
        this.fileMenu.add(this.deleteTopoAction).setIcon(null);
        this.fileMenu.add(this.deleteDesignAction).setIcon(null);
        this.fileMenu.addSeparator();
        this.fileMenu.add(this.exitAction).setIcon(null);
        if (!standalone) {
            this.exitAction.putValue("ShortDescription", Messages.getString("FrameNeatwork.Hide"));
        }
        this.saveAsAction.setEnabled(false);
        this.saveAction.setEnabled(false);
        this.closeAction.setEnabled(false);
        this.topographyMenu = new JMenu(Messages.getString("FrameNeatwork.Topography"));
        this.topographyMenu.setVisible(false);
        this.topographyMenu.setMnemonic('T');
        this.topographyMenu.add(this.quickCheckAction).setIcon(null);
        this.topographyMenu.add(this.topoStatAction).setIcon(null);
        if (standalone) {
            this.topographyMenu.add(this.reportTopoAction).setIcon(null);
        }
        this.topographyMenu.addSeparator();
        this.topographyMenu.add(this.makeDesignAction).setIcon(null);
        this.designMenu = new JMenu(Messages.getString("FrameNeatwork.Design"));
        this.designMenu.setVisible(false);
        this.designMenu.setMnemonic('D');
        this.designMenu.add(this.designExtractTopoAction).setIcon(null);
        if (standalone) {
            this.designMenu.add(this.reportDesignAction).setIcon(null);
        }
        this.designMenu.addSeparator();
        this.designMenu.add(this.designParameterAction).setIcon(null);
        this.designMenu.add(this.designLoadFactorAction).setIcon(null);
        this.databaseMenu = new JMenu(Messages.getString("FrameNeatwork.Database"));
        this.databaseMenu.setMnemonic('O');
        this.databaseMenu.add(this.databaseAction).setIcon(null);
        this.langMenu = new JMenu(Messages.getString("FrameNeatwork.Language"));
        ButtonGroup group = new ButtonGroup();
        JRadioButtonMenuItem[] langItem = new JRadioButtonMenuItem[this.langList.length];
        int i = 0;
        while (i < langItem.length) {
            langItem[i] = new JRadioButtonMenuItem();
            LocaleAction a = new LocaleAction(this.langcode[i], this);
            langItem[i].setAction(a);
            a.putValue("Name", this.langList[i]);
            langItem[i].setSelected(false);
            group.add(langItem[i]);
            if (this.properties.getProperty("appli.locale", "null").equals(this.langcode[i])) {
                langItem[i].setSelected(true);
            }
            this.langMenu.add(langItem[i]);
            ++i;
        }
        this.helpMenu = new JMenu(Messages.getString("FrameNeatwork.Help"));
        this.helpMenu.setMnemonic('H');
        this.helpMenu.add(this.unitAction);
        this.helpMenu.add(this.langMenu);
        this.helpMenu.add(this.aboutAction);
        this.menuBar.add(this.fileMenu);
        this.menuBar.add(this.topographyMenu);
        this.menuBar.add(this.designMenu);
        this.menuBar.add(this.databaseMenu);
        this.menuBar.add(this.helpMenu);
        this.setJMenuBar(this.menuBar);
    }

    private void exitApplication() {
        boolean allFramesClosed = false;
        if (JOptionPane.showConfirmDialog(null, Messages.getString("FrameNeatwork.Do_you_really_want_to_quit"), Messages.getString("FrameNeatwork.Confirmation_Dialog"), 0) == 0) {
            allFramesClosed = true;
        }
        if (allFramesClosed) {
            if (this.properties.getProperty("appli.standalone").equals("true")) {
                System.exit(0);
            } else {
                ((Component)this).setVisible(false);
            }
        }
    }

    public void runMakeDesign(MakeDesignDialog dialog) {
        AbstractSolver solver = null;
        solver = this.properties.getProperty("solver.distant").equals("true") ? new SolverClient(this.properties) : new SolverDisk();
        solver.init();
        ThreadMakeDesign thread = new ThreadMakeDesign(dialog, solver);
        SolverProgressDialog solverDialog = new SolverProgressDialog(solver, thread);
        ((Component)solverDialog).setVisible(true);
        Vector resultNodePressure = solver.getNodePressureMakeDesign();
        boolean isOk = false;
        if (resultNodePressure != null) {
            Vector line = (Vector)resultNodePressure.get(1);
            try {
                Double d = new Double(line.get(2).toString());
                isOk = true;
            }
            catch (NumberFormatException d) {
                // empty catch block
            }
        }
        if (!isOk) {
            JOptionPane.showMessageDialog(this, Messages.getString("FrameNeatwork.there_is_no_feasible_solution__!"), Messages.getString("FrameNeatwork.Optimization_warning"), 1);
        } else {
            NodeTapPressureDialog dialog2 = new NodeTapPressureDialog(resultNodePressure, this);
            ((Component)dialog2).setVisible(true);
            Design design = new Design(dialog.getTopographie().getName(), solver.getDesignContentMakeDesign(), this.properties);
            design.setName(this.fileManager.getFirstNameCompatible(design));
            design.setName(this.projectManager.isAlreadyLoaded(design));
            design.setProperties(dialog.getTopographie().getProperties());
            design.setLoadFactorTable(dialog.getLoadFactors());
            this.projectManager.addProject(design);
        }
    }

    public void update(Observable observable, Object param) {
        int choix;
        if (observable.getClass().isInstance(this.projectManager)) {
            choix = (Integer)param;
            switch (choix) {
                case 3: {
                    this.saveAction.setEnabled(this.projectManager.getIndex() > -1);
                    this.saveAsAction.setEnabled(this.projectManager.getIndex() > -1);
                    this.closeAction.setEnabled(this.projectManager.getNbProject() > 0);
                    this.closeAllAction.setEnabled(this.projectManager.getNbProject() > 1);
                    Project p = this.projectManager.getCurrentProject();
                    if (p == null) break;
                    this.makeDesignAction.setEnabled(p.getType() == 0);
                    this.quickCheckAction.setEnabled(p.getType() == 0);
                    this.topographyMenu.setVisible(p.getType() == 0);
                    this.designParameterAction.setEnabled(p.getType() == 1);
                    this.designMenu.setVisible(p.getType() == 1);
                }
            }
        }
        if (observable.getClass().isInstance(this.database)) {
            choix = (Integer)param;
            switch (choix) {
                case 0: {
                    ListIterator iter = this.projectManager.getProjectIterator();
                    while (iter.hasNext()) {
                        Project item = (Project)iter.next();
                        if (item.getType() != 1) continue;
                        ((Design)item).refreshDesign(this.database);
                    }
                    break;
                }
            }
        }
    }

    public void run() {
    }

    public void itemStateChanged(ItemEvent e) {
        boolean i = false;
        if (e.getItem().equals(this.menuItemSolverLocal) || e.getItem().equals(this.menuItemSolverLocal)) {
            this.properties.setProperty("solver.distant", this.menuItemSolverLocal.isSelected() ? "false" : "true");
        }
    }
}

