/*
 * Decompiled with CFR 0.152.
 */
package neatwork.gui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.util.Arrays;
import java.util.Observable;
import java.util.Observer;
import java.util.Properties;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.DefaultListSelectionModel;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import neatwork.Messages;
import neatwork.file.AbstractFileManager;
import neatwork.file.FileManagerDisk;
import neatwork.utils.NeatworkAction;

public class FileManagerDialog
extends JDialog
implements Observer,
ListSelectionListener,
DocumentListener,
ActionListener {
    public static final int TYPEDIALOG_OPEN = 0;
    public static final int TYPEDIALOG_SAVE = 1;
    public static final int TYPEDIALOG_DELETE = 2;
    public static final int TYPEDIALOG_NEW = 3;
    private AbstractFileManager fileManager;
    private JFrame frame;
    private Properties properties;
    private int typeDialog;
    private int typeFile;
    private String content;
    private Action newFile;
    private Action openFile;
    private Action saveFile;
    private Action deleteFile;
    private Action cancel;
    private boolean cancelled = true;
    private Box box;
    private JPanel jPanel1 = new JPanel();
    private JPanel jPanel2 = new JPanel();
    private JPanel jPanel3 = new JPanel();
    private JPanel jPanel4 = new JPanel();
    private JButton jButton1 = new JButton();
    private JButton jButton2 = new JButton();
    private JButton jButtonPath = new JButton(Messages.getString("FileManagerDialog.Select"));
    private JButton jButtonUser = new JButton(Messages.getString("FileManagerDialog.User0"));
    private JLabel jLabel1 = new JLabel(Messages.getString("FileManagerDialog.Filename"));
    private JLabel jLabel = new JLabel();
    private JLabel jLabelPath = new JLabel();
    private JLabel jLabelStatus = new JLabel(" ");
    private JList jList = new JList();
    private JTextField jTextField = new JTextField();

    public FileManagerDialog(JFrame frame, AbstractFileManager fileManager, Properties properties) {
        super((Frame)frame, true);
        this.fileManager = fileManager;
        this.frame = frame;
        this.properties = properties;
        fileManager.addObserver(this);
        Container content = this.getContentPane();
        content.setLayout(new BorderLayout(5, 5));
        JPanel paneltop = new JPanel(new BorderLayout());
        paneltop.add((Component)this.jLabel, "South");
        if (properties.getProperty("file.distant").equals("false")) {
            paneltop.add((Component)new JLabel(Messages.getString("FileManagerDialog.Project_Path")), "West");
            this.jLabelPath.setText(((FileManagerDisk)fileManager).getProjectPath());
            this.jLabelPath.setAutoscrolls(true);
            this.jLabelPath.setForeground(Color.black);
            paneltop.add((Component)this.jLabelPath, "Center");
            paneltop.add((Component)this.jButtonPath, "East");
            this.jButtonPath.addActionListener(this);
        } else {
            paneltop.add((Component)new JLabel(Messages.getString("FileManagerDialog.User")), "West");
            JLabel lbl = new JLabel(properties.getProperty("appli.user"));
            lbl.setForeground(Color.black);
            paneltop.add((Component)lbl, "Center");
            paneltop.add((Component)this.jButtonUser, "East");
            this.jButtonUser.addActionListener(this);
        }
        this.jPanel1.setLayout(new BorderLayout());
        this.box = Box.createHorizontalBox();
        this.box.add(this.jButton1);
        this.box.add(Box.createHorizontalStrut(10));
        this.box.add(this.jButton2);
        this.jPanel1.add((Component)this.box, "East");
        this.jPanel1.add((Component)this.jLabelStatus, "South");
        this.jPanel2.setLayout(new BorderLayout());
        this.jLabel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.jPanel3.setLayout(new BorderLayout(5, 5));
        this.jPanel3.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.jPanel3.add((Component)this.jLabel1, "West");
        this.jPanel3.add((Component)this.jTextField, "Center");
        this.jPanel3.add((Component)this.jPanel1, "South");
        this.jPanel2.add((Component)this.jPanel3, "South");
        this.jPanel4.setLayout(new BorderLayout());
        this.jPanel4.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        this.jPanel4.add((Component)new JScrollPane(this.jList), "Center");
        this.jPanel4.add((Component)paneltop, "North");
        this.jPanel2.add((Component)this.jPanel4, "Center");
        content.add((Component)this.jPanel2, "Center");
        ((Component)this).setSize(400, 400);
        Dimension d = Toolkit.getDefaultToolkit().getScreenSize();
        ((Component)this).setLocation((d.width - this.getSize().width) / 2, (d.height - this.getSize().height) / 2);
        this.jButton1.setDefaultCapable(true);
        DefaultListSelectionModel listSelectionModel = new DefaultListSelectionModel();
        listSelectionModel.addListSelectionListener(this);
        this.jList.setSelectionModel(listSelectionModel);
        this.jTextField.getDocument().addDocumentListener(this);
        this.jTextField.setActionCommand("ENTER");
        this.jTextField.addActionListener(this);
        this.openFile = new NeatworkAction(Messages.getString("FileManagerDialog.Open"), null, Messages.getString("FileManagerDialog.Open_the_selected_file"), 'O'){

            public void actionPerformed(ActionEvent e) {
                if (!FileManagerDialog.this.jTextField.getText().equals("")) {
                    FileManagerDialog.this.setContent(FileManagerDialog.this.getFileManager().readFile(FileManagerDialog.this.getFileName(), FileManagerDialog.this.typeFile));
                    FileManagerDialog.this.setCancelled(false);
                    ((Component)FileManagerDialog.this).setVisible(false);
                }
            }
        };
        this.newFile = new NeatworkAction(Messages.getString("FileManagerDialog.New"), null, Messages.getString("FileManagerDialog.Create_a_new_topography"), 'N'){

            public void actionPerformed(ActionEvent e) {
                if (!FileManagerDialog.this.jTextField.getText().equals("")) {
                    boolean ok = true;
                    if (FileManagerDialog.this.isInList(FileManagerDialog.this.jTextField.getText())) {
                        Object[] options = new Object[]{Messages.getString("FileManagerDialog.Yes"), Messages.getString("FileManagerDialog.No")};
                        if (JOptionPane.showOptionDialog(null, String.valueOf(Messages.getString("FileManagerDialog.This_file_already_exists._It_will_be_overwritten_if_you_click_on_Yes.")) + Messages.getString("FileManagerDialog.Click_no_to_abort."), Messages.getString("FileManagerDialog.Existing_File..."), 0, 2, null, options, options[0]) == 1) {
                            ok = false;
                        }
                    }
                    if (ok) {
                        FileManagerDialog.this.setContent("");
                        FileManagerDialog.this.setCancelled(false);
                        ((Component)FileManagerDialog.this).setVisible(false);
                    }
                }
            }
        };
        this.saveFile = new NeatworkAction(Messages.getString("FileManagerDialog.Save"), null, Messages.getString("FileManagerDialog.Save_your_file"), 'O'){

            public void actionPerformed(ActionEvent e) {
                if (!FileManagerDialog.this.jTextField.getText().equals("")) {
                    Object[] options = new Object[]{Messages.getString("FileManagerDialog.Yes"), Messages.getString("FileManagerDialog.No")};
                    if (!FileManagerDialog.this.isInList(FileManagerDialog.this.jTextField.getText()) || JOptionPane.showOptionDialog(null, String.valueOf(Messages.getString("FileManagerDialog.The_file")) + FileManagerDialog.this.jTextField.getText() + Messages.getString("FileManagerDialog._exists._Do_you_wish_to_overwrite_it"), Messages.getString("FileManagerDialog.Overwrite_File"), 0, 2, null, options, options[1]) == 0) {
                        FileManagerDialog.this.getFileManager().deleteFile(FileManagerDialog.this.jTextField.getText(), FileManagerDialog.this.typeFile);
                        if (FileManagerDialog.this.getFileManager().writeFile(FileManagerDialog.this.jTextField.getText(), FileManagerDialog.this.getContent(), FileManagerDialog.this.typeFile)) {
                            FileManagerDialog.this.setCancelled(false);
                            ((Component)FileManagerDialog.this).setVisible(false);
                        }
                    }
                }
            }
        };
        this.deleteFile = new NeatworkAction(Messages.getString("FileManagerDialog.Delete"), null, Messages.getString("FileManagerDialog.Delete_the_selected_file"), 'O'){

            public void actionPerformed(ActionEvent e) {
                if (!FileManagerDialog.this.jTextField.getText().equals("")) {
                    FileManagerDialog.this.getFileManager().deleteFile(FileManagerDialog.this.jList.getSelectedValue().toString(), FileManagerDialog.this.typeFile);
                    FileManagerDialog.this.setList();
                }
            }
        };
        this.cancel = new NeatworkAction(Messages.getString("FileManagerDialog.Cancel"), null, null, 'C'){

            public void actionPerformed(ActionEvent e) {
                FileManagerDialog.this.setCancelled(true);
                ((Component)FileManagerDialog.this).setVisible(false);
            }
        };
        this.jList.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    FileManagerDialog.this.jButton1.doClick();
                }
            }
        });
    }

    public void show(int typeDialog, int typeFile) {
        this.typeDialog = typeDialog;
        this.typeFile = typeFile;
        this.jLabelStatus.setText(" ");
        this.setCancelled(true);
        this.setTitle();
        this.setComponents();
        this.setList();
        this.textChanged(null);
        this.setModal(true);
        this.jTextField.setEditable(typeDialog != 0);
        ((Component)this).setVisible(true);
    }

    private void setTitle() {
        switch (this.typeDialog) {
            case 0: {
                this.setTitle(Messages.getString("FileManagerDialog.Open_a"));
                break;
            }
            case 3: {
                this.setTitle(Messages.getString("FileManagerDialog.New0"));
                break;
            }
            case 1: {
                this.setTitle(Messages.getString("FileManagerDialog.Save_a"));
                break;
            }
            case 2: {
                this.setTitle(Messages.getString("FileManagerDialog.Delete_a"));
            }
        }
        switch (this.typeFile) {
            case 1: {
                this.setTitle(String.valueOf(this.getTitle()) + Messages.getString("FileManagerDialog._design"));
                break;
            }
            case 0: {
                this.setTitle(String.valueOf(this.getTitle()) + Messages.getString("FileManagerDialog._topography"));
            }
        }
    }

    private void setComponents() {
        switch (this.typeDialog) {
            case 0: {
                this.jButton1.setAction(this.openFile);
                this.jButton2.setAction(this.cancel);
                break;
            }
            case 3: {
                this.jButton1.setAction(this.newFile);
                this.jButton2.setAction(this.cancel);
                break;
            }
            case 1: {
                this.jButton1.setAction(this.saveFile);
                this.jButton2.setAction(this.cancel);
                break;
            }
            case 2: {
                this.jButton1.setAction(this.deleteFile);
                this.jButton2.setAction(this.cancel);
                this.cancel.putValue("Name", Messages.getString("FileManagerDialog.Close"));
            }
        }
        switch (this.typeFile) {
            case 1: {
                this.jLabel.setText(Messages.getString("FileManagerDialog.List_of_your_designs"));
                break;
            }
            case 0: {
                this.jLabel.setText(Messages.getString("FileManagerDialog.List_of_your_topographies"));
            }
        }
    }

    private void setList() {
        this.jList.removeAll();
        Object[] fileList = this.fileManager.getListFile(this.typeFile);
        if (fileList != null) {
            Arrays.sort(fileList);
            this.jList.setListData(fileList);
        }
    }

    public boolean getCancelled() {
        return this.cancelled;
    }

    private void setCancelled(boolean cancel) {
        this.cancelled = cancel;
    }

    public String getFileName() {
        return this.jTextField.getText();
    }

    public void setFileName(String fileName) {
        this.jTextField.setText(fileName);
    }

    public void setContent(String content) {
        this.content = content;
    }

    public String getContent() {
        return this.content;
    }

    public void update(Observable observable, Object object) {
        if (this.fileManager.getFileManagerStatus().equals("")) {
            this.jLabelStatus.setText(" ");
        } else {
            this.jLabelStatus.setText(this.fileManager.getFileManagerStatus());
        }
    }

    public void valueChanged(ListSelectionEvent e) {
        if (this.jList.getSelectedIndex() > -1) {
            this.jTextField.setText(this.jList.getSelectedValue().toString());
        }
    }

    private void textChanged(DocumentEvent e) {
        boolean inList = this.isInList(this.jTextField.getText());
        this.jButton1.setEnabled(this.jTextField.getText().length() != 0);
    }

    private boolean isInList(String value) {
        boolean contains = false;
        int i = 0;
        while (i < this.jList.getModel().getSize()) {
            contains |= this.jList.getModel().getElementAt(i).toString().equals(value);
            ++i;
        }
        return contains;
    }

    private AbstractFileManager getFileManager() {
        return this.fileManager;
    }

    public void insertUpdate(DocumentEvent e) {
        this.textChanged(e);
    }

    public void removeUpdate(DocumentEvent e) {
        this.textChanged(e);
    }

    public void changedUpdate(DocumentEvent e) {
        this.textChanged(e);
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getActionCommand().equals("ENTER")) {
            this.jButton1.doClick();
        }
        if (e.getSource().equals(this.jButtonPath)) {
            JFileChooser fc = new JFileChooser(this.jLabelPath.getText());
            fc.setFileSelectionMode(1);
            fc.showDialog(this, Messages.getString("FileManagerDialog.Select"));
            File fich = fc.getSelectedFile();
            if (fich != null && fich.exists()) {
                ((FileManagerDisk)this.fileManager).setProjectPath(fich.getAbsolutePath());
                this.jLabelStatus.setText("");
                this.setList();
                this.setComponents();
            }
        }
        e.getSource().equals(this.jButtonUser);
    }
}

