/*
 * Decompiled with CFR 0.152.
 */
package neatwork.file;

import java.io.IOException;
import java.util.Enumeration;
import java.util.Properties;
import java.util.Vector;
import neatwork.file.AbstractFileManager;
import neatwork.file.FileManagerDisk;

public class FileManagerServer {
    static String defaultUser = "guest";
    AbstractFileManager fm;

    public Vector getListFile(String user, String type) throws Exception {
        this.fm = this.getFileManager();
        String[] fileList = this.fm.getListFile(Integer.parseInt(type));
        Vector<String> v = new Vector<String>();
        if (fileList != null) {
            int i = 0;
            while (i < fileList.length) {
                if (fileList[i].startsWith(String.valueOf(user) + "_")) {
                    v.add(fileList[i].substring(user.length() + 1));
                }
                ++i;
            }
        }
        if (!user.equalsIgnoreCase(defaultUser)) {
            Vector v2 = this.getListFile(defaultUser, type);
            Enumeration e = v2.elements();
            while (e.hasMoreElements()) {
                String s = e.nextElement().toString();
                if (v.contains(s)) continue;
                v.add(s);
            }
        }
        return v;
    }

    public String readFile(String user, String fileName, int type) {
        this.fm = this.getFileManager();
        String data = this.fm.readFile(String.valueOf(user) + "_" + fileName, type);
        if (data.equals("")) {
            data = this.fm.readFile(String.valueOf(defaultUser) + "_" + fileName, type);
        }
        return data;
    }

    public boolean writeFile(String user, String fileName, String content, int type) {
        this.fm = this.getFileManager();
        return this.fm.writeFile(String.valueOf(user) + "_" + fileName, content, type);
    }

    public boolean deleteFile(String user, String fileName, int type) {
        this.fm = this.getFileManager();
        return this.fm.deleteFile(String.valueOf(user) + "_" + fileName, type);
    }

    public String readDbFile(String user, String fileName) {
        this.fm = this.getFileManager();
        return this.fm.readDbFile(String.valueOf(user) + "_" + fileName);
    }

    public boolean writeDbFile(String user, String fileName, String content) {
        this.fm = this.getFileManager();
        return this.fm.writeDbFile(String.valueOf(user) + "_" + fileName, content);
    }

    private AbstractFileManager getFileManager() {
        Properties p = new Properties();
        try {
            p.load(this.getClass().getResourceAsStream("/neatwork/default.properties"));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        FileManagerDisk fm = new FileManagerDisk(p);
        return fm;
    }
}

