/*
 * Decompiled with CFR 0.152.
 */
package neatwork.file;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.Properties;
import java.util.StringTokenizer;
import neatwork.Messages;
import neatwork.file.AbstractFileManager;

public class FileManagerDisk
extends AbstractFileManager
implements FilenameFilter {
    private String appliPath;
    private String projectPath;
    private String databasePath;
    private String currentSuffix = "";
    private Properties properties;

    public FileManagerDisk(Properties properties) {
        this.properties = properties;
        this.appliPath = properties.getProperty("file.path");
        this.setPathes(this.appliPath);
    }

    public void setPathes(String rootPath) {
        this.properties.setProperty("file.path", rootPath);
        this.appliPath = this.properties.getProperty("file.path");
        this.projectPath = String.valueOf(this.appliPath) + System.getProperty("file.separator") + this.properties.getProperty("file.pathproject");
        this.databasePath = String.valueOf(this.appliPath) + System.getProperty("file.separator") + this.properties.getProperty("file.pathdb");
    }

    public void setProjectPath(String projectPath) {
        this.projectPath = projectPath;
    }

    public String getProjectPath() {
        return this.projectPath;
    }

    public String[] getListFile(int type) {
        this.makeDirectoryExists(this.projectPath);
        this.setCurrentSuffix(type);
        File f = new File(this.projectPath);
        String[] fileList = f.list(this);
        if (fileList == null) {
            this.setFileManagerStatus(Messages.getString("FileManagerDisk.No_project_directory_found"));
            return fileList;
        }
        int i = 0;
        while (i < fileList.length) {
            fileList[i] = fileList[i].substring(0, fileList[i].length() - 4);
            ++i;
        }
        if (fileList.length == 0) {
            this.setFileManagerStatus(Messages.getString("FileManagerDisk.No_files_found"));
        }
        return fileList;
    }

    public String readFile(String fileName, int type) {
        String data = "";
        this.setFileManagerStatus(Messages.getString("FileManagerDisk.Reading_file"));
        this.makeDirectoryExists(this.projectPath);
        this.setCurrentSuffix(type);
        fileName = String.valueOf(this.projectPath) + File.separator + fileName + this.currentSuffix;
        File file = new File(fileName);
        if (!file.exists()) {
            return "";
        }
        try {
            String line;
            FileReader fr = new FileReader(fileName);
            BufferedReader f = new BufferedReader(fr);
            while ((line = f.readLine()) != null) {
                data = String.valueOf(data) + line + "\n";
            }
            this.setFileManagerStatus(" ");
            fr.close();
        }
        catch (IOException e) {
            this.setFileManagerStatus("IO error : " + e.getMessage());
        }
        return data;
    }

    public boolean writeFile(String fileName, String content, int type) {
        this.setFileManagerStatus(Messages.getString("FileManagerDisk.Writing_file"));
        this.makeDirectoryExists(this.projectPath);
        this.setCurrentSuffix(type);
        fileName = String.valueOf(this.projectPath) + File.separator + fileName + this.currentSuffix;
        boolean isOk = false;
        try {
            BufferedWriter f = new BufferedWriter(new FileWriter(fileName));
            StringTokenizer st = new StringTokenizer(content, "\n\r");
            while (st.hasMoreTokens()) {
                f.write(st.nextToken());
                f.newLine();
            }
            f.flush();
            f.close();
            isOk = true;
            this.setFileManagerStatus(" ");
        }
        catch (IOException e) {
            this.setFileManagerStatus("IO error : " + e.getMessage());
        }
        return isOk;
    }

    public boolean deleteFile(String fileName, int type) {
        this.setFileManagerStatus(Messages.getString("FileManagerDisk.Deleting_file"));
        this.makeDirectoryExists(this.projectPath);
        this.setCurrentSuffix(type);
        String fileName0 = String.valueOf(this.projectPath) + File.separator + fileName + this.currentSuffix;
        File f = new File(fileName0);
        boolean isOk = f.delete();
        if (!isOk) {
            this.setFileManagerStatus(Messages.getString("FileManagerDisk.Can__t_delete_this_file"));
        } else {
            this.setFileManagerStatus(" ");
            if (type == 1) {
                String[] fsim = this.getListFile(2);
                int i = 0;
                while (i < fsim.length) {
                    if (fsim[i].startsWith(String.valueOf(fileName) + ".")) {
                        this.deleteFile(fsim[i], 2);
                    }
                    ++i;
                }
            }
        }
        return isOk;
    }

    public boolean accept(File dir, String name) {
        return name.endsWith(this.currentSuffix);
    }

    private void setCurrentSuffix(int type) {
        switch (type) {
            case 0: {
                this.currentSuffix = ".tpo";
                break;
            }
            case 1: {
                this.currentSuffix = ".dsg";
                break;
            }
            case 2: {
                this.currentSuffix = ".sim";
            }
        }
    }

    private void makeDirectoryExists(String path) {
        File f = new File(path);
        if (!f.exists() && !f.mkdirs()) {
            System.exit(-1);
        }
    }

    public String readDbFile(String fileName) {
        this.setFileManagerStatus(Messages.getString("FileManagerDisk.Reading_database_file"));
        this.makeDirectoryExists(this.databasePath);
        fileName = String.valueOf(this.databasePath) + File.separator + fileName;
        File file = new File(fileName);
        if (!file.exists()) {
            return "";
        }
        String data = "";
        try {
            String line;
            BufferedReader f = new BufferedReader(new FileReader(fileName));
            while ((line = f.readLine()) != null) {
                data = String.valueOf(data) + line + "\n";
            }
            this.setFileManagerStatus(" ");
        }
        catch (IOException e) {
            this.setFileManagerStatus("IO error : " + e.getMessage());
        }
        return data;
    }

    public boolean writeDbFile(String fileName, String content) {
        this.setFileManagerStatus(Messages.getString("FileManagerDisk.Writing_database_file"));
        this.makeDirectoryExists(this.databasePath);
        fileName = String.valueOf(this.databasePath) + File.separator + fileName;
        boolean isOk = false;
        try {
            BufferedWriter f = new BufferedWriter(new FileWriter(fileName));
            StringTokenizer st = new StringTokenizer(content, "\n\r");
            while (st.hasMoreTokens()) {
                f.write(st.nextToken());
                f.newLine();
            }
            f.flush();
            f.close();
            isOk = true;
            this.setFileManagerStatus(" ");
        }
        catch (IOException e) {
            this.setFileManagerStatus("IO error : " + e.getMessage());
        }
        return isOk;
    }
}

