/*
 * Decompiled with CFR 0.152.
 */
package neatwork.core.run;

import neatwork.core.defs.Nodes;
import neatwork.core.defs.NodesVector;
import neatwork.core.defs.Pipes;
import neatwork.core.defs.PipesVector;
import neatwork.core.defs.Taps;
import neatwork.core.defs.TapsVector;
import neatwork.solver.AbstractSolver;

public class RunSimulation {
    public PipesVector pvector;
    public PipesVector psubvector = new PipesVector();
    public NodesVector nvector;
    public NodesVector nsubvector = new NodesVector();
    public TapsVector tvector;
    public TapsVector tsubvector = new TapsVector();
    public double CoefOrif;
    public int NbDiam;
    public int NbPipes;
    public int NbNodes;
    public int NbTaps;
    public int n;
    public int m;
    public double[] Lower;
    public double[] Upper;
    public double[] F;
    public double[] y;
    public double[] Dual;
    public int[] Type;
    public double[] Cste;
    public boolean TypePb = true;

    public RunSimulation(double[] f, NodesVector nv, PipesVector pv, TapsVector tv, double outflow, double rate, double seuil, double seuil2, String operation, int index, double CoefOrif1) {
        this(f, nv, pv, tv, outflow, rate, seuil, seuil2, operation, index, CoefOrif1, null);
    }

    public RunSimulation(double[] f, NodesVector nv, PipesVector pv, TapsVector tv, double outflow, double rate, double seuil, double seuil2, String operation, int index, double CoefOrif1, AbstractSolver solver) {
        this.pvector = pv;
        this.nvector = nv;
        this.tvector = tv;
        this.F = f;
        this.CoefOrif = CoefOrif1;
        this.NbPipes = this.pvector.size();
        this.NbNodes = this.nvector.size();
        this.NbTaps = this.tvector.size();
        if (operation.equals("random")) {
            this.SelectTaps(rate);
            this.DoSubReseau();
            this.n = this.psubvector.size() + this.tsubvector.size() + 1;
            this.m = this.nsubvector.size();
            this.Resolution(outflow);
            this.TapsStatistic(seuil2, seuil, index);
        }
        if (operation.equals("tapbytap")) {
            int i = 0;
            while (i < this.tvector.size()) {
                solver.setProgress(Math.round((float)i / (float)this.tvector.size() * 100.0f));
                this.psubvector = new PipesVector();
                this.nsubvector = new NodesVector();
                this.tsubvector = new TapsVector();
                Taps taps = (Taps)this.tvector.elementAt(i);
                taps.select = "open";
                this.tsubvector.addTaps(taps);
                this.DoSubReseau();
                this.n = this.psubvector.size() + this.tsubvector.size() + 1;
                this.m = this.nsubvector.size();
                this.Resolution(outflow);
                this.TapsStatistic(seuil2, seuil, i);
                this.tsubvector.removeElementAt(0);
                ++i;
            }
        }
        if (operation.equals("handmade")) {
            int i = 0;
            while (i < this.tvector.size()) {
                Taps taps = (Taps)this.tvector.elementAt(i);
                if (taps.select.equals("open")) {
                    this.tsubvector.addTaps(taps);
                }
                ++i;
            }
            this.DoSubReseau();
            this.n = this.psubvector.size() + this.tsubvector.size() + 1;
            this.m = this.nsubvector.size();
            this.Resolution(outflow);
            this.TapsStatistic(seuil2, seuil, index);
        }
    }

    public void SelectTaps(double rate) {
        int NbPip = this.tvector.size();
        Taps taps = null;
        int i = 0;
        while (i < this.tvector.size()) {
            ((Taps)this.tvector.elementAt((int)i)).select = "close";
            ++i;
        }
        long NB = Math.round(Math.ceil((double)this.tvector.size() * rate));
        if (NB > (long)this.tvector.size()) {
            NB = this.tvector.size();
        }
        i = 0;
        while ((long)i < NB) {
            long index = Math.round(Math.random() * (double)NbPip + 0.5);
            --NbPip;
            int j = 0;
            int k = 0;
            while ((long)j < index) {
                taps = (Taps)this.tvector.elementAt(k);
                ++k;
                if (!taps.select.equals("close")) continue;
                ++j;
            }
            taps.select = "open";
            ++i;
        }
        i = 0;
        while (i < this.tvector.size()) {
            taps = (Taps)this.tvector.elementAt(i);
            if (taps.select.equals("open")) {
                this.tsubvector.addTaps(taps);
            }
            ++i;
        }
    }

    public void DoSubReseau() {
        Pipes pipes;
        Taps taps;
        Nodes nodes;
        int i = 0;
        while (i < this.NbNodes - this.NbTaps) {
            nodes = (Nodes)this.nvector.elementAt(i);
            this.nsubvector.addNodes(nodes);
            ++i;
        }
        i = this.NbNodes - this.NbTaps;
        while (i < this.NbNodes) {
            nodes = (Nodes)this.nvector.elementAt(i);
            taps = (Taps)this.tvector.elementAt(i - (this.NbNodes - this.NbTaps));
            if (this.tsubvector.contains(taps)) {
                this.nsubvector.addNodes(nodes);
            }
            ++i;
        }
        i = 0;
        while (i < this.NbPipes - this.NbTaps) {
            pipes = (Pipes)this.pvector.elementAt(i);
            this.psubvector.addPipes(pipes);
            ++i;
        }
        i = this.NbPipes - this.NbTaps;
        while (i < this.NbPipes) {
            pipes = (Pipes)this.pvector.elementAt(i);
            taps = (Taps)this.tvector.elementAt(i - (this.NbPipes - this.NbTaps));
            if (this.tsubvector.contains(taps)) {
                this.psubvector.addPipes(pipes);
            }
            ++i;
        }
    }

    public void Resolution(double outflow) {
        int i = 0;
        while (i < this.nsubvector.size()) {
            Nodes nodes = (Nodes)this.nsubvector.elementAt(i);
            this.psubvector.GetSuivPred(nodes);
            ++i;
        }
        int[] bkc = new int[this.m];
        double[] blc = new double[this.m];
        double[] buc = new double[this.m];
        double[] c = new double[this.n];
        int[] bkx = new int[this.n];
        double[] oprfo = new double[this.n - 1];
        double[] oprgo = new double[this.n - 1];
        double[] oprho = new double[this.n - 1];
        int[] opro = new int[this.n - 1];
        int[] oprjo = new int[this.n - 1];
        this.y = new double[this.m];
        this.Lower = new double[this.n];
        this.Upper = new double[this.n];
        this.Type = new int[this.m];
        this.Cste = new double[this.m];
        this.InitializeVariable(outflow);
        this.InitializeConstraints();
        double[] CstGradCoeff = new double[2 * this.psubvector.size() + 1 + this.tsubvector.size()];
        int[] CstGradIRow = new int[2 * this.psubvector.size() + 1 + this.tsubvector.size()];
        int[] CstGradIColumn = new int[this.n];
        int[] CstGradIColumn2 = new int[this.n];
        this.MatriceA(CstGradCoeff, CstGradIRow, CstGradIColumn, CstGradIColumn2);
        double[] PipesConst = new double[this.psubvector.size()];
        double[] TapsConst1 = new double[this.tsubvector.size()];
        double[] TapsConst2 = new double[this.tsubvector.size()];
        this.Cvector(PipesConst, TapsConst1, TapsConst2);
        int j = 0;
        while (j < this.psubvector.size()) {
            Pipes pipes = (Pipes)this.psubvector.elementAt(j);
            opro[j] = 3;
            oprjo[j] = j + 1;
            oprfo[j] = PipesConst[j];
            oprgo[j] = pipes.p1 + 1.0;
            oprho[j] = 0.0;
            ++j;
        }
        int L = 2 * this.psubvector.size() + 1 + this.tsubvector.size();
        Solver solver = new Solver();
        solver.mainnlp(this.m, this.n, L, this.psubvector.size(), bkc, blc, buc, bkx, CstGradIColumn, CstGradIColumn2, this.Lower, this.Upper, this.F, this.y, c, CstGradIRow, CstGradCoeff, PipesConst, TapsConst1, TapsConst2, oprfo, oprgo, oprho, opro, oprjo);
    }

    public double[] GetDual(double[] PipesConst, double[] TapsConst1, double[] TapsConst2) {
        double[] dual = new double[this.psubvector.size()];
        int i = this.psubvector.size() - this.tsubvector.size();
        while (i < this.psubvector.size()) {
            Pipes pipes = (Pipes)this.psubvector.elementAt(i);
            dual[i] = TapsConst1[i - this.psubvector.size() + this.tsubvector.size()] * 1000.0 + TapsConst2[i - this.psubvector.size() + this.tsubvector.size()] * 3.0 * Math.pow(this.F[1 + i], 2.0) * 1000.0;
            String n_end = pipes.nodes_end;
            while (this.psubvector.GetPred(n_end) != null) {
                String n_beg = this.psubvector.GetPred(n_end);
                int pos = this.psubvector.GetPosition(n_beg, n_end);
                pipes = (Pipes)this.pvector.elementAt(pos);
                dual[i] = dual[i] + Math.pow(this.F[pos + 1], pipes.p1) * (pipes.p1 + 1.0) * PipesConst[pos] * 1000.0;
                n_end = n_beg;
            }
            ++i;
        }
        return dual;
    }

    public void InitializeConstraints() {
        int i = 0;
        while (i < this.m) {
            this.Cste[i] = 0.0;
            ++i;
        }
    }

    public void InitializeVariable(double outflow) {
        int i = 0;
        while (i < this.n) {
            this.Lower[i] = 0.0;
            this.Upper[i] = (double)this.tsubvector.size() * outflow * 1000.0 * 100.0;
            ++i;
        }
    }

    public void Cvector(double[] PipesConst, double[] TapsConst1, double[] TapsConst2) {
        int i = 0;
        while (i < this.psubvector.size()) {
            Pipes pipes = (Pipes)this.psubvector.elementAt(i);
            PipesConst[i] = pipes.beta1 / (pipes.p1 + 1.0) * Math.pow(0.001, pipes.p1) * (pipes.l1 / Math.pow(pipes.d1, pipes.q1));
            ++i;
        }
        i = 0;
        while (i < this.tsubvector.size()) {
            Taps taps = (Taps)this.tsubvector.elementAt(i);
            Nodes nodes = (Nodes)this.nsubvector.elementAt(this.nsubvector.size() - this.tsubvector.size() + i);
            TapsConst1[i] = nodes.height;
            TapsConst2[i] = (1.0 / (3.0 * taps.faucetCoef) + Math.pow(this.CoefOrif, 4.0) / (3.0 * Math.pow(taps.orifice, 4.0))) * 1.0E-6;
            ++i;
        }
    }

    public void MatriceA(double[] CstGradCoeff, int[] CstGradIRow, int[] CstGradIColumn, int[] CstGradIColumn2) {
        int cpt1 = 1;
        CstGradCoeff[0] = 1.0;
        CstGradIRow[0] = 0;
        CstGradIColumn[0] = 0;
        int i = 1;
        while (i < this.psubvector.size() + 1) {
            CstGradIColumn[i] = cpt1;
            CstGradIColumn2[i - 1] = CstGradIColumn[i];
            Pipes pipes = (Pipes)this.psubvector.elementAt(i - 1);
            int j = 0;
            while (j < this.m) {
                Nodes nodes = (Nodes)this.nsubvector.elementAt(j);
                if (nodes.nodes.equalsIgnoreCase(pipes.nodes_beg)) {
                    CstGradCoeff[cpt1] = -1.0;
                    CstGradIRow[cpt1] = j;
                    ++cpt1;
                }
                if (nodes.nodes.equalsIgnoreCase(pipes.nodes_end)) {
                    CstGradCoeff[cpt1] = 1.0;
                    CstGradIRow[cpt1] = j;
                    ++cpt1;
                }
                ++j;
            }
            ++i;
        }
        i = this.psubvector.size() + 1;
        while (i < this.n) {
            CstGradIColumn[i] = cpt1;
            CstGradIColumn2[i - 1] = CstGradIColumn[i];
            CstGradCoeff[cpt1] = -1.0;
            CstGradIRow[cpt1] = this.m - this.tsubvector.size() + i - this.psubvector.size() - 1;
            ++cpt1;
            ++i;
        }
        CstGradIColumn2[this.n - 1] = cpt1;
    }

    public void TapsStatistic(double seuil2, double seuil, int index) {
        int number;
        int i = 0;
        while (i < this.nsubvector.size()) {
            Nodes nodes = (Nodes)this.nsubvector.elementAt(i);
            if (nodes.indexgrouptaps != 0) {
                number = this.nsubvector.GetNumberOfOpenGroupTaps(nodes.indexgrouptaps);
                nodes = this.nvector.GetNodes(nodes.indexgrouptaps, number);
                i = i + number - 1;
            }
            nodes.pressim[index] = -nodes.height - this.y[i];
            int ind = this.tsubvector.getIndex(nodes.nodes);
            if (ind != -1) {
                Taps taps = (Taps)this.tsubvector.elementAt(ind);
                nodes.pressim[index] = nodes.pressim[index] - Math.pow(this.F[this.psubvector.size() + 1 + ind] / 1000.0, 2.0) * (1.0 / taps.faucetCoef + Math.pow(this.CoefOrif / taps.orifice, 4.0));
            }
            ++i;
        }
        i = 0;
        while (i < this.psubvector.size()) {
            Pipes pipes = (Pipes)this.psubvector.elementAt(i);
            if (pipes.indexgrouptaps != 0) {
                number = this.psubvector.GetNumberOfOpenGroupTaps(pipes.indexgrouptaps);
                pipes = this.pvector.GetPipes(pipes.indexgrouptaps, number);
                i = i + number - 1;
            }
            ++pipes.nbsim;
            if (this.F[1 + i] < 0.005) {
                this.F[1 + i] = 0.0;
                ++pipes.failure;
            }
            pipes.simulation[index] = this.F[1 + i];
            pipes.moyenne = (pipes.moyenne * (double)(pipes.nbsim - 1) + this.F[1 + i]) / (double)pipes.nbsim;
            pipes.moyennec = (pipes.moyennec * (double)(pipes.nbsim - 1) + Math.pow(this.F[1 + i], 2.0)) / (double)pipes.nbsim;
            if (this.F[1 + i] < seuil) {
                pipes.seuil += 1.0;
            }
            if (this.F[1 + i] > seuil2) {
                pipes.seuil2 += 1.0;
            }
            if (this.F[1 + i] > pipes.max) {
                pipes.max = this.F[1 + i];
            }
            if (pipes.nbsim == 1) {
                pipes.min = this.F[1 + i];
            } else if (this.F[1 + i] < pipes.min) {
                pipes.min = this.F[1 + i];
            }
            ++i;
        }
    }
}

