/*
 * Decompiled with CFR 0.152.
 */
package neatwork.core.run;

import java.util.Collections;
import neatwork.core.defs.Diameters;
import neatwork.core.defs.DiametersVector;
import neatwork.core.defs.Nodes;
import neatwork.core.defs.NodesVector;
import neatwork.core.defs.Orifices;
import neatwork.core.defs.OrificesVector;
import neatwork.core.defs.Pipes;
import neatwork.core.defs.PipesVector;
import neatwork.core.defs.Taps;
import neatwork.core.defs.TapsVector;
import neatwork.core.run.Decoupe;

public class RunMakeDesign {
    public double CoefOrif;
    public int NbDiam;
    public int NbPipes;
    public int NbNodes;
    public int NbTaps;
    public int n;
    public int m;
    public double[] Cste;

    public RunMakeDesign(double[] x, NodesVector nvector, PipesVector pvector, TapsVector tvector, DiametersVector dvector, OrificesVector ovector, double[] LoadFactor, double outflow, double lcom, int n1, int m1, double PrixMax, double CoefOrif1) {
        this.NbDiam = dvector.size();
        this.NbPipes = pvector.size();
        this.NbNodes = nvector.size();
        this.NbTaps = tvector.size();
        this.n = n1;
        this.m = m1;
        this.CoefOrif = CoefOrif1;
        this.Cste = new double[this.m];
        int L = this.LengthTab(nvector);
        double[] ACoeff = new double[L];
        int[] AIRow = new int[L];
        int[] AIColumn = new int[this.NbDiam * this.NbPipes + this.NbNodes - 1];
        int[] AIColumn2 = new int[this.NbDiam * this.NbPipes + this.NbNodes - 1];
        int z = this.NbDiam * this.NbPipes + this.NbNodes - 1;
        this.MatriceA(ACoeff, AIRow, AIColumn, AIColumn2, pvector, nvector, dvector, LoadFactor, L, this.n);
        double[] c = this.Cvector(x, this.n, dvector, pvector);
        int[] bkx = new int[this.n];
        double[] blx = new double[this.n];
        double[] bux = new double[this.n];
        this.InitializeVariable(x, pvector, bkx, blx, bux, dvector, nvector, outflow);
        this.Resolution(x, nvector, pvector, dvector, tvector, outflow, PrixMax, ACoeff, AIRow, AIColumn, AIColumn2, L, c, bkx, blx, bux, lcom);
        Decoupe decoupe = new Decoupe(x, lcom, pvector.size(), dvector, pvector);
        double[] CstValue = this.CstValue2(x, this.n, this.m, nvector, pvector, dvector, tvector, LoadFactor, outflow);
        this.GestionOrificeParfait(x, nvector, pvector, dvector, ovector, LoadFactor, this.Cste, outflow, tvector, CstValue);
        if (ovector.size() > 0) {
            this.GestionOrificeCommercial(tvector, ovector, CstValue);
        }
        this.CstValue2(x, this.n, this.m, nvector, pvector, dvector, tvector, LoadFactor, outflow);
        this.GetSuction(x, nvector, dvector);
    }

    public void GetSuction(double[] x, NodesVector nvector, DiametersVector dvector) {
        int i = 1;
        while (i < nvector.size()) {
            Nodes nodes = (Nodes)nvector.elementAt(i);
            nodes.suction = x[i + dvector.size() * (nvector.size() - 1) - 1];
            ++i;
        }
    }

    public void GestionOrificeCommercial(TapsVector tvector, OrificesVector ovector, double[] CstValue) {
        double dmin = 1.0E-6;
        double dmax = 1.0;
        ovector.addDiameters(dmin);
        ovector.addDiameters(dmax);
        Collections.sort(ovector, new Orifices(0.0));
        int i = this.NbNodes - this.NbTaps - 1;
        while (i < this.NbNodes - 1) {
            Taps tap = (Taps)tvector.get(i - this.NbNodes + this.NbTaps + 1);
            double orif_sup = dmin;
            double orif_inf = dmin;
            int j = 0;
            while (j < ovector.size() && tap.orif_ideal > orif_sup) {
                orif_sup = ((Orifices)ovector.get((int)j)).diam;
                if (j > 0) {
                    orif_inf = ((Orifices)ovector.get((int)(j - 1))).diam;
                }
                ++j;
            }
            tap.orif_com = tap.orif_ideal >= Math.sqrt(2.0) * orif_inf ? orif_sup : (orif_inf * orif_sup <= tap.orif_ideal * tap.orif_ideal ? orif_sup : orif_inf);
            if (tap.orif_com == dmin) {
                tap.orif_com = 10000.0;
            }
            if (tap.orif_com == dmax) {
                tap.orif_com = 10000.0;
            }
            ++i;
        }
    }

    public void GestionOrificeParfait(double[] x, NodesVector nvector, PipesVector pvector, DiametersVector dvector, OrificesVector ovector, double[] LoadFactor, double[] Cste1, double outflow, TapsVector tvector, double[] CstValue) {
        double d = 0.0;
        int i = this.NbNodes - this.NbTaps - 1;
        while (i < this.NbNodes - 1) {
            if (Cste1[i] > CstValue[i]) {
                Taps taps = (Taps)tvector.elementAt(i - this.NbNodes + this.NbTaps + 1);
                taps.orif_ideal = d = Math.pow(Math.pow(this.CoefOrif, 4.0) * Math.pow(outflow, 2.0) / (Cste1[i] - CstValue[i] + Math.pow(this.CoefOrif / taps.orifice, 4.0) * Math.pow(outflow, 2.0)), 0.25);
                taps.orifice = d;
            }
            ++i;
        }
    }

    public void Resolution(double[] x, NodesVector nvector, PipesVector pvector, DiametersVector dvector, TapsVector tvector, double outflow, double PrixMax, double[] ACoeff, int[] AIRow, int[] AIColumn, int[] AIColumn2, int L, double[] c, int[] bkx, double[] blx, double[] bux, double lcom) {
        int[] bkc = new int[this.m];
        double[] blc = new double[this.m];
        this.InitializeConstraints(bkc, blc, nvector, pvector, tvector, outflow, PrixMax, lcom);
        Solver solver = null;
        try {
            solver = new Solver();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        solver.mainlp(this.NbNodes, this.m, this.n, L, bkc, blc, this.Cste, bkx, blx, bux, AIColumn, AIColumn2, AIRow, ACoeff, x, c);
    }

    public void MatriceA(double[] ACoeff, int[] AIRow, int[] AIColumn, int[] AIColumn2, PipesVector pvector, NodesVector nvector, DiametersVector dvector, double[] LoadFactor, int L, int n1) {
        Diameters diam = null;
        int I1 = 0;
        int I2 = 0;
        int I3 = 0;
        int IPipes = 0;
        while (IPipes < this.NbPipes) {
            int IDiam = 0;
            while (IDiam < this.NbDiam) {
                AIColumn[I3] = I1;
                if (I3 != 0) {
                    AIColumn2[I3 - 1] = AIColumn[I3];
                }
                Pipes pipes = (Pipes)pvector.elementAt(IPipes);
                int INodes = 1;
                while (INodes < this.NbNodes) {
                    Nodes nodes = (Nodes)nvector.elementAt(INodes);
                    int IPath = nodes.path.size() - 1;
                    while (IPath > 0) {
                        String n_beg = (String)nodes.path.elementAt(IPath);
                        String n_end = (String)nodes.path.elementAt(IPath - 1);
                        if (pipes.nodes_beg.equalsIgnoreCase(n_beg) && pipes.nodes_end.equalsIgnoreCase(n_end)) {
                            IPath = 0;
                            diam = (Diameters)dvector.elementAt(IDiam);
                            ACoeff[I1] = Math.pow(LoadFactor[IPipes], diam.p) / Math.pow(diam.diam, diam.q) * diam.beta;
                            AIRow[I2] = INodes - 1;
                            ++I1;
                            ++I2;
                            continue;
                        }
                        --IPath;
                    }
                    ++INodes;
                }
                ACoeff[I1] = 1.0;
                AIRow[I2] = this.NbNodes + IPipes - 1;
                ACoeff[++I1] = diam.cost;
                AIRow[++I2] = this.NbNodes + this.NbPipes - 1;
                ++I1;
                ++I2;
                ++I3;
                ++IDiam;
            }
            ++IPipes;
        }
        int i = L - this.NbNodes + 1;
        while (i < L) {
            AIColumn[I3] = I1;
            AIColumn2[I3 - 1] = AIColumn[I3];
            ACoeff[I1] = -1.0;
            AIRow[I2] = i - (L - this.NbNodes + 1);
            ++I1;
            ++I2;
            ++I3;
            ++i;
        }
        AIColumn2[n1 - 1] = L;
    }

    public int LengthTab(NodesVector nvector) {
        int L = 0;
        int i = 1;
        while (i < nvector.size()) {
            Nodes nodes = (Nodes)nvector.elementAt(i);
            L = L + nodes.path.size() - 1;
            ++i;
        }
        return (L + this.NbPipes) * this.NbDiam + this.NbNodes - 1 + this.NbDiam * this.NbPipes;
    }

    public void InitializeConstraints(int[] bkc, double[] blc, NodesVector nvector, PipesVector pvector, TapsVector tvector, double outflow, double PrixMax, double lcom) {
        Nodes nodes;
        int i = 0;
        while (i < this.NbNodes - this.NbTaps - 1) {
            nodes = (Nodes)nvector.elementAt(i + 1);
            this.Cste[i] = -nodes.height;
            bkc[i] = 1;
            blc[i] = -1.0E30;
            ++i;
        }
        i = this.NbNodes - this.NbTaps - 1;
        while (i < this.NbNodes - 1) {
            nodes = (Nodes)nvector.elementAt(i + 1);
            Taps taps = (Taps)tvector.elementAt(i - (this.NbNodes - this.NbTaps - 1));
            this.Cste[i] = taps.orifice == 10000.0 ? -nodes.height - outflow * outflow / taps.faucetCoef : -nodes.height - outflow * outflow * (1.0 / taps.faucetCoef + Math.pow(this.CoefOrif / taps.orifice, 4.0));
            bkc[i] = 1;
            blc[i] = -1.0E30;
            ++i;
        }
        i = this.NbNodes - 1;
        while (i < this.m - 1) {
            Pipes pipes = (Pipes)pvector.elementAt(i - this.NbNodes + 1);
            this.Cste[i] = pipes.length;
            bkc[i] = 2;
            blc[i] = this.Cste[i];
            ++i;
        }
        this.Cste[this.m - 1] = PrixMax;
        bkc[this.m - 1] = 1;
        blc[this.m - 1] = -1.0E30;
    }

    public void InitializeVariable(double[] x, PipesVector pvector, int[] bkx, double[] blx, double[] bux, DiametersVector dvector, NodesVector nvector, double outflow) {
        int i = 0;
        while (i < this.NbPipes) {
            Pipes pipes = (Pipes)pvector.elementAt(i);
            Nodes nodes = (Nodes)nvector.elementAt(nvector.getPosition(pipes.nodes_end));
            int j = 0;
            while (j < this.NbDiam) {
                Diameters diam = (Diameters)dvector.elementAt(j);
                blx[i * this.NbDiam + j] = 0.0;
                bkx[i * this.NbDiam + j] = 4;
                bux[i * this.NbDiam + j] = -nodes.height < diam.pression && diam.diam > pipes.imposdiammin && diam.diam < pipes.imposdiammax ? pipes.length : 0.0;
                if (pipes.imposdiam1 == diam.diam) {
                    bux[i * this.NbDiam + j] = pipes.imposlength1;
                    blx[i * this.NbDiam + j] = bux[i * this.NbDiam + j];
                }
                if (pipes.imposdiam2 == diam.diam) {
                    bux[i * this.NbDiam + j] = pipes.length - pipes.imposlength1;
                    blx[i * this.NbDiam + j] = bux[i * this.NbDiam + j];
                }
                ++j;
            }
            ++i;
        }
        i = this.NbPipes * this.NbDiam;
        while (i < this.NbPipes * this.NbDiam + this.NbNodes - 1) {
            bux[i] = 1.0E30;
            blx[i] = 0.0;
            bkx[i] = 0;
            ++i;
        }
    }

    public double[] CstValue2(double[] x, int n1, int m1, NodesVector nvector, PipesVector pvector, DiametersVector dvector, TapsVector tvector, double[] LoadFactor, double outflow) {
        Pipes pipes;
        String n_beg;
        String n_end;
        int j;
        Nodes nodes;
        double[] Cst = new double[m1];
        int i = 1;
        while (i < nvector.size() - tvector.size()) {
            Cst[i - 1] = 0.0;
            nodes = (Nodes)nvector.elementAt(i);
            j = 0;
            while (j < nodes.path.size() - 1) {
                n_end = (String)nodes.path.elementAt(j);
                n_beg = (String)nodes.path.elementAt(j + 1);
                pipes = (Pipes)pvector.elementAt(pvector.getPosition(n_end));
                Cst[i - 1] = Cst[i - 1] + pipes.l1 * Math.pow(LoadFactor[pvector.getPosition(n_end)], pipes.p1) / Math.pow(pipes.d1, pipes.q1) * pipes.beta1 + pipes.l2 * Math.pow(LoadFactor[pvector.getPosition(n_end)], pipes.p2) / Math.pow(pipes.d2, pipes.q2) * pipes.beta2;
                ++j;
            }
            nodes.pressure = Cst[i - 1];
            ++i;
        }
        i = nvector.size() - tvector.size();
        while (i < nvector.size()) {
            Cst[i - 1] = 0.0;
            nodes = (Nodes)nvector.elementAt(i);
            j = 0;
            while (j < nodes.path.size() - 1) {
                n_end = (String)nodes.path.elementAt(j);
                n_beg = (String)nodes.path.elementAt(j + 1);
                pipes = (Pipes)pvector.elementAt(pvector.getPosition(n_end));
                Cst[i - 1] = Cst[i - 1] + pipes.l1 * Math.pow(LoadFactor[pvector.getPosition(n_end)], pipes.p1) / Math.pow(pipes.d1, pipes.q1) * pipes.beta1 + pipes.l2 * Math.pow(LoadFactor[pvector.getPosition(n_end)], pipes.p2) / Math.pow(pipes.d2, pipes.q2) * pipes.beta2;
                ++j;
            }
            nodes.pressure = Cst[i - 1];
            ++i;
        }
        return Cst;
    }

    public double[] Cvector(double[] x, int n1, DiametersVector dvector, PipesVector pvector) {
        double[] grad = new double[n1];
        int j = 0;
        int i = 0;
        while (i < n1 - this.NbNodes + 1) {
            Diameters diam = (Diameters)dvector.elementAt(j);
            grad[i] = diam.cost;
            j = j < dvector.size() - 1 ? ++j : 0;
            ++i;
        }
        double CoeffM = this.CoeffM(pvector, dvector);
        int i2 = n1 - this.NbNodes + 1;
        while (i2 < n1) {
            grad[i2] = CoeffM;
            ++i2;
        }
        return grad;
    }

    public double CoeffM(PipesVector pvector, DiametersVector dvector) {
        double Coeff = 0.0;
        Diameters diam = (Diameters)dvector.lastElement();
        int i = 0;
        while (i < pvector.size()) {
            Pipes pipes = (Pipes)pvector.elementAt(i);
            Coeff += pipes.length;
            ++i;
        }
        return Coeff * diam.cost;
    }
}

