/*
 * Decompiled with CFR 0.152.
 */
package neatwork.core.defs;

import java.util.Vector;
import neatwork.core.defs.Nodes;
import neatwork.core.defs.NodesVector;
import neatwork.core.defs.Path;
import neatwork.core.defs.Pipes;

public class PipesVector
extends Vector {
    public void addPipes(Pipes p) {
        this.addElement(p);
    }

    public void UpDatePipes() {
        int i = 0;
        while (i < this.size()) {
            Pipes pipes = (Pipes)this.elementAt(i);
            pipes.moyenne = 0.0;
            pipes.moyennec = 0.0;
            pipes.max = 0.0;
            pipes.min = 0.0;
            pipes.nbsim = 0;
            pipes.seuil = 0.0;
            pipes.speed = 0.0;
            pipes.speedmax = 0.0;
            pipes.speedmin = 0.0;
            ++i;
        }
    }

    public void addPipes(String n_beg, String n_end, double l) {
        Pipes pipes = new Pipes(n_beg, n_end, n_beg, l);
        this.addPipes(pipes);
    }

    public String GetPred(String n) {
        int i = 0;
        boolean bool = false;
        String ret = null;
        while (i != this.size() && !bool) {
            Pipes pipes = (Pipes)this.elementAt(i);
            if (pipes.nodes_end.equalsIgnoreCase(n)) {
                bool = true;
                ret = pipes.nodes_beg;
            }
            ++i;
        }
        return ret;
    }

    public void initializeSimulation(int NbSim) {
        int i = 0;
        while (i < this.size()) {
            Pipes pipes = (Pipes)this.elementAt(i);
            pipes.simulation = new double[NbSim];
            ++i;
        }
        this.UpDatePipes();
    }

    public void getPath(String n, Path path, NodesVector nvector, int taps) {
        while (n != null) {
            path.addNodes(n);
            if (taps == 1) {
                int i = 0;
                Nodes nodes = (Nodes)nvector.elementAt(i);
                while (!nodes.nodes.equalsIgnoreCase(n)) {
                    nodes = (Nodes)nvector.elementAt(++i);
                }
                ++nodes.nbTaps;
            }
            n = this.GetPred(n);
        }
    }

    public int getPosition(String n_end) {
        int i = 0;
        Pipes pipes = (Pipes)this.elementAt(0);
        while (!pipes.nodes_end.equalsIgnoreCase(n_end)) {
            pipes = (Pipes)this.elementAt(++i);
        }
        return i;
    }

    public int GetPosition(String n_beg, String n_end) {
        int i = 0;
        Pipes pipes = (Pipes)this.elementAt(0);
        while (!pipes.nodes_end.equalsIgnoreCase(n_end) || !pipes.nodes_beg.equalsIgnoreCase(n_beg)) {
            pipes = (Pipes)this.elementAt(++i);
        }
        return i;
    }

    public int GetNumberOfOpenGroupTaps(int indexgrouptaps) {
        int number = 0;
        int i = 0;
        while (i < this.size()) {
            Pipes pipes = (Pipes)this.elementAt(i);
            if (pipes.indexgrouptaps == indexgrouptaps) {
                ++number;
            }
            ++i;
        }
        return number;
    }

    public Pipes GetPipes(int indexgrouptaps, int numberofopentaps) {
        Pipes pipes = (Pipes)this.elementAt(0);
        int index = 0;
        while (pipes.indexgrouptaps != indexgrouptaps) {
            pipes = (Pipes)this.elementAt(++index);
        }
        pipes = (Pipes)this.elementAt(index + numberofopentaps - 1);
        return pipes;
    }

    public void GetSuivPred(Nodes nodes) {
        nodes.suiv = new Vector();
        nodes.pred = new Vector();
        int i = 0;
        while (i < this.size()) {
            Pipes pipes = (Pipes)this.elementAt(i);
            if (nodes.nodes.equalsIgnoreCase(pipes.nodes_beg)) {
                nodes.suiv.addElement(pipes.nodes_end);
            }
            if (nodes.nodes.equalsIgnoreCase(pipes.nodes_end)) {
                nodes.pred.addElement(pipes.nodes_beg);
            }
            ++i;
        }
    }

    public int GetNumberOfPred(Nodes nodes) {
        int numberofpred = 0;
        int i = 0;
        while (i < this.size()) {
            Pipes pipes = (Pipes)this.elementAt(i);
            if (nodes.nodes.equalsIgnoreCase(pipes.nodes_end)) {
                ++numberofpred;
            }
            ++i;
        }
        return numberofpred;
    }

    public void CalculSpeed() {
        int i = 0;
        while (i < this.size()) {
            Pipes pipes = (Pipes)this.elementAt(i);
            pipes.speed = pipes.moyenne / 1000.0 * 4.0 / 3.14 / Math.pow(pipes.d1, 2.0);
            pipes.speedmin = pipes.min / 1000.0 * 4.0 / 3.14 / Math.pow(pipes.d1, 2.0);
            pipes.speedmax = pipes.max / 1000.0 * 4.0 / 3.14 / Math.pow(pipes.d1, 2.0);
            ++i;
        }
    }
}

