/*
 * Decompiled with CFR 0.152.
 */
package neatwork.core.defs;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Enumeration;
import java.util.Properties;
import java.util.Vector;
import neatwork.core.defs.Diameters;

public class DiametersVector
extends Vector {
    private final String taFile = "t-a.properties";
    private final String dbaFile = "d-b-a.properties";

    public DiametersVector(Vector data, Properties prop) {
        double temperature = Double.parseDouble(prop.getProperty("topo.watertemp.value", "70"));
        temperature = 9.0 * temperature / 5.0 + 32.0;
        double a = this.calculA(temperature);
        Enumeration e = data.elements();
        while (e.hasMoreElements()) {
            double beta;
            double q;
            double p;
            Vector line = (Vector)e.nextElement();
            String nominal = line.get(0).toString();
            double SDR = Double.parseDouble(line.get(1).toString());
            double diameter = Double.parseDouble(line.get(2).toString());
            double cost = Double.parseDouble(line.get(3).toString());
            double length = Double.parseDouble(line.get(4).toString());
            int type = Integer.parseInt(line.get(5).toString());
            double rugosite = Double.parseDouble(line.get(6).toString());
            switch (type) {
                case 1: {
                    p = 1.781;
                    q = 4.781;
                    beta = 0.019411 * Math.pow(a * 1000000.0, -0.219);
                    break;
                }
                default: {
                    Double ironA = new Double(0.0);
                    Double ironB = new Double(0.0);
                    this.calculIron(rugosite / diameter, ironA, ironB);
                    p = 2.0 - ironB;
                    q = 5.0 - ironB;
                    beta = 0.0826 * ironA * Math.pow(a * 1000000.0, -ironB.doubleValue());
                }
            }
            this.addDiameters(nominal, diameter, SDR, length, cost, type, rugosite, p, q, beta);
        }
    }

    public void addDiameters(String nominal, double diam, double SDR, double length, double cost, int type, double rugosite, double p, double q, double beta) {
        Diameters d = new Diameters(nominal, diam, SDR, length, cost, type, rugosite, p, q, beta);
        this.addElement(d);
    }

    public Diameters getDiameters(double d) {
        Diameters diam = null;
        int i = 0;
        diam = (Diameters)this.elementAt(i);
        while (i < this.size() - 1 && Math.abs(diam.diam - d) > 1.0E-4) {
            diam = (Diameters)this.elementAt(++i);
        }
        if (Math.abs(diam.diam - d) > 1.0E-4) {
            return null;
        }
        return diam;
    }

    public double getCost(double d) {
        int j = 0;
        Diameters diam = (Diameters)this.get(j);
        while (diam.diam != d) {
            diam = (Diameters)this.get(++j);
        }
        return diam.cost;
    }

    private double calculA(double temperature) {
        double t1 = 0.0;
        double t2 = 0.0;
        double a1 = 0.0;
        double a2 = 0.0;
        try {
            String line;
            BufferedReader lecture = new BufferedReader(new InputStreamReader(this.getClass().getResourceAsStream("t-a.properties")));
            while ((line = lecture.readLine()) != null && line != "" && t2 < temperature) {
                int indice = line.indexOf(",");
                String ts = line.substring(0, indice);
                String as = line.substring(indice + 1, line.length());
                try {
                    t2 = Double.parseDouble(ts);
                    a2 = Double.parseDouble(as);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
                if (!(t2 < temperature)) continue;
                t1 = t2;
                a1 = a2;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (t2 > temperature) {
            return a1 + (a2 - a1) * (temperature - t1) / (t2 - t1);
        }
        return a2;
    }

    private void calculIron(double frac, Double ironA, Double ironB) {
        double frac1 = 0.0;
        double frac2 = 0.0;
        double A1 = 0.0;
        double A2 = 0.0;
        double B1 = 0.0;
        double B2 = 0.0;
        BufferedReader lecture = null;
        lecture = new BufferedReader(new InputStreamReader(this.getClass().getResourceAsStream("d-b-a.properties")));
        try {
            String line;
            while ((line = lecture.readLine()) != null && line != "" && frac2 < frac) {
                int indice = line.indexOf(",");
                int indice2 = line.lastIndexOf(",");
                String fracs = line.substring(0, indice);
                String Bs = line.substring(indice + 1, indice2);
                String As = line.substring(indice2 + 1, line.length());
                try {
                    frac2 = Double.parseDouble(fracs);
                    B2 = Double.parseDouble(Bs);
                    A2 = Double.parseDouble(As);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
                if (!(frac2 < frac)) continue;
                frac1 = frac2;
                A1 = A2;
                B1 = B2;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (frac2 > frac) {
            ironA = new Double(A1 + (A2 - A1) * (frac - frac1) / (frac2 - frac1));
            ironB = new Double(B1 + (B2 - B1) * (frac - frac1) / (frac2 - frac1));
        } else {
            ironA = new Double(A2);
            ironB = new Double(B2);
        }
    }
}

