/*
 * Decompiled with CFR 0.152.
 */
package neatwork.core.defs;

import java.util.Enumeration;
import java.util.StringTokenizer;
import java.util.Vector;
import neatwork.Messages;
import neatwork.core.defs.Diameters;
import neatwork.core.defs.DiametersVector;
import neatwork.core.defs.Nodes;
import neatwork.core.defs.NodesVector;
import neatwork.core.defs.OrificesVector;
import neatwork.core.defs.Pipes;
import neatwork.core.defs.PipesVector;
import neatwork.core.defs.Taps;
import neatwork.core.defs.TapsVector;
import neatwork.utils.Tools;

public class CoreDesign {
    public PipesVector pvector = new PipesVector();
    public NodesVector nvector = new NodesVector();
    public TapsVector tvector = new TapsVector();
    private OrificesVector ovector;
    private DiametersVector dvector;

    public CoreDesign(Vector data, DiametersVector dvector, OrificesVector ovector) {
        String prefixgrouptaps = " ";
        int indexgrouptaps = 1;
        this.dvector = dvector;
        this.ovector = ovector;
        this.nvector.addNodes(((Vector)data.get(0)).get(0).toString(), 0.0, 0);
        data.remove(0);
        boolean index = false;
        Enumeration e = data.elements();
        while (e.hasMoreElements()) {
            Nodes nodes;
            Vector v = (Vector)e.nextElement();
            String nod = v.get(0).toString();
            String pred = v.get(1).toString();
            double height = 0.0;
            try {
                height = Double.parseDouble(v.get(2).toString());
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            double length = 0.0;
            try {
                length = Double.parseDouble(v.get(3).toString());
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            int tap = 0;
            try {
                tap = Integer.parseInt(v.get(4).toString());
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            double lp1 = 0.0;
            try {
                lp1 = Double.parseDouble(v.get(5).toString());
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            double lp2 = 0.0;
            try {
                lp2 = Double.parseDouble(v.get(6).toString());
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            double dp1 = 0.0;
            try {
                dp1 = Double.parseDouble(v.get(7).toString());
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            double dp2 = 0.0;
            try {
                dp2 = Double.parseDouble(v.get(8).toString());
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            double ori = 0.0;
            try {
                ori = Double.parseDouble(v.get(9).toString());
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            double ori2 = 0.0;
            try {
                ori2 = Double.parseDouble(v.get(10).toString());
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            this.nvector.addNodes(nod, height, tap);
            this.pvector.addPipes(pred, nod, length);
            Pipes pipes = (Pipes)this.pvector.lastElement();
            pipes.l1 = lp1;
            pipes.l2 = lp2;
            pipes.d1 = dp1;
            pipes.d2 = dp2;
            Diameters diam1 = dvector.getDiameters(dp1);
            pipes.p1 = diam1.p;
            pipes.q1 = diam1.q;
            pipes.beta1 = diam1.beta;
            if (lp2 != 0.0) {
                Diameters diam2 = dvector.getDiameters(dp2);
                pipes.p2 = diam2.p;
                pipes.q2 = diam2.q;
                pipes.beta2 = diam2.beta;
            }
            if (tap != 1) continue;
            StringTokenizer T = new StringTokenizer(pipes.nodes_end, "_");
            if (T.countTokens() > 1) {
                String prefix = T.nextToken();
                nodes = (Nodes)this.nvector.lastElement();
                if (!prefixgrouptaps.equals(prefix)) {
                    // empty if block
                }
                pipes.indexgrouptaps = ++indexgrouptaps;
                nodes.indexgrouptaps = indexgrouptaps;
                prefixgrouptaps = prefix;
            }
            int i = 0;
            do {
                nodes = (Nodes)this.nvector.elementAt(++i);
            } while (!nodes.nodes.equalsIgnoreCase(nod));
            nodes.taps = 1;
            this.tvector.addTaps(nod);
            Taps taps = (Taps)this.tvector.lastElement();
            taps.orif_ideal = ori;
            taps.orif_com = ori2;
            taps.orifice = ori;
        }
        this.attribSummary();
    }

    public double getCost() {
        double cost = 0.0;
        int i = 0;
        while (i < this.pvector.size()) {
            Pipes pipes = (Pipes)this.pvector.elementAt(i);
            double c1 = pipes.l1 != 0.0 ? this.dvector.getCost(pipes.d1) : 0.0;
            double c2 = pipes.l2 != 0.0 ? this.dvector.getCost(pipes.d2) : 0.0;
            cost += c1 * pipes.l1 + c2 * pipes.l2;
            ++i;
        }
        return cost;
    }

    public Vector getSummaryData() {
        Vector v = new Vector();
        int i = 0;
        while (i < this.dvector.size()) {
            Diameters diam = (Diameters)this.dvector.get(i);
            if (diam.summary > 0.1) {
                Vector<String> line = new Vector<String>();
                line.add(diam.nominal);
                line.add(Tools.doubleFormat("0.##", diam.SDR));
                line.add(Tools.doubleFormat("0.####", diam.diam));
                line.add(Tools.doubleFormat("0.#", diam.summary));
                line.add(Tools.doubleFormat("0.#", diam.cost));
                line.add(Tools.doubleFormat("0.#", diam.cost * diam.summary));
                v.add(line);
            }
            ++i;
        }
        return v;
    }

    public static Vector getSummaryHeader() {
        Vector<String> v = new Vector<String>();
        v.add(Messages.getString("CoreDesign.Nominal"));
        v.add(Messages.getString("CoreDesign.SDR"));
        v.add(Messages.getString("CoreDesign.Diameter"));
        v.add(Messages.getString("CoreDesign.Total_length"));
        v.add(Messages.getString("CoreDesign.Unit_Cost"));
        v.add(Messages.getString("CoreDesign.Total_cost"));
        return v;
    }

    private void attribSummary() {
        Enumeration e = this.dvector.elements();
        while (e.hasMoreElements()) {
            ((Diameters)e.nextElement()).summary = 0.0;
        }
        e = this.pvector.elements();
        while (e.hasMoreElements()) {
            Pipes pipes = (Pipes)e.nextElement();
            this.dvector.getDiameters((double)pipes.d1).summary += pipes.l1;
            if (pipes.l2 == 0.0) continue;
            this.dvector.getDiameters((double)pipes.d2).summary += pipes.l2;
        }
    }

    public Vector getData() {
        Vector v = new Vector();
        Vector<String> source = new Vector<String>();
        source.add(((Nodes)this.nvector.get((int)0)).nodes);
        source.add(((Nodes)this.nvector.get((int)0)).nodes);
        int i = 0;
        while (i < 9) {
            source.add("0");
            ++i;
        }
        v.add(source);
        i = 0;
        while (i < this.pvector.size()) {
            Pipes pipes = (Pipes)this.pvector.get(i);
            Nodes nodes = (Nodes)this.nvector.get(i + 1);
            Vector<String> line = new Vector<String>();
            line.add(pipes.nodes_end);
            line.add(pipes.nodes_beg);
            line.add(String.valueOf(nodes.height));
            line.add(String.valueOf(pipes.length));
            line.add(String.valueOf(nodes.taps));
            line.add(String.valueOf(Math.round(pipes.l1)));
            line.add(String.valueOf(Math.round(pipes.l2)));
            line.add(Tools.doubleFormat("0.####", pipes.d1));
            line.add(Tools.doubleFormat("0.####", pipes.d2));
            if (this.tvector.isTaps(nodes.nodes)) {
                Taps taps = (Taps)this.tvector.get(i - this.pvector.size() + this.tvector.size());
                line.add(Tools.doubleFormat("0.####", taps.orif_ideal));
                line.add(Tools.doubleFormat("0.####", taps.orif_com));
            } else {
                line.add("0");
                line.add("0");
            }
            v.add(line);
            ++i;
        }
        return v;
    }

    public static Vector getHeader() {
        Vector<String> v = new Vector<String>();
        v.add(Messages.getString("CoreDesign.Node_ID"));
        v.add(Messages.getString("CoreDesign.Pred._node"));
        v.add(Messages.getString("CoreDesign.Height"));
        v.add(Messages.getString("CoreDesign.Length"));
        v.add(Messages.getString("CoreDesign._#_of_taps"));
        v.add(Messages.getString("CoreDesign.length_pipe1"));
        v.add(Messages.getString("CoreDesign.length_pipe2"));
        v.add(Messages.getString("CoreDesign.diam_pipe1"));
        v.add(Messages.getString("CoreDesign.diam_pipe2"));
        v.add(Messages.getString("CoreDesign.ideal_orifice"));
        v.add(Messages.getString("CoreDesign.comercial_orifice"));
        return v;
    }
}

