/*
 * Decompiled with CFR 0.152.
 */
package neatwork.core;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;
import neatwork.Messages;
import neatwork.core.defs.CoreDesign;
import neatwork.core.defs.DiametersVector;
import neatwork.core.defs.Nodes;
import neatwork.core.defs.OrificesVector;
import neatwork.core.defs.Pipes;
import neatwork.core.defs.Taps;
import neatwork.core.run.RunSimulation;
import neatwork.solver.AbstractSolver;
import neatwork.utils.Tools;

public class MakeSimulation {
    private CoreDesign dsg;
    private DiametersVector dvector;
    private Properties properties;
    private double rate;
    private int nbsim;
    private String typeSimu;

    public MakeSimulation(CoreDesign design, DiametersVector dvector, OrificesVector ovector, Properties prop, Hashtable faucetRef, AbstractSolver solver) {
        RunSimulation runSimulation;
        Taps taps;
        int i;
        int nbSim;
        String typeSimulation;
        this.dsg = design;
        this.properties = prop;
        String typeOrifice = prop.getProperty("simu.typeorifice.value", "ideal");
        this.typeSimu = typeSimulation = prop.getProperty("simu.typesimu.value", "random");
        this.nbsim = nbSim = Integer.parseInt(prop.getProperty("simu.nbsim.value", "10"));
        double outflow = Double.parseDouble(prop.getProperty("topo.targetflow.value", "0.2")) / 1000.0;
        double alpha = Double.parseDouble(prop.getProperty("topo.faucetcoef.value", "0.00000002"));
        double rate1 = 1.0;
        try {
            rate1 = Double.parseDouble(prop.getProperty("simu.simopentaps.value", "0.4"));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        this.rate = rate1;
        double seuil = Double.parseDouble(prop.getProperty("simu.mincriticalflow.value", "0.1"));
        double seuil2 = Double.parseDouble(prop.getProperty("simu.maxcriticalflow.value", "0.3"));
        double coeffOrifice = Double.parseDouble(prop.getProperty("topo.orifcoef.value", "0.59"));
        this.ajoutNodes();
        if (!this.isTree()) {
            this.addInversBranch();
        }
        if (typeOrifice.equals("ideal")) {
            i = 0;
            while (i < this.dsg.tvector.size()) {
                taps = (Taps)this.dsg.tvector.get(i);
                taps.orifice = taps.orif_ideal;
                ++i;
            }
        } else {
            i = 0;
            while (i < this.dsg.tvector.size()) {
                taps = (Taps)this.dsg.tvector.get(i);
                taps.orifice = taps.orif_com;
                ++i;
            }
        }
        int n = dvector.size() * this.dsg.pvector.size() + this.dsg.nvector.size() - 1;
        int m = this.dsg.nvector.size() + this.dsg.pvector.size();
        double[] F = new double[this.dsg.tvector.size() + this.dsg.pvector.size() * 2 + 1];
        int k = 0;
        while (k < this.dsg.tvector.size()) {
            ((Taps)this.dsg.tvector.get((int)k)).faucetCoef = alpha;
            ++k;
        }
        if (typeSimulation.equals("random")) {
            this.dsg.pvector.initializeSimulation(nbSim);
            this.dsg.nvector.initializeSimulation(nbSim);
            int i2 = 0;
            while (i2 < nbSim) {
                solver.setProgress(Math.round((float)i2 / (float)nbSim * 100.0f));
                runSimulation = new RunSimulation(F, this.dsg.nvector, this.dsg.pvector, this.dsg.tvector, outflow, rate1, seuil, seuil2, typeSimulation, i2, coeffOrifice);
                ++i2;
            }
        }
        if (typeSimulation.equals("tapbytap")) {
            this.dsg.pvector.initializeSimulation(this.dsg.tvector.size());
            this.dsg.nvector.initializeSimulation(this.dsg.tvector.size());
            RunSimulation i2 = new RunSimulation(F, this.dsg.nvector, this.dsg.pvector, this.dsg.tvector, outflow, rate1, seuil, seuil2, typeSimulation, this.dsg.tvector.size(), coeffOrifice, solver);
        }
        if (typeSimulation.equals("handmade")) {
            Enumeration enun = this.dsg.tvector.elements();
            while (enun.hasMoreElements()) {
                Taps tap = (Taps)enun.nextElement();
                tap.select = "close";
                if (faucetRef.get(tap.taps) == null || !faucetRef.get(tap.taps).equals(new Boolean(true))) continue;
                tap.select = "open";
            }
            this.dsg.pvector.initializeSimulation(1);
            this.dsg.nvector.initializeSimulation(1);
            solver.setProgress(50);
            runSimulation = new RunSimulation(F, this.dsg.nvector, this.dsg.pvector, this.dsg.tvector, outflow, rate1, seuil, seuil2, typeSimulation, 0, coeffOrifice);
        }
        this.dsg.pvector.CalculSpeed();
        this.calculQuartile();
        this.calculStatPressure();
    }

    private void ajoutNodes() {
        int i = 0;
        while (i < this.dsg.pvector.size()) {
            Pipes pipes = (Pipes)this.dsg.pvector.elementAt(i);
            if (pipes.l2 != 0.0) {
                Nodes n1 = (Nodes)this.dsg.nvector.elementAt(this.dsg.nvector.getPosition(pipes.nodes_beg));
                Nodes n2 = (Nodes)this.dsg.nvector.elementAt(this.dsg.nvector.getPosition(pipes.nodes_end));
                Pipes pip = new Pipes(String.valueOf(pipes.nodes_beg) + "*" + pipes.nodes_end, pipes.nodes_end, String.valueOf(pipes.nodes_beg) + "*" + pipes.nodes_end, 0.0);
                pipes.nodes_end = String.valueOf(pipes.nodes_beg) + "*" + pipes.nodes_end;
                pip.l1 = pipes.l2;
                pip.d1 = pipes.d2;
                pip.p1 = pipes.p2;
                pip.q1 = pipes.q2;
                pip.beta1 = pipes.beta2;
                Nodes nodes = new Nodes(pipes.nodes_end, 0.0, 0);
                nodes.ajout = 1;
                nodes.height = n1.height + (n2.height - n1.height) / pipes.length * pipes.l1;
                if (i >= this.dsg.pvector.size() - 1 - this.dsg.tvector.size()) {
                    ++i;
                    this.dsg.nvector.add(this.dsg.nvector.size() - this.dsg.tvector.size(), nodes);
                    this.dsg.pvector.add(this.dsg.pvector.size() - this.dsg.tvector.size(), pip);
                } else {
                    this.dsg.nvector.add(i + 1, nodes);
                    this.dsg.pvector.add(i + 1, pip);
                }
            }
            ++i;
        }
    }

    public String getPropertiesContent() {
        String content = "";
        content = String.valueOf(content) + Messages.getString("MakeSimulation.Default_properties");
        Enumeration<?> iter = this.properties.propertyNames();
        while (iter.hasMoreElements()) {
            String name = iter.nextElement().toString();
            if (!name.startsWith("simu.") || !name.endsWith(".value")) continue;
            content = String.valueOf(content) + name.substring(5, name.length() - 6) + "," + this.properties.getProperty(name) + ",N\n";
        }
        return content;
    }

    public Vector getResultsSimu() {
        Vector v = new Vector();
        int i = this.dsg.pvector.size() - this.dsg.tvector.size();
        while (i < this.dsg.pvector.size()) {
            Pipes pipes = (Pipes)this.dsg.pvector.get(i);
            if (this.dsg.nvector.getNbTaps(pipes.nodes_end) == 0) {
                String name = pipes.nodes_end;
                if (name.lastIndexOf("*") > 0) {
                    name = name.substring(name.lastIndexOf("*") + 1, name.length());
                }
                if (name.lastIndexOf("_") > 0) {
                    int n = name.substring(name.lastIndexOf("_") + 1, name.length()).charAt(0) - 97 + 1;
                    name = String.valueOf(name.substring(0, name.lastIndexOf("_") + 1)) + n;
                }
                Vector<String> line = new Vector<String>();
                line.add(name);
                line.add(Tools.doubleFormat("0.####", pipes.min));
                line.add(Tools.doubleFormat("0.####", pipes.moyenne));
                line.add(Tools.doubleFormat("0.####", pipes.max));
                int j = 0;
                while (j < pipes.simulation.length) {
                    line.add(Tools.doubleFormat("0.####", pipes.simulation[j]));
                    ++j;
                }
                v.add(line);
            }
            ++i;
        }
        return v;
    }

    public Vector getSimpleResultsSimu() {
        Vector v = new Vector();
        int totsim = 0;
        int tots1 = 0;
        int tots2 = 0;
        int totfail = 0;
        double totmin = 5.0E8;
        double totmax = -1.0;
        double totmoy = 0.0;
        int i = this.dsg.pvector.size() - this.dsg.tvector.size();
        while (i < this.dsg.pvector.size()) {
            Pipes pipes = (Pipes)this.dsg.pvector.get(i);
            Vector<String> line = new Vector<String>();
            String name = pipes.nodes_end;
            if (name.lastIndexOf("*") > 0) {
                name = name.substring(name.lastIndexOf("*") + 1, name.length());
            }
            if (name.lastIndexOf("_") > 0) {
                int n = name.substring(name.lastIndexOf("_") + 1, name.length()).charAt(0) - 97 + 1;
                name = String.valueOf(name.substring(0, name.lastIndexOf("_") + 1)) + n;
            }
            line.add(name);
            line.add("" + pipes.nbsim);
            totsim += pipes.nbsim;
            line.add(Tools.doubleFormat("0.####", pipes.min));
            line.add(Tools.doubleFormat("0.####", pipes.moyenne));
            totmoy += pipes.moyenne * (double)pipes.nbsim;
            line.add(Tools.doubleFormat("0.####", pipes.max));
            double variability = 0.0;
            try {
                variability = Math.sqrt(pipes.moyennec - pipes.moyenne * pipes.moyenne) / pipes.moyenne * 100.0;
            }
            catch (Exception exception) {
                // empty catch block
            }
            line.add(Tools.doubleFormat("0.##", variability));
            line.add(Tools.doubleFormat("0.##", pipes.seuil / (double)pipes.nbsim * 100.0));
            tots1 = (int)((double)tots1 + pipes.seuil);
            line.add(Tools.doubleFormat("0.##", pipes.seuil2 / (double)pipes.nbsim * 100.0));
            tots2 = (int)((double)tots2 + pipes.seuil2);
            line.add("" + pipes.failure);
            totfail += pipes.failure;
            line.add("-1");
            v.add(line);
            ++i;
        }
        Vector<String> line = new Vector<String>();
        line.add(Messages.getString("MakeSimulation.Global_average"));
        line.add("-");
        line.add("-");
        line.add(Tools.doubleFormat("0.####", totmoy / (double)totsim));
        line.add("-");
        line.add("?");
        line.add(Tools.doubleFormat("0.##", (double)tots1 / (double)totsim * 100.0));
        line.add(Tools.doubleFormat("0.##", (double)tots2 / (double)totsim * 100.0));
        line.add("" + totfail);
        line.add("-1");
        v.insertElementAt(line, 0);
        return v;
    }

    public Vector getPressureSimu() {
        Vector v = new Vector();
        int i = 0;
        while (i < this.dsg.nvector.size()) {
            Nodes nodes = (Nodes)this.dsg.nvector.get(i);
            Vector<String> line = new Vector<String>();
            line.add(nodes.nodes);
            line.add(Tools.doubleFormat("0.##", nodes.minpress));
            line.add(Tools.doubleFormat("0.##", nodes.averpress));
            line.add(Tools.doubleFormat("0.##", nodes.maxpress));
            v.add(line);
            ++i;
        }
        return v;
    }

    public Vector getSpeedSimu() {
        Vector v = new Vector();
        int i = 0;
        while (i < this.dsg.pvector.size()) {
            Pipes pipes = (Pipes)this.dsg.pvector.get(i);
            Vector<String> line = new Vector<String>();
            String name = pipes.nodes_end;
            if (name.lastIndexOf("_") > 0) {
                int n = name.substring(name.lastIndexOf("_") + 1, name.length()).charAt(0) - 97 + 1;
                name = String.valueOf(name.substring(0, name.lastIndexOf("_") + 1)) + n;
            }
            line.add(String.valueOf(pipes.nodes_beg) + " -> " + name);
            line.add("" + pipes.nbsim);
            line.add(Tools.doubleFormat("0.##", pipes.speed));
            line.add(Tools.doubleFormat("0.##", pipes.speedmax));
            line.add("-1");
            v.add(line);
            ++i;
        }
        return v;
    }

    public Vector getQuartileSimu() {
        Vector v = new Vector();
        int i = this.dsg.pvector.size() - this.dsg.tvector.size();
        while (i < this.dsg.pvector.size()) {
            Pipes pipes = (Pipes)this.dsg.pvector.get(i);
            Vector<String> line = new Vector<String>();
            String name = pipes.nodes_end;
            if (name.lastIndexOf("*") > 0) {
                name = name.substring(name.lastIndexOf("*") + 1, name.length());
            }
            if (name.lastIndexOf("_") > 0) {
                int n = name.substring(name.lastIndexOf("_") + 1, name.length()).charAt(0) - 97 + 1;
                name = String.valueOf(name.substring(0, name.lastIndexOf("_") + 1)) + n;
            }
            line.add(name);
            line.add("" + pipes.nbsim);
            line.add(Tools.doubleFormat("0.####", pipes.min));
            line.add(Tools.doubleFormat("0.####", pipes.quart10));
            line.add(Tools.doubleFormat("0.####", pipes.quart25));
            line.add(Tools.doubleFormat("0.####", pipes.quart50));
            line.add(Tools.doubleFormat("0.####", pipes.quart75));
            line.add(Tools.doubleFormat("0.####", pipes.quart90));
            line.add(Tools.doubleFormat("0.####", pipes.max));
            line.add("N");
            line.add("N");
            v.add(line);
            ++i;
        }
        return v;
    }

    private void calculQuartile() {
        int k = this.dsg.pvector.size() - this.dsg.tvector.size();
        while (k < this.dsg.pvector.size()) {
            int i;
            Pipes pipes = (Pipes)this.dsg.pvector.get(k);
            double[] simu = new double[pipes.simulation.length];
            int i2 = 0;
            while (i2 < pipes.simulation.length) {
                simu[i2] = pipes.simulation[i2];
                ++i2;
            }
            boolean bool = false;
            while (!bool) {
                bool = true;
                i = 0;
                while (i < simu.length - 1) {
                    if (simu[i] > simu[i + 1] && simu[i + 1] != 0.0 || simu[i] < simu[i + 1] && simu[i] == 0.0) {
                        bool = false;
                        double tamp = simu[i];
                        simu[i] = simu[i + 1];
                        simu[i + 1] = tamp;
                    }
                    ++i;
                }
            }
            i = simu.length - 1;
            while (i > pipes.failure - 1) {
                simu[i] = simu[i - pipes.failure];
                --i;
            }
            i = 0;
            while (i < pipes.failure - 1) {
                simu[i] = 0.0;
                ++i;
            }
            pipes.quart10 = simu[(int)Math.floor((double)pipes.nbsim * 0.1)];
            pipes.quart25 = simu[(int)Math.floor((double)pipes.nbsim * 0.25)];
            pipes.quart50 = simu[(int)Math.floor((double)pipes.nbsim * 0.5)];
            pipes.quart75 = simu[(int)Math.floor((double)pipes.nbsim * 0.75)];
            pipes.quart90 = simu[(int)Math.floor((double)pipes.nbsim * 0.9)];
            double ecart = pipes.max - pipes.min;
            pipes.quarteff10 = 0;
            pipes.quarteff25 = 0;
            pipes.quarteff50 = 0;
            pipes.quarteff75 = 0;
            pipes.quarteff100 = pipes.nbsim;
            int i3 = 0;
            while (i3 < simu.length) {
                if (simu[i3] <= ecart * 0.1 + pipes.min) {
                    ++pipes.quarteff10;
                }
                if (simu[i3] <= ecart * 0.25 + pipes.min) {
                    ++pipes.quarteff25;
                }
                if (simu[i3] <= ecart * 0.5 + pipes.min) {
                    ++pipes.quarteff50;
                }
                if (simu[i3] <= ecart * 0.75 + pipes.min) {
                    ++pipes.quarteff75;
                }
                if (simu[i3] <= ecart * 0.9 + pipes.min) {
                    ++pipes.quarteff90;
                }
                ++i3;
            }
            pipes.quarteff100 = (int)((double)pipes.quarteff100 - pipes.quart90);
            pipes.quarteff100 *= 10;
            pipes.quarteff90 = (int)((double)pipes.quarteff90 - pipes.quart75);
            pipes.quarteff90 *= 6;
            pipes.quarteff75 = (int)((double)pipes.quarteff75 - pipes.quart50);
            pipes.quarteff75 *= 4;
            pipes.quarteff50 = (int)((double)pipes.quarteff50 - pipes.quart25);
            pipes.quarteff50 *= 4;
            pipes.quarteff25 = (int)((double)pipes.quarteff25 - pipes.quart10);
            pipes.quarteff50 *= 6;
            pipes.quarteff10 *= 10;
            ++k;
        }
    }

    private void calculStatPressure() {
        int i = 1;
        while (i < this.dsg.nvector.size()) {
            Nodes nodes = (Nodes)this.dsg.nvector.get(i);
            nodes.minpress = 10000.0;
            nodes.maxpress = nodes.pressim[0];
            int j = 0;
            while (j < nodes.pressim.length) {
                if (nodes.pressim[j] == 0.0) {
                    nodes.pressim[j] = -nodes.height;
                }
                nodes.averpress += nodes.pressim[j];
                if (nodes.pressim[j] < nodes.minpress) {
                    nodes.minpress = nodes.pressim[j];
                }
                if (nodes.pressim[j] > nodes.maxpress) {
                    nodes.maxpress = nodes.pressim[j];
                }
                ++j;
            }
            nodes.averpress /= (double)nodes.pressim.length;
            ++i;
        }
    }

    private boolean isTree() {
        boolean tree = true;
        Enumeration e = this.dsg.nvector.elements();
        while (tree && e.hasMoreElements()) {
            Nodes n = (Nodes)e.nextElement();
            if (this.dsg.pvector.GetNumberOfPred(n) <= 1) continue;
            tree = false;
        }
        return tree;
    }

    private void addInversBranch() {
        Nodes source = (Nodes)this.dsg.nvector.elementAt(0);
        int i = 0;
        while (i < this.dsg.pvector.size()) {
            Pipes pipes = (Pipes)this.dsg.pvector.elementAt(i);
            if (this.dsg.nvector.getNbTaps(pipes.nodes_end) == 0 && !this.dsg.tvector.isTaps(pipes.nodes_end) && !pipes.nodes_beg.equalsIgnoreCase(source.nodes)) {
                Pipes invpipes = new Pipes(pipes.nodes_end, pipes.nodes_beg, pipes.nodes_end, 0.0);
                invpipes.l1 = pipes.l1;
                invpipes.l2 = pipes.l2;
                invpipes.d1 = pipes.d1;
                invpipes.d2 = pipes.d2;
                invpipes.beta1 = pipes.beta1;
                invpipes.beta2 = pipes.beta2;
                invpipes.p1 = pipes.p1;
                invpipes.p2 = pipes.p2;
                invpipes.q1 = pipes.q1;
                invpipes.q2 = pipes.q2;
                this.dsg.pvector.insertElementAt(invpipes, 1);
                ++i;
            }
            ++i;
        }
    }
}

