/*
 * Decompiled with CFR 0.152.
 */
package neatwork.core;

import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;
import neatwork.Messages;
import neatwork.core.defs.CoreTopographie;
import neatwork.core.defs.Diameters;
import neatwork.core.defs.DiametersVector;
import neatwork.core.defs.Nodes;
import neatwork.core.defs.Orifices;
import neatwork.core.defs.OrificesVector;
import neatwork.core.defs.Pipes;
import neatwork.core.defs.Taps;
import neatwork.core.run.RunMakeDesign;
import neatwork.utils.LoiNormale;
import neatwork.utils.Tools;

public class MakeDesign {
    private double[] x;
    private CoreTopographie topo;
    private DiametersVector dvector;
    private Vector diametresContent;
    private Vector orificeContent;
    private Hashtable loadFactor;

    public MakeDesign(CoreTopographie topo, DiametersVector dvector, OrificesVector ovector, Properties prop, Hashtable LoadFactor) {
        this.topo = topo;
        this.dvector = dvector;
        this.loadFactor = LoadFactor;
        double outflow = Double.parseDouble(prop.getProperty("topo.targetflow.value", "0.2")) / 1000.0;
        double qualite = Double.parseDouble(prop.getProperty("topo.servicequal.value", "0.8"));
        double rated = Double.parseDouble(prop.getProperty("topo.opentaps.value", "0.4"));
        double length_com = Double.parseDouble(prop.getProperty("topo.pipelength.value", "6.0"));
        double alpha = Double.parseDouble(prop.getProperty("topo.faucetcoef.value", "0.00000002"));
        double prixMax = Double.parseDouble(prop.getProperty("topo.limitbudget.value", "1000000000"));
        double coeffOrifice = Double.parseDouble(prop.getProperty("topo.orifcoef.value", "0.59"));
        double[] proba = MakeDesign.calculProba(outflow, topo.tvector.size(), rated, qualite);
        this.getAllPath();
        double[] loadFactor1 = new double[topo.pvector.size()];
        int i = 0;
        while (i < topo.pvector.size()) {
            Pipes pipes = (Pipes)topo.pvector.elementAt(i);
            loadFactor1[i] = Double.parseDouble(LoadFactor.get(pipes.nodes_end).toString()) * outflow;
            ++i;
        }
        int n = dvector.size() * topo.pvector.size() + topo.nvector.size() - 1;
        int m = topo.nvector.size() + topo.pvector.size();
        this.x = new double[n];
        int i2 = 0;
        while (i2 < topo.tvector.size()) {
            ((Taps)topo.tvector.get((int)i2)).faucetCoef = alpha;
            ++i2;
        }
        RunMakeDesign design = new RunMakeDesign(this.x, topo.nvector, topo.pvector, topo.tvector, dvector, ovector, loadFactor1, outflow, length_com, n, m, prixMax, coeffOrifice);
        int cpt = 0;
        Hashtable<Integer, Vector> dejaFait = new Hashtable<Integer, Vector>();
        HashSet<Diameters> dejaFait2 = new HashSet<Diameters>();
        Enumeration<Object> enun = topo.pvector.elements();
        while (enun.hasMoreElements()) {
            Vector line;
            Pipes p = (Pipes)enun.nextElement();
            Integer index = new Integer(p.refDiam1);
            if (!dejaFait.containsKey(index)) {
                line = this.diametreVector(++cpt, (Diameters)dvector.get(index));
                dejaFait.put(index, line);
                dejaFait2.add((Diameters)dvector.get(index));
                p.refDiam1 = line.get(0).toString();
            } else {
                line = (Vector)dejaFait.get(index);
                p.refDiam1 = line.get(0).toString();
            }
            index = new Integer(p.refDiam2);
            if (p.l2 == 0.0) continue;
            if (!dejaFait.containsKey(index)) {
                line = this.diametreVector(++cpt, (Diameters)dvector.get(index));
                dejaFait.put(index, line);
                dejaFait2.add((Diameters)dvector.get(index));
                p.refDiam2 = line.get(0).toString();
                continue;
            }
            line = (Vector)dejaFait.get(index);
            p.refDiam2 = line.get(0).toString();
        }
        enun = dejaFait.elements();
        this.diametresContent = new Vector();
        while (enun.hasMoreElements()) {
            this.diametresContent.add((Vector)enun.nextElement());
        }
        enun = dvector.elements();
        while (enun.hasMoreElements()) {
            Diameters item = (Diameters)enun.nextElement();
            if (dejaFait2.contains(item)) continue;
            this.diametresContent.add(this.diametreVector(++cpt, item));
        }
        this.orificeContent = new Vector();
        Enumeration e = ovector.elements();
        while (e.hasMoreElements()) {
            this.orificeContent.add("" + ((Orifices)e.nextElement()).diam);
        }
    }

    private Vector diametreVector(int cpt, Diameters d) {
        Vector<String> line = new Vector<String>();
        line.add("D" + Tools.doubleFormat("000", cpt));
        line.add(d.nominal);
        line.add("" + d.SDR);
        line.add("" + d.diam);
        line.add("" + d.cost);
        line.add("" + d.pression);
        line.add("" + d.type);
        line.add("" + d.rugosite);
        return line;
    }

    private void getAllPath() {
        int i = 0;
        while (i != this.topo.nvector.size()) {
            Nodes nodes = (Nodes)this.topo.nvector.elementAt(i);
            this.topo.pvector.getPath(nodes.nodes, nodes.path, this.topo.nvector, nodes.taps);
            ++i;
        }
    }

    public Vector getDesignData(double hsource) {
        Vector v = new Vector();
        Vector<Object> source = new Vector<Object>();
        source.add(((Nodes)this.topo.nvector.get((int)0)).nodes);
        source.add(((Nodes)this.topo.nvector.get((int)0)).nodes);
        source.add(new Double(hsource));
        int i = 0;
        while (i < 8) {
            source.add("0");
            ++i;
        }
        v.add(source);
        i = 0;
        while (i < this.topo.pvector.size()) {
            Pipes pipes = (Pipes)this.topo.pvector.get(i);
            Nodes nodes = (Nodes)this.topo.nvector.get(i + 1);
            Vector<String> line = new Vector<String>();
            line.add(pipes.nodes_end);
            line.add(pipes.nodes_beg);
            line.add(String.valueOf(nodes.height + hsource));
            line.add(String.valueOf(pipes.length));
            line.add(String.valueOf(nodes.taps));
            line.add(Tools.doubleFormat("0.###", pipes.l1));
            line.add(Tools.doubleFormat("0.###", pipes.l2));
            line.add(pipes.refDiam1);
            line.add(pipes.refDiam2);
            if (this.topo.tvector.isTaps(nodes.nodes)) {
                Taps taps = (Taps)this.topo.tvector.get(i - this.topo.pvector.size() + this.topo.tvector.size());
                line.add(Tools.doubleFormat("0.########", taps.orif_ideal));
                line.add(Tools.doubleFormat("0.########", taps.orif_com));
            } else {
                line.add("0");
                line.add("0");
            }
            v.add(line);
            ++i;
        }
        Enumeration enun = this.diametresContent.elements();
        while (enun.hasMoreElements()) {
            v.add(enun.nextElement());
        }
        enun = this.orificeContent.elements();
        while (enun.hasMoreElements()) {
            Vector<String> z = new Vector<String>();
            z.add(enun.nextElement().toString());
            z.add("N");
            z.add("N");
            z.add("N");
            z.add("N");
            z.add("N");
            v.add(z);
        }
        return v;
    }

    public Vector getResultPressureData(double hsource) {
        Vector v = new Vector();
        Vector<String> source = new Vector<String>();
        source.add(((Nodes)this.topo.nvector.get((int)0)).nodes);
        source.add(Tools.doubleFormat("0.##", hsource));
        int i = 0;
        while (i < 2) {
            source.add("0");
            ++i;
        }
        v.add(source);
        i = 1;
        while (i < this.topo.pvector.size() + 1) {
            Nodes nodes = (Nodes)this.topo.nvector.get(i);
            Vector<String> line = new Vector<String>();
            line.add(nodes.nodes);
            line.add(Tools.doubleFormat("0.##", nodes.height + hsource));
            line.add(Tools.doubleFormat("0.##", nodes.pressure));
            line.add(Tools.doubleFormat("0.##", nodes.suction));
            v.add(line);
            ++i;
        }
        return v;
    }

    public static Vector getResultPressureHeader() {
        Vector<String> v = new Vector<String>();
        v.add(Messages.getString("MakeDesign.ID"));
        v.add(Messages.getString("MakeDesign.Height"));
        v.add(Messages.getString("MakeDesign.Pressure"));
        v.add(Messages.getString("MakeDesign.Suction"));
        return v;
    }

    static double[] calculProba(double outflow, int n, double p, double qualite) {
        double[] proba = new double[n + 1];
        proba[1] = outflow;
        int i = 2;
        while (i < n + 1) {
            proba[i] = Math.min(outflow * MakeDesign.CalculProba2(i, p, qualite), outflow * (double)i);
            if (proba[i] < outflow) {
                proba[i] = outflow;
            }
            ++i;
        }
        return proba;
    }

    static double CalculSpeudoFrac(int n, double p, double qualite) {
        double pfrac = p;
        double l1 = qualite + (1.0 - qualite) * Math.pow(1.0 - pfrac, n);
        double l2 = LoiNormale.probaInter(((double)n * p - (double)n * pfrac) / Math.pow((double)n * pfrac * (1.0 - pfrac), 0.5));
        while (l1 < l2 - 0.03 || l1 > l2 + 0.03) {
            l1 = qualite + (1.0 - qualite) * Math.pow(1.0 - (pfrac -= 0.01), n);
            l2 = LoiNormale.probaInter(((double)n * p - (double)n * pfrac) / Math.pow((double)n * pfrac * (1.0 - pfrac), 0.5));
        }
        return pfrac;
    }

    static double CalculProba2(int n, double pfrac, double proba) {
        double resu = 0.0;
        double proba1 = proba * (1.0 - Math.pow(1.0 - pfrac, n)) + Math.pow(1.0 - pfrac, n);
        double t = LoiNormale.param(proba1);
        resu = t * Math.pow((double)n * pfrac * (1.0 - pfrac), 0.5) + (double)n * pfrac;
        return resu;
    }
}

